/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.helpers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.TypesBuilder;
import org.libreoffice.ide.eclipse.core.internal.helpers.Messages;
import org.libreoffice.ide.eclipse.core.internal.model.UnoidlProject;
import org.libreoffice.ide.eclipse.core.model.CompositeFactory;
import org.libreoffice.ide.eclipse.core.model.IUnoComposite;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.SDKContainer;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.language.AbstractLanguage;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;
import org.libreoffice.plugin.core.model.UnoPackage;

public class UnoidlProjectHelper {
    public static final String BUILD_BASIS = "build";
    public static final String SOURCE_BASIS = "/source";
    public static final String URD_BASIS = "/urd";
    public static final String IDL_BASIS = "/idl";
    public static final String DIST_BASIS = "dist";
    public static final String OO_PROFILE_BASIS = ".ooo-debug";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDefaultConfig(File file) {
        Properties properties = new Properties();
        properties.setProperty("project.idl", IDL_BASIS);
        properties.setProperty("project.build", BUILD_BASIS);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, Messages.getString("UnoidlProjectHelper.ConfigFileComment"));
        }
        catch (Exception exception) {
            PluginLogger.warning(Messages.getString("UnoidlProjectHelper.DefaultConfigFileError"), exception);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IUnoidlProject createStructure(UnoFactoryData unoFactoryData, IProgressMonitor iProgressMonitor) throws Exception {
        IUnoidlProject iUnoidlProject = null;
        IProject iProject = (IProject)unoFactoryData.getProperty("project_handle");
        UnoidlProjectHelper.createProject(iProject, iProgressMonitor);
        iUnoidlProject = ProjectsManager.getProject(iProject.getName());
        String string = (String)unoFactoryData.getProperty("project_prefix");
        iUnoidlProject.setCompanyPrefix(string);
        String string2 = (String)unoFactoryData.getProperty("project_comp");
        iUnoidlProject.setOutputExtension(string2);
        AbstractLanguage abstractLanguage = (AbstractLanguage)unoFactoryData.getProperty("project_language");
        iUnoidlProject.setLanguage(abstractLanguage);
        String string3 = (String)unoFactoryData.getProperty("project_sdk");
        ISdk iSdk = SDKContainer.getSDK(string3);
        iUnoidlProject.setSdk(iSdk);
        String string4 = (String)unoFactoryData.getProperty("project_ooo");
        IOOo iOOo = OOoContainer.getOOo(string4);
        iUnoidlProject.setOOo(iOOo);
        String string5 = (String)unoFactoryData.getProperty("project_idl_dir");
        if (string5 == null || string5.equals("")) {
            string5 = IDL_BASIS;
        }
        iUnoidlProject.setIdlDir(string5);
        String string6 = (String)unoFactoryData.getProperty("project_src_dir");
        if (string6 == null || string6.equals("")) {
            string6 = SOURCE_BASIS;
        }
        iUnoidlProject.setSourcesDir(string6);
        abstractLanguage.getProjectHandler().configureProject(unoFactoryData, iProgressMonitor);
        iUnoidlProject.saveAllProperties();
        if (!abstractLanguage.getName().contains("Python")) {
            UnoidlProjectHelper.createUnoidlPackage(iUnoidlProject, iProgressMonitor);
            UnoidlProjectHelper.createCodePackage(iUnoidlProject, iProgressMonitor);
        }
        UnoidlProjectHelper.createUrdDir(iUnoidlProject, iProgressMonitor);
        return iUnoidlProject;
    }

    public static void deleteProject(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        if (iUnoidlProject != null) {
            try {
                ((UnoidlProject)iUnoidlProject).getProject().delete(true, true, iProgressMonitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void forceBuild(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        UnoidlProject unoidlProject = (UnoidlProject)iUnoidlProject;
        try {
            TypesBuilder.build(unoidlProject.getProject(), iProgressMonitor);
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("UnoidlProjectHelper.NotUnoProjectError"), exception);
        }
    }

    public static void setProjectBuilders(IUnoidlProject iUnoidlProject) {
        UnoidlProject unoidlProject = (UnoidlProject)iUnoidlProject;
        try {
            unoidlProject.setBuilders();
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.getString("UnoidlProjectHelper.NotUnoProjectError"), coreException);
        }
    }

    public static void refreshProject(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        if (iUnoidlProject != null) {
            try {
                ((UnoidlProject)iUnoidlProject).getProject().refreshLocal(2, iProgressMonitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void createModules(String string, IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) throws Exception {
        if (string == null || string.equals("")) {
            String string2 = Messages.getString("UnoidlProjectHelper.BadFullnameError");
            throw new IllegalArgumentException(string2);
        }
        IUnoComposite iUnoComposite = CompositeFactory.createModuleDir(string, iUnoidlProject);
        iUnoComposite.create(true);
        iUnoComposite.dispose();
        ((UnoidlProject)iUnoidlProject).getProject().refreshLocal(2, iProgressMonitor);
    }

    public static void createUnoidlPackage(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        try {
            if (null != iUnoidlProject.getRootModule().replaceAll("::", ".")) {
                PluginLogger.debug("Creating unoidl packages");
                IPath iPath = iUnoidlProject.getIdlPath();
                String string = "/";
                int n = iPath.segmentCount();
                for (int i = 0; i < n; ++i) {
                    IFolder iFolder = iUnoidlProject.getFolder(string = string + iPath.segment(i) + "/");
                    if (iFolder.exists()) continue;
                    iFolder.create(true, true, iProgressMonitor);
                }
                PluginLogger.debug("Unoidl base directory created");
                UnoidlProjectHelper.createModules(iUnoidlProject.getRootModule(), iUnoidlProject, iProgressMonitor);
                PluginLogger.debug("All the modules dir have been created");
            }
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("UnoidlProjectHelper.FolderCreationError") + iUnoidlProject.getRootModulePath().toString(), exception);
        }
    }

    public static void createCodePackage(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        String string = iUnoidlProject.getSourcePath().toPortableString();
        if (string == null || string.equals("")) {
            string = SOURCE_BASIS;
        }
        try {
            PluginLogger.debug("Creating source directories");
            IFolder iFolder = iUnoidlProject.getFolder(string);
            if (!iFolder.exists()) {
                iFolder.create(true, true, iProgressMonitor);
                PluginLogger.debug("source folder created");
            }
            iUnoidlProject.getLanguage().getProjectHandler().addOOoDependencies(iUnoidlProject.getOOo(), ((UnoidlProject)iUnoidlProject).getProject());
            PluginLogger.debug("OOo dependencies added");
        }
        catch (CoreException coreException) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("UnoidlProjectHelper.CreationErrorTitle"), (String)Messages.getString("UnoidlProjectHelper.CreationErrorMessage"));
                }
            });
            String string2 = Messages.getString("UnoidlProjectHelper.FolderCreationError");
            PluginLogger.error(string2 + string, coreException);
        }
    }

    public static void createUrdDir(IUnoidlProject iUnoidlProject, IProgressMonitor iProgressMonitor) {
        try {
            PluginLogger.debug("Creating ouput directories");
            IFolder iFolder = iUnoidlProject.getFolder(iUnoidlProject.getUrdPath());
            if (!iFolder.exists()) {
                String[] stringArray = iUnoidlProject.getUrdPath().segments();
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    IFolder iFolder2 = iUnoidlProject.getFolder(string = string + stringArray[i] + "/");
                    if (iFolder2.exists()) continue;
                    iFolder2.create(true, true, iProgressMonitor);
                    iFolder2.setDerived(true, iProgressMonitor);
                    PluginLogger.debug(iFolder2.getName() + " folder created");
                }
            }
        }
        catch (CoreException coreException) {
            String string = Messages.getString("UnoidlProjectHelper.FolderCreationError");
            PluginLogger.error(string + URD_BASIS, coreException);
        }
    }

    public static IProject getProject(IUnoidlProject iUnoidlProject) {
        IProject iProject = null;
        if (iUnoidlProject != null && iUnoidlProject instanceof UnoidlProject) {
            iProject = ((UnoidlProject)iUnoidlProject).getProject();
        }
        return iProject;
    }

    private static void createProject(IProject iProject, IProgressMonitor iProgressMonitor) {
        try {
            if (!iProject.exists()) {
                iProject.create(iProgressMonitor);
                PluginLogger.debug("Project resource created: " + iProject.getName());
            }
            if (!iProject.isOpen()) {
                iProject.open(iProgressMonitor);
                PluginLogger.debug("Project is opened: " + iProject.getName());
            }
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "org.libreoffice.ide.eclipse.core.unonature";
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
            PluginLogger.debug("UNO-IDL nature set");
            UnoidlProject unoidlProject = (UnoidlProject)iProject.getNature("org.libreoffice.ide.eclipse.core.unonature");
            UnoidlProjectHelper.createDefaultConfig(unoidlProject.getConfigFile());
            ProjectsManager.addProject(unoidlProject);
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.getString("UnoidlProjectHelper.NatureSetError"), coreException);
        }
    }

    public static UnoPackage createMinimalUnoPackage(IUnoidlProject iUnoidlProject, File file) {
        UnoPackage unoPackage = new UnoPackage(file);
        File file2 = SystemHelper.getFile((IResource)iUnoidlProject.getFile(iUnoidlProject.getTypesPath()));
        File file3 = SystemHelper.getFile(iUnoidlProject);
        if (file2.exists()) {
            unoPackage.addTypelibraryFile(UnoPackage.getPathRelativeToBase(file2, file3), file2);
        }
        iUnoidlProject.getLanguage().getLanguageBuilder().fillUnoPackage(unoPackage, iUnoidlProject);
        return unoPackage;
    }

    public static boolean isContainedInPackage(IResource iResource) {
        boolean bl = false;
        String string = iResource.getProject().getName();
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string);
        try {
            URI uRI = iResource.getLocationURI();
            if (iUnoidlProject != null) {
                File file = new File(System.getProperty("user.home"));
                File file2 = new File(file, iUnoidlProject.getName() + ".zip");
                UnoPackage unoPackage = UnoidlProjectHelper.createMinimalUnoPackage(iUnoidlProject, file2);
                List<File> list = unoPackage.getContainedFiles();
                for (int i = 0; i < list.size() && !bl; ++i) {
                    URI uRI2 = list.get(i).toURI();
                    if (!uRI2.equals(uRI)) continue;
                    bl = true;
                }
                unoPackage.dispose();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static List<IResource> getContainedFile(IProject iProject) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        String string = iProject.getName();
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string);
        if (iUnoidlProject != null) {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, iProject.getName() + ".zip");
            UnoPackage unoPackage = UnoidlProjectHelper.createMinimalUnoPackage(iUnoidlProject, file2);
            List<File> list = unoPackage.getContainedFiles();
            File file3 = SystemHelper.getFile((IResource)iProject);
            for (File file4 : list) {
                String string2 = UnoPackage.getPathRelativeToBase(file4, file3);
                IResource iResource = iProject.findMember(string2);
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
            unoPackage.dispose();
        }
        return arrayList;
    }
}

