/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.swt.graphics.Image;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.internal.model.Messages;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.config.IExtraOptionsProvider;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;

public abstract class AbstractOOo
implements IOOo,
ITableElement {
    public static final String NAME = "__ooo_name";
    public static final String PATH = "__ooo_path";
    protected static final String FILE_SEP = System.getProperty("file.separator");
    private static String sPlatform;
    private String mHome;
    private String mName;

    public AbstractOOo(String string) throws InvalidConfigException {
        this.setHome(string);
    }

    public AbstractOOo(String string, String string2) throws InvalidConfigException {
        this.setHome(string);
        this.setName(string2);
    }

    @Override
    public void setHome(String string) throws InvalidConfigException {
        Path path = new Path(string);
        File file = path.toFile();
        if (!file.isDirectory() || !file.canRead()) {
            this.mHome = null;
            throw new InvalidConfigException(Messages.getString("AbstractOOo.NoDirectoryError") + file.getAbsolutePath(), 1);
        }
        this.mHome = string;
        this.checkClassesDir();
        this.checkTypesRdb();
        this.checkServicesRdb();
        this.checkUnoIni();
    }

    @Override
    public String getHome() {
        return this.mHome;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        if (string != null && !string.equals("")) {
            this.mName = OOoContainer.getUniqueName(string);
        }
    }

    private void checkUnoIni() throws InvalidConfigException {
        Path path = new Path(this.getUnorcPath());
        File file = path.toFile();
        if (!file.isFile() || !file.canRead()) {
            this.mHome = null;
            throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + file.getAbsolutePath(), 1);
        }
    }

    private void checkServicesRdb() throws InvalidConfigException {
        String[] stringArray;
        for (String string : stringArray = this.getServicesPath()) {
            Path path = new Path(string);
            File file = path.toFile();
            if (file.isFile() && file.canRead()) continue;
            this.mHome = null;
            throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + file.getAbsolutePath(), 1);
        }
    }

    private void checkTypesRdb() throws InvalidConfigException {
        String[] stringArray;
        for (String string : stringArray = this.getTypesPath()) {
            Path path = new Path(string);
            File file = path.toFile();
            if (file.isFile() && file.canRead()) continue;
            this.mHome = null;
            throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + file.getAbsolutePath(), 1);
        }
    }

    private void checkClassesDir() throws InvalidConfigException {
        String[] stringArray;
        for (String string : stringArray = this.getClassesPath()) {
            Path path = new Path(string);
            File file = path.toFile();
            if (file.isDirectory() && file.canRead()) continue;
            this.mHome = null;
            throw new InvalidConfigException(Messages.getString("AbstractOOo.NoDirectoryError") + file.getAbsolutePath(), 1);
        }
    }

    @Override
    public Image getImage(String string) {
        return null;
    }

    @Override
    public String getLabel(String string) {
        String string2 = "";
        if (string.equals(NAME)) {
            string2 = this.getName();
        } else if (string.equals(PATH)) {
            string2 = this.getHome();
        }
        return string2;
    }

    @Override
    public String[] getProperties() {
        return new String[]{NAME, PATH};
    }

    @Override
    public boolean canModify(String string) {
        return false;
    }

    @Override
    public Object getValue(String string) {
        return null;
    }

    @Override
    public void setValue(String string, Object object) {
    }

    @Override
    public void runUno(IUnoidlProject iUnoidlProject, String string, String string2, ILaunch iLaunch, IProgressMonitor iProgressMonitor) {
        Process process;
        String string3 = iUnoidlProject.getLanguage().getProjectHandler().getLibraryPath(iUnoidlProject);
        string3 = string3.replace("\\", "/");
        string3 = string3.replace(" ", "%20");
        string3 = "file:///" + string3;
        String string4 = this.getUnoPath();
        if (this.getPlatform().equals("win32")) {
            string4 = "uno";
        }
        String string5 = string4 + " -c " + string + " -l " + string3 + " -- " + string2;
        String[] stringArray = iUnoidlProject.getLanguage().getLanguageBuilder().getBuildEnv(iUnoidlProject);
        if (this.getJavaldxPath() != null) {
            process = iUnoidlProject.getSdk().runToolWithEnv(iUnoidlProject, this.getJavaldxPath(), stringArray, iProgressMonitor);
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n = inputStream.read();
                while (n != -1) {
                    stringWriter.write(n);
                    n = inputStream.read();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string6 = stringWriter.getBuffer().toString();
            stringArray = SystemHelper.addEnv(stringArray, "LD_LIBRARY_PATH", string6.trim(), System.getProperty("path.separator"));
        }
        process = iUnoidlProject.getSdk().runToolWithEnv(iUnoidlProject, string5, stringArray, iProgressMonitor);
        DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)(Messages.getString("AbstractOOo.UreProcessName") + string));
    }

    @Override
    public void runOffice(IUnoidlProject iUnoidlProject, ILaunch iLaunch, IPath iPath, IExtraOptionsProvider iExtraOptionsProvider, IProgressMonitor iProgressMonitor) {
        try {
            String[] stringArray = iUnoidlProject.getLanguage().getLanguageBuilder().getBuildEnv(iUnoidlProject);
            String string = System.getProperty("path.separator");
            String[] stringArray2 = iUnoidlProject.getOOo().getBinPath();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray2) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
            }
            String string3 = "soffice.bin --norestore";
            stringArray = SystemHelper.addEnv(stringArray, "PATH", stringBuilder.toString(), string);
            stringArray = SystemHelper.addEnv(stringArray, "SAL_ALLOW_LINKOO_SYMLINKS", "1", null);
            stringArray = this.addUserProfile(iPath, stringArray);
            stringArray = iExtraOptionsProvider.addEnv(stringArray);
            PluginLogger.debug("Launching LibreOffice from commandline: " + string3);
            Process process = iUnoidlProject.getSdk().runToolWithEnv(iUnoidlProject, string3, stringArray, iProgressMonitor);
            DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)Messages.getString("AbstractOOo.LibreOfficeProcessName"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PluginLogger.error("Error running LibreOffice", exception);
        }
    }

    protected String[] addUserProfile(IPath iPath, String[] stringArray) throws URISyntaxException {
        if (null != iPath) {
            URI uRI = new URI("file", "", iPath.toFile().toURI().getPath(), null);
            stringArray = SystemHelper.addEnv(stringArray, "UserInstallation", uRI.toString(), null);
        }
        return stringArray;
    }

    public static void setPlatform(String string) {
        sPlatform = string;
    }

    protected String getPlatform() {
        String string = sPlatform;
        if (sPlatform == null) {
            string = Platform.getOS();
        }
        return string;
    }

    protected static String getPlatformOS() {
        return Platform.getOS();
    }

    protected static boolean isSymbolicLink(File file) throws IOException {
        boolean bl = false;
        if (file != null) {
            File file2 = null;
            if (file.getParentFile() == null) {
                file2 = file;
            } else {
                File file3 = file.getParentFile().getCanonicalFile();
                file2 = new File(file3, file.getName());
            }
            bl = !file2.getCanonicalFile().equals(file2.getAbsoluteFile());
        }
        return bl;
    }

    public static File getTargetLink(File file) throws IOException {
        File file2 = null;
        if (file != null) {
            file2 = new File(file.getCanonicalPath());
        }
        return file2;
    }
}

