/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.model.AbstractOOo;
import org.libreoffice.ide.eclipse.core.internal.model.Messages;
import org.libreoffice.ide.eclipse.core.internal.model.RelativeFileLocator;
import org.libreoffice.ide.eclipse.core.internal.model.URE;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;

public class OOo
extends AbstractOOo {
    private static final String K_PRODUCTKEY = "ProductKey";
    private OOo3PathMapper mMapper;

    public OOo(String string) throws InvalidConfigException {
        super(string);
    }

    public OOo(String string, String string2) throws InvalidConfigException {
        super(string, string2);
    }

    @Override
    public void setHome(String string) throws InvalidConfigException {
        if (this.getPlatform().equals("macosx")) {
            string = string + FILE_SEP + "Contents";
        }
        this.mMapper = new OOo3PathMapper(string);
        super.setHome(string);
    }

    @Override
    public String[] getClassesPath() {
        return this.mMapper.getClasses();
    }

    @Override
    public String[] getLibsPath() {
        String[] stringArray = this.mMapper.getAdditionnalLibs();
        String string = this.getHome() + FILE_SEP + "program";
        if (this.getPlatform().equals("macosx")) {
            string = this.getHome() + FILE_SEP + "MacOS";
        }
        return this.mMapper.mergeArrays(new String[]{string}, stringArray);
    }

    @Override
    public String[] getBinPath() {
        String[] stringArray = this.mMapper.getAdditionnalBins();
        String string = this.getHome() + FILE_SEP + "program";
        if (Platform.getOS().equals("macosx")) {
            string = this.getHome() + FILE_SEP + "MacOS";
        }
        return this.mMapper.mergeArrays(new String[]{string}, stringArray);
    }

    @Override
    public String[] getTypesPath() {
        return this.mMapper.getTypes();
    }

    @Override
    public String[] getServicesPath() {
        return this.mMapper.getServices();
    }

    @Override
    public String getUnorcPath() {
        String string = this.getLibsPath()[0] + FILE_SEP + "bootstrap";
        string = this.getPlatform().equals("win32") ? string + ".ini" : (this.getPlatform().equals("macosx") ? this.getHome() + FILE_SEP + "Resources" + FILE_SEP + "bootstraprc" : string + "rc");
        return string;
    }

    @Override
    public String getUnoPath() {
        return this.mMapper.getUnoPath();
    }

    @Override
    public void setName(String string) {
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            string2 = this.getOOoName();
        }
        super.setName(string2);
    }

    private String getOOoName() {
        String string = null;
        Path path = new Path(this.getUnorcPath());
        File file = path.toFile();
        if (file.exists() && file.isFile()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                if (properties.containsKey(K_PRODUCTKEY)) {
                    string = properties.getProperty(K_PRODUCTKEY);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String toString() {
        return "OOo " + this.getName();
    }

    @Override
    public String createUnoCommand(String string, String string2, String[] stringArray, String[] stringArray2) {
        String string3 = "";
        if (string2 != null && !string2.equals("")) {
            String[] stringArray3;
            String string4 = "";
            for (int i = 0; i < stringArray2.length; ++i) {
                string4 = string4 + stringArray2[i];
                if (i >= stringArray2.length - 1) continue;
                string4 = string4 + " ";
            }
            String string5 = System.getProperty("path.separator");
            String string6 = System.getProperty("file.separator");
            String string7 = "-cp ";
            if (this.getPlatform().equals("win32")) {
                string7 = string7 + "\"";
            }
            for (String string8 : stringArray3 = this.getClassesPath()) {
                File file = new File(string8);
                for (String string9 : file.list()) {
                    if (!string9.endsWith(".jar")) continue;
                    string7 = string7 + string8 + string6 + string9 + string5;
                }
            }
            string7 = string7 + string2;
            if (this.getPlatform().equals("win32")) {
                string7 = string7 + "\"";
            }
            string3 = "java " + string7 + " " + string + " " + string4;
        }
        return string3;
    }

    @Override
    public String getJavaldxPath() {
        String string = this.getLibsPath() + FILE_SEP + "javaldx";
        return string;
    }

    @Override
    public boolean canManagePackages() {
        return true;
    }

    @Override
    public void updatePackage(File file, IPath iPath) {
        try {
            this.addPackage(file, iPath);
        }
        catch (Exception exception) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("OOo.PackageExportTitle"), (String)Messages.getString("OOo.DeploymentError"));
                }
            });
            PluginLogger.error(Messages.getString("OOo.DeploymentError"), exception);
        }
    }

    private void addPackage(File file, IPath iPath) throws Exception {
        String string = file.getAbsolutePath();
        String string2 = MessageFormat.format("unopkg add -f \"{0}\"", string);
        String[] stringArray = SystemHelper.getSystemEnvironement();
        String string3 = System.getProperty("path.separator");
        stringArray = SystemHelper.addEnv(stringArray, "PATH", this.getHome() + FILE_SEP + "program", string3);
        stringArray = this.addUserProfile(iPath, stringArray);
        Process process = SystemHelper.runTool(string2, stringArray, null);
        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        String string4 = lineNumberReader.readLine();
        boolean bl = false;
        while (null != string4 && !bl) {
            if (string4.contains("failed")) {
                bl = true;
            }
            string4 = lineNumberReader.readLine();
        }
        try {
            lineNumberReader.close();
            inputStreamReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            throw new Exception(Messages.getString("OOo.PackageAddError") + file.getAbsolutePath());
        }
    }

    private class OOo3PathMapper {
        private String mHome;
        private URE mUre;
        private File mMapperBasisBins;
        private File mMapperBasisClasses;
        private List<File> mMapperBasisTypes;
        private List<File> mMapperBasisServices;

        public OOo3PathMapper(String string) throws InvalidConfigException {
            this.mHome = string;
            this.initPaths();
        }

        private void initPaths() throws InvalidConfigException {
            String string = OOo.this.getPlatform().equals("macosx") ? "MacOS/" + URE.getUnoExecutable() : "program/" + URE.getUnoExecutable();
            File file = this.locateUniqueContainer(this.mHome, string);
            if (file == null) {
                this.mHome = null;
                throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + string, 1);
            }
            this.mUre = new URE(file.getAbsolutePath());
        }

        private File locateUniqueContainer(String string, String string2) throws InvalidConfigException {
            File file = null;
            File file2 = new File(string);
            if (file2.exists() && file2.isDirectory() && file2.canRead()) {
                List<File> list = new RelativeFileLocator(file2, string2).getFiles();
                if (list == null) {
                    throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + string2, 1);
                }
                if (list.size() > 1) {
                    this.removeLinks(list, string2);
                }
                if (list.size() != 1) {
                    throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + string2, 1);
                }
                file = list.get(0);
            }
            return file;
        }

        private List<File> locateFiles(String string, String string2) throws InvalidConfigException {
            List list = null;
            File file = new File(string);
            if (file.exists() && file.isDirectory() && file.canRead()) {
                List<File> list2 = new RelativeFileLocator(file, string2).getFiles();
                if (list2 == null || list2.size() == 0) {
                    list = Collections.emptyList();
                } else {
                    this.removeLinks(list2, string2);
                    list = new ArrayList();
                    for (File file2 : list2) {
                        list.add(new File(file2, string2));
                    }
                }
            }
            return list;
        }

        private void removeLinks(List<File> list, String string) throws InvalidConfigException {
            try {
                ArrayList<File> arrayList = new ArrayList<File>();
                for (File file : list) {
                    if (!AbstractOOo.isSymbolicLink(file)) continue;
                    arrayList.add(file);
                }
                if (!arrayList.isEmpty()) {
                    for (File file : arrayList) {
                        File file2 = AbstractOOo.getTargetLink(file);
                        if (!list.contains(file2)) continue;
                        list.remove(file2);
                    }
                }
            }
            catch (IOException iOException) {
                throw new InvalidConfigException(Messages.getString("AbstractOOo.NoFileError") + string, 1);
            }
        }

        public String[] getAdditionnalLibs() {
            return this.mUre.getLibsPath();
        }

        public String[] getAdditionnalBins() {
            File file;
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            if (this.mUre != null) {
                stringArray2 = this.mUre.getBinPath();
            }
            if ((file = this.mMapperBasisBins) == null) {
                String string = "soffice.bin";
                if (OOo.this.getPlatform().equals("macosx")) {
                    string = "soffice";
                }
                try {
                    this.mMapperBasisBins = file = this.locateUniqueContainer(this.mHome, string);
                }
                catch (InvalidConfigException invalidConfigException) {
                    invalidConfigException.printStackTrace();
                }
            }
            stringArray = file != null ? this.mergeArrays(stringArray2, new String[]{file.getAbsolutePath()}) : stringArray2;
            return stringArray;
        }

        public String[] getClasses() {
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            if (this.mUre != null) {
                stringArray2 = this.mUre.getClassesPath();
            }
            File file = this.mMapperBasisClasses;
            if (this.mMapperBasisClasses == null) {
                try {
                    this.mMapperBasisClasses = file = this.locateUniqueContainer(this.mHome, "unoil.jar");
                }
                catch (InvalidConfigException invalidConfigException) {
                    invalidConfigException.printStackTrace();
                }
            }
            stringArray = file != null ? this.mergeArrays(stringArray2, new String[]{file.getAbsolutePath()}) : stringArray2;
            return stringArray;
        }

        public String[] getTypes() {
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            if (this.mUre != null) {
                stringArray2 = this.mUre.getTypesPath();
            }
            List<File> list = this.mMapperBasisTypes;
            if (this.mMapperBasisTypes == null) {
                try {
                    this.mMapperBasisTypes = list = this.locateFiles(this.mHome, "offapi.rdb");
                }
                catch (InvalidConfigException invalidConfigException) {
                    invalidConfigException.printStackTrace();
                }
            }
            if (list != null && list.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (File file : list) {
                    if (file == null) continue;
                    arrayList.add(file.getAbsolutePath());
                }
                stringArray = this.mergeArrays(stringArray2, arrayList.toArray(new String[arrayList.size()]));
            } else {
                stringArray = stringArray2;
            }
            return stringArray;
        }

        public String[] getServices() {
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            if (this.mUre != null) {
                stringArray2 = this.mUre.getServicesPath();
            }
            List<File> list = this.mMapperBasisServices;
            if (this.mMapperBasisServices == null) {
                try {
                    this.mMapperBasisServices = list = this.locateFiles(this.mHome, "services.rdb");
                }
                catch (InvalidConfigException invalidConfigException) {
                    invalidConfigException.printStackTrace();
                }
            }
            if (list != null && list.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (File file : list) {
                    if (file == null) continue;
                    arrayList.add(file.getAbsolutePath());
                }
                stringArray = this.mergeArrays(stringArray2, arrayList.toArray(new String[arrayList.size()]));
            } else {
                stringArray = stringArray2;
            }
            return stringArray;
        }

        public String getUnoPath() {
            String string = null;
            if (this.mUre != null) {
                string = this.mUre.getUnoPath();
            }
            return string;
        }

        public String[] mergeArrays(String[] stringArray, String[] stringArray2) {
            String[] stringArray3 = null;
            if (stringArray == null) {
                stringArray3 = stringArray2;
            } else if (stringArray2 == null) {
                stringArray3 = stringArray;
            } else {
                stringArray3 = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            }
            return stringArray3;
        }
    }
}

