/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.internal.model.Messages;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;

public class SDK
implements ISdk,
ITableElement {
    public static final String NAME = "__sdk_name";
    public static final String PATH = "__sdk_path";
    private static final String K_SDK_BUILDID = "BUILDID";
    private static final String F_DK_CONFIG = "dk.mk";
    private static final String INCLUDE = "include";
    private static final String LIB = "lib";
    private String mSdkName;
    private String mSdkHome;

    public SDK(String string) throws InvalidConfigException {
        this.initialize(string, null);
    }

    public SDK(String string, String string2) throws InvalidConfigException {
        this.initialize(string, string2);
    }

    @Override
    public void initialize(String string, String string2) throws InvalidConfigException {
        try {
            File file;
            Path path = new Path(string);
            File file2 = path.toFile();
            if (file2.exists() && file2.isDirectory()) {
                String string3;
                file = this.checkSettingsDir(file2);
                IPath iPath = this.getBinPath(string);
                if (!iPath.append(string3 = this.getCommand("uno-skeletonmaker")).toFile().exists()) {
                    throw new InvalidConfigException(Messages.getString("SDK.MinSdkVersionError"), 0);
                }
            } else {
                throw new InvalidConfigException(Messages.getString("SDK.NoDirectoryError"), 0);
            }
            this.mSdkName = string2 != null && !string2.isEmpty() ? string2 : this.getBuildId(file);
            this.mSdkHome = string;
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvalidConfigException) {
                InvalidConfigException invalidConfigException = (InvalidConfigException)throwable;
                throw invalidConfigException;
            }
            PluginLogger.error("Unexpected error during SDK cration", throwable);
            throw new InvalidConfigException(Messages.getString("SDK.UnexpectedError"), 0, throwable);
        }
    }

    private File checkSettingsDir(File file) throws InvalidConfigException {
        File file2 = new File(file, "settings");
        if (!file2.exists() || !file2.isDirectory()) {
            throw new InvalidConfigException(Messages.getString("SDK.NoSettingsDirError"), 0);
        }
        return file2;
    }

    @Override
    public String getName() {
        return this.mSdkName;
    }

    @Override
    public String getHome() {
        return this.mSdkHome;
    }

    @Override
    public IPath getBinPath() {
        return this.getBinPath(this.getHome());
    }

    @Override
    public String getCommand(String string) {
        if (Platform.getOS().equals("win32")) {
            string = string + ".exe";
        }
        return string;
    }

    @Override
    public boolean useIdlWrite() {
        String string = this.getCommand("unoidl-write");
        return this.getBinPath().append(string).toFile().exists();
    }

    @Override
    public IPath getIncludePath() {
        return new Path(this.getHome()).append(INCLUDE);
    }

    @Override
    public IPath getLibPath() {
        return new Path(this.getHome()).append(LIB);
    }

    private IPath getBinPath(String string) {
        return new Path(string).append("/bin");
    }

    @Override
    public Process runTool(IUnoidlProject iUnoidlProject, String string, IProgressMonitor iProgressMonitor) {
        return this.runToolWithEnv(iUnoidlProject, string, new String[0], iProgressMonitor);
    }

    @Override
    public Process runToolWithEnv(IUnoidlProject iUnoidlProject, String string, String[] stringArray, IProgressMonitor iProgressMonitor) {
        Process process = null;
        IOOo iOOo = iUnoidlProject.getOOo();
        try {
            if (null != iOOo) {
                String[] stringArray2 = SystemHelper.getSystemEnvironement();
                String[] stringArray3 = this.mergeVariables(stringArray2, stringArray);
                if (null != (stringArray3 = this.updateEnvironment(stringArray3, iOOo))) {
                    File file = iUnoidlProject.getProjectPath().toFile();
                    process = SystemHelper.runTool(string, stringArray3, file);
                }
            }
        }
        catch (IOException iOException) {
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("SDK.PluginError"), null, Messages.getString("SDK.ProcessError"), 1, new String[]{Messages.getString("SDK.Ok")}, 0);
            messageDialog.setBlockOnOpen(true);
            messageDialog.create();
            messageDialog.open();
        }
        catch (SecurityException securityException) {
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("SDK.PluginError"), null, Messages.getString("SDK.ProcessError"), 1, new String[]{Messages.getString("SDK.Ok")}, 0);
            messageDialog.setBlockOnOpen(true);
            messageDialog.create();
            messageDialog.open();
        }
        catch (Exception exception) {
            PluginLogger.error(exception.getMessage(), null);
        }
        return process;
    }

    private String[] mergeVariables(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = stringArray;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            Matcher matcher = Pattern.compile("([^=]+)=(.*)").matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            stringArray3 = SystemHelper.addEnv(stringArray3, string2, string3, SystemHelper.PATH_SEPARATOR);
        }
        return stringArray3;
    }

    private String[] updateEnvironment(String[] stringArray, IOOo iOOo) throws Exception {
        String[] stringArray2 = iOOo.getBinPath();
        String[] stringArray3 = new String[stringArray2.length + 1];
        stringArray3[0] = this.getBinPath().toOSString();
        System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
        String[] stringArray4 = iOOo.getLibsPath();
        if (Platform.getOS().equals("win32")) {
            stringArray = SystemHelper.addPathEnv(stringArray, "PATH", stringArray3);
        } else if (Platform.getOS().equals("linux")) {
            String[] stringArray5 = SystemHelper.addPathEnv(stringArray, "PATH", stringArray3);
            stringArray = SystemHelper.addPathEnv(stringArray5, "LD_LIBRARY_PATH", stringArray4);
        } else if (Platform.getOS().equals("macosx")) {
            String[] stringArray6 = SystemHelper.addPathEnv(stringArray, "PATH", stringArray3);
            stringArray = SystemHelper.addPathEnv(stringArray6, "DYLD_LIBRARY_PATH", stringArray4);
        } else {
            throw new Exception(Messages.getString("SDK.InvalidSdkError"));
        }
        return stringArray;
    }

    @Override
    public Image getImage(String string) {
        return null;
    }

    @Override
    public String getLabel(String string) {
        String string2;
        if (string.equals(NAME)) {
            string2 = this.getName();
        } else if (string.equals(PATH)) {
            string2 = this.getHome();
        } else {
            throw new IllegalArgumentException("Invalid property: " + string);
        }
        return string2;
    }

    @Override
    public String[] getProperties() {
        return new String[]{NAME, PATH};
    }

    @Override
    public boolean canModify(String string) {
        return false;
    }

    @Override
    public Object getValue(String string) {
        return null;
    }

    @Override
    public void setValue(String string, Object object) {
    }

    private String getBuildId(File file) throws InvalidConfigException {
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, F_DK_CONFIG);
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
                if (properties.containsKey(K_SDK_BUILDID)) {
                    String string = properties.getProperty(K_SDK_BUILDID);
                    return string;
                }
                try {
                    String string = Messages.getString("SDK.MissingKeyError") + K_SDK_BUILDID;
                    throw new InvalidConfigException(string, 0);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string = Messages.getString("SDK.NoFileError") + "settings/";
                    throw new InvalidConfigException(string + F_DK_CONFIG, 0);
                }
                catch (IOException iOException) {
                    throw new InvalidConfigException(Messages.getString("SDK.NoReadableFileError") + "settings/" + F_DK_CONFIG, 0);
                }
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        throw new InvalidConfigException(Messages.getString("SDK.NoDirectoryError") + file.getAbsolutePath(), 0);
    }
}

