/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.model;

import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.libreoffice.ide.eclipse.core.model.IUnoComposite;

public class UnoComposite
implements IUnoComposite {
    private Vector<IUnoComposite> mChildren = new Vector();
    private int mType = -1;
    private Hashtable<String, Object> mProperties;
    private String mTemplate;
    private String mFilename;
    private String mSeparator = "";
    private boolean mIndentation = false;

    @Override
    public void dispose() {
        this.removeAll();
        if (this.mProperties != null) {
            this.mProperties.clear();
        }
    }

    @Override
    public IUnoComposite[] getChildren() {
        IUnoComposite[] iUnoCompositeArray = new IUnoComposite[this.mChildren.size()];
        int n = this.mChildren.size();
        for (int i = 0; i < n; ++i) {
            iUnoCompositeArray[i] = this.mChildren.get(i);
        }
        return iUnoCompositeArray;
    }

    @Override
    public void addChild(IUnoComposite iUnoComposite) {
        if (iUnoComposite != null) {
            this.mChildren.add(iUnoComposite);
        }
    }

    @Override
    public void removeAll() {
        IUnoComposite[] iUnoCompositeArray = this.getChildren();
        for (int i = 0; i < iUnoCompositeArray.length; ++i) {
            IUnoComposite iUnoComposite = iUnoCompositeArray[i];
            iUnoComposite.dispose();
            this.mChildren.removeElement(iUnoComposite);
        }
    }

    @Override
    public void setType(int n) {
        if (this.mType == -1 && (n == 0 || n == 1 || n == 2)) {
            this.mType = n;
        }
    }

    @Override
    public int getType() {
        return this.mType;
    }

    @Override
    public void configure(Hashtable<String, Object> hashtable, String string) {
        this.mTemplate = string;
        String[] stringArray = this.splitTemplate();
        this.mProperties = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Matcher matcher = Pattern.compile("\\$\\{(\\w+)\\}").matcher(string2);
            if (string2.equals("${children}") || !matcher.matches()) continue;
            String string3 = matcher.group(1);
            if (hashtable.containsKey(string3)) {
                this.mProperties.put(string3, hashtable.get(string3));
                continue;
            }
            this.mProperties.put(string3, "");
        }
    }

    @Override
    public void configure(String string) {
        if (this.mType == 0 || this.mType == 1) {
            this.mFilename = string;
        }
    }

    @Override
    public void setIndented(boolean bl) {
        if (this.mType == 2) {
            this.mIndentation = bl;
        }
    }

    @Override
    public void setChildrenSeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.mSeparator = string;
    }

    @Override
    public void create(boolean bl) throws Exception {
        if (this.mType == 0 || this.mType == 1) {
            File file = new File(this.mFilename);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (file.exists() && bl || !file.exists()) {
                if (this.mType == 0) {
                    file.createNewFile();
                    FileWriter fileWriter = new FileWriter(file);
                    String string = new String();
                    IUnoComposite[] iUnoCompositeArray = this.getChildren();
                    for (int i = 0; i < iUnoCompositeArray.length; ++i) {
                        string = string + iUnoCompositeArray[i].toString();
                    }
                    fileWriter.write(string);
                    fileWriter.close();
                } else {
                    file.mkdir();
                }
            }
        }
    }

    @Override
    public String toString() {
        String string = new String();
        if (this.mType == 2) {
            String[] stringArray = this.splitTemplate();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string2 = stringArray[i];
                if (string2.equals("${children}")) {
                    object = this.getChildren();
                    for (int j = 0; j < ((Object)object).length; ++j) {
                        if (object[j].getType() != 2) continue;
                        string = string + object[j].toString() + this.mSeparator;
                    }
                    if (((Object)object).length <= 0) continue;
                    string = string.substring(0, string.length() - this.mSeparator.length());
                    continue;
                }
                object = Pattern.compile("\\$\\{(\\w+)\\}").matcher(string2);
                string = ((Matcher)object).matches() ? string + this.mProperties.get(((Matcher)object).group(1)) : string + string2;
            }
            string = this.indent(string);
        } else {
            string = super.toString();
        }
        return string;
    }

    private String indent(String string) {
        if (this.mIndentation) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\n' || i == string.length() - 1 || string.charAt(i + 1) == '\n') continue;
                string = string.substring(0, i + 1) + "\t" + string.substring(i + 1);
            }
            string = "\t" + string;
        }
        return string;
    }

    private String[] splitTemplate() {
        String string = new String(this.mTemplate);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n = -1;
        do {
            if (!bl) {
                n = string.indexOf("${");
                if (n == -1) continue;
                bl = true;
                vector.add(string.substring(0, n));
                string = string.substring(n);
                continue;
            }
            n = string.indexOf("}");
            if (n == -1) continue;
            bl = false;
            vector.add(string.substring(0, ++n));
            string = string.substring(n);
        } while (n != -1 && !string.equals(""));
        if (bl && !string.equals("") && !string.endsWith("}")) {
            string = string + "}";
        }
        if (!string.equals("")) {
            vector.add(string);
        }
        return vector.toArray(new String[vector.size()]);
    }
}

