/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoSkeletonHelper;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.internal.model.Messages;
import org.libreoffice.ide.eclipse.core.model.CompositeFactory;
import org.libreoffice.ide.eclipse.core.model.IUnoComposite;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;
import org.libreoffice.ide.eclipse.core.model.language.AbstractLanguage;
import org.libreoffice.ide.eclipse.core.model.language.IProjectHandler;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;

public final class UnoFactory {
    public static IUnoidlProject createProject(UnoFactoryData unoFactoryData, IProgressMonitor iProgressMonitor) throws Exception {
        IUnoidlProject iUnoidlProject = UnoidlProjectHelper.createStructure(unoFactoryData, iProgressMonitor);
        iUnoidlProject.getFile("package.properties").getLocation().toFile().createNewFile();
        File file = iUnoidlProject.getFile("description.xml").getLocation().toFile();
        DescriptionModel descriptionModel = new DescriptionModel();
        descriptionModel.getDisplayNames().put(Locale.ENGLISH, iUnoidlProject.getName());
        descriptionModel.setId(iUnoidlProject.getCompanyPrefix().toLowerCase() + "." + iUnoidlProject.getName().replaceAll("[^a-zA-Z0-9]", new String()).toLowerCase());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            descriptionModel.serialize(fileOutputStream);
        }
        UnoidlProjectHelper.refreshProject(iUnoidlProject, null);
        UnoidlProjectHelper.forceBuild(iUnoidlProject, iProgressMonitor);
        return iUnoidlProject;
    }

    public static void makeSkeleton(UnoFactoryData unoFactoryData, IWorkbenchPage iWorkbenchPage, IProgressMonitor iProgressMonitor) throws Exception {
        String string = UnoFactory.getSkeletonServiceName(unoFactoryData);
        AbstractLanguage abstractLanguage = (AbstractLanguage)unoFactoryData.getProperty("project_language");
        IProjectHandler iProjectHandler = abstractLanguage.getProjectHandler();
        String string2 = iProjectHandler.getSkeletonMakerLanguage(unoFactoryData);
        if (string != null && string2 != null) {
            String string3 = (String)unoFactoryData.getProperty("project_name");
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string3);
            String string4 = iUnoidlProject.getSdk().getCommand("uno-skeletonmaker");
            boolean bl = UnoSkeletonHelper.supportPassiveRegistration(iUnoidlProject, string4, iProgressMonitor);
            String string5 = UnoFactory.getSkeletonTypesRegistry(iUnoidlProject);
            String string6 = iProjectHandler.getImplementationName(iUnoidlProject, string);
            string4 = string4 + " component " + string2 + " --propertysetmixin";
            if (bl) {
                string4 = string4 + " --passive-registration";
            }
            string4 = string4 + " -o ./" + iUnoidlProject.getSourcePath().toOSString() + " " + string5 + " -n " + string6 + " -t " + string;
            Process process = iUnoidlProject.getSdk().runTool(iUnoidlProject, string4, iProgressMonitor);
            String string7 = null;
            try {
                string7 = UnoSkeletonHelper.readErrorStream(process);
            }
            catch (IOException iOException) {
                string7 = iOException.getMessage();
            }
            if (string7 != null) {
                if (string7.isEmpty()) {
                    String string8 = Messages.getString("UnoFactory.SkeletonGeneratedMessage");
                    PluginLogger.info(string8 + string6);
                } else {
                    PluginLogger.error(string7);
                }
            } else {
                IPath iPath = iProjectHandler.getImplementationFile(string6);
                iPath = iUnoidlProject.getSourcePath().append(iPath);
                IFile iFile = iUnoidlProject.getFile(iPath);
                UnoidlProjectHelper.refreshProject(iUnoidlProject, null);
                if (!bl) {
                    UnoSkeletonHelper.cleanupJavaSkeleton(iFile, string, iProgressMonitor);
                }
                WorkbenchHelper.showFile(iFile, iWorkbenchPage);
            }
        }
    }

    public static void createService(UnoFactoryData unoFactoryData, IUnoidlProject iUnoidlProject, IWorkbenchPage iWorkbenchPage, IProgressMonitor iProgressMonitor) throws Exception {
        UnoFactory.createService(unoFactoryData, iUnoidlProject, iWorkbenchPage, iProgressMonitor, true);
    }

    public static void createService(UnoFactoryData unoFactoryData, IUnoidlProject iUnoidlProject, IWorkbenchPage iWorkbenchPage, IProgressMonitor iProgressMonitor, boolean bl) throws Exception {
        String string = (String)unoFactoryData.getProperty("package_name");
        string = string.replaceAll("\\.", "::");
        String string2 = (String)unoFactoryData.getProperty("type_name");
        String[] stringArray = (String[])unoFactoryData.getProperty("inherited_interfaces");
        boolean bl2 = (Boolean)unoFactoryData.getProperty("type_published");
        UnoidlProjectHelper.createModules(string, iUnoidlProject, null);
        String string3 = string + "::" + string2;
        IUnoComposite iUnoComposite = CompositeFactory.createTypeFile(string3, iUnoidlProject);
        IUnoComposite iUnoComposite2 = CompositeFactory.createFileContent(string3);
        iUnoComposite.addChild(iUnoComposite2);
        UnoFactory.createIncludes(iUnoComposite2, stringArray);
        String[] stringArray2 = UnoFactory.getNeededIncludes(unoFactoryData);
        UnoFactory.createIncludes(iUnoComposite2, stringArray2);
        IUnoComposite iUnoComposite3 = UnoFactory.createParentModules(iUnoComposite2, string);
        IUnoComposite iUnoComposite4 = CompositeFactory.createService(string2, bl2, stringArray[0]);
        iUnoComposite3.addChild(iUnoComposite4);
        iUnoComposite.create(true);
        iUnoComposite.dispose();
        if (bl) {
            UnoFactory.showType(string3, iUnoidlProject, iWorkbenchPage);
        }
    }

    public static void createInterface(UnoFactoryData unoFactoryData, IUnoidlProject iUnoidlProject, IWorkbenchPage iWorkbenchPage, IProgressMonitor iProgressMonitor) throws Exception {
        UnoFactory.createInterface(unoFactoryData, iUnoidlProject, iWorkbenchPage, iProgressMonitor, true);
    }

    public static void createInterface(UnoFactoryData unoFactoryData, IUnoidlProject iUnoidlProject, IWorkbenchPage iWorkbenchPage, IProgressMonitor iProgressMonitor, boolean bl) throws Exception {
        String[] stringArray;
        String string = (String)unoFactoryData.getProperty("package_name");
        string = string.replaceAll("\\.", "::");
        String string2 = (String)unoFactoryData.getProperty("type_name");
        String[] stringArray2 = (String[])unoFactoryData.getProperty("inherited_interfaces");
        String[] stringArray3 = (String[])unoFactoryData.getProperty("opt_inherited_interfaces");
        boolean bl2 = (Boolean)unoFactoryData.getProperty("type_published");
        if (0 == stringArray2.length && 0 < stringArray3.length) {
            stringArray2 = new String[]{stringArray3[0]};
            stringArray = new String[stringArray3.length - 1];
            System.arraycopy(stringArray3, 1, stringArray, 0, stringArray.length);
            stringArray3 = stringArray;
        }
        UnoidlProjectHelper.createModules(string, iUnoidlProject, null);
        stringArray = string + "::" + string2;
        IUnoComposite iUnoComposite = CompositeFactory.createTypeFile((String)stringArray, iUnoidlProject);
        IUnoComposite iUnoComposite2 = CompositeFactory.createFileContent((String)stringArray);
        iUnoComposite.addChild(iUnoComposite2);
        UnoFactory.createIncludes(iUnoComposite2, stringArray2);
        UnoFactory.createIncludes(iUnoComposite2, stringArray3);
        String[] stringArray4 = UnoFactory.getNeededIncludes(unoFactoryData);
        UnoFactory.createIncludes(iUnoComposite2, stringArray4);
        IUnoComposite iUnoComposite3 = UnoFactory.createParentModules(iUnoComposite2, string);
        IUnoComposite iUnoComposite4 = CompositeFactory.createInterface(string2, bl2, stringArray2);
        iUnoComposite3.addChild(iUnoComposite4);
        for (int i = 0; i < stringArray3.length; ++i) {
            IUnoComposite iUnoComposite5 = CompositeFactory.createInterfaceInheritance(stringArray3[i], true);
            iUnoComposite4.addChild(iUnoComposite5);
        }
        for (UnoFactoryData unoFactoryData2 : unoFactoryData.getInnerData()) {
            Object object;
            String string3;
            String string4;
            Integer n = (Integer)unoFactoryData2.getProperty("member_type");
            if (n == 1) {
                string4 = (String)unoFactoryData2.getProperty("name");
                string3 = (String)unoFactoryData2.getProperty("type");
                object = (String)unoFactoryData2.getProperty("flags");
                iUnoComposite4.addChild(CompositeFactory.createAttribute(string4, string3, (String)object));
                continue;
            }
            if (n != 2) continue;
            string4 = (String)unoFactoryData2.getProperty("name");
            string3 = (String)unoFactoryData2.getProperty("type");
            object = CompositeFactory.createMethod(string4, string3);
            for (UnoFactoryData unoFactoryData3 : unoFactoryData2.getInnerData()) {
                String string5 = (String)unoFactoryData3.getProperty("name");
                String string6 = (String)unoFactoryData3.getProperty("type");
                String string7 = (String)unoFactoryData3.getProperty("argument_inout");
                object.addChild(CompositeFactory.createMethodArgument(string5, string6, string7));
            }
            iUnoComposite4.addChild((IUnoComposite)object);
        }
        iUnoComposite.create(true);
        iUnoComposite.dispose();
        if (bl) {
            UnoFactory.showType((String)stringArray, iUnoidlProject, iWorkbenchPage);
        }
    }

    private static void showType(String string, IUnoidlProject iUnoidlProject, IWorkbenchPage iWorkbenchPage) {
        String string2 = string.replace("::", "/") + ".idl";
        UnoidlProjectHelper.refreshProject(iUnoidlProject, null);
        IFile iFile = iUnoidlProject.getFile(iUnoidlProject.getIdlPath().append(string2));
        WorkbenchHelper.showFile(iFile, iWorkbenchPage);
    }

    private static String[] getNeededIncludes(UnoFactoryData unoFactoryData) {
        String[] stringArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray2 = unoFactoryData.getKeys();
        for (String object : stringArray2) {
            stringArray = unoFactoryData.getProperty(object).toString();
            if (!stringArray.contains("::") || object.equals("package_name")) continue;
            arrayList.add(stringArray);
        }
        for (UnoFactoryData unoFactoryData2 : unoFactoryData.getInnerData()) {
            stringArray = UnoFactory.getNeededIncludes(unoFactoryData2);
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static IUnoComposite createParentModules(IUnoComposite iUnoComposite, String string) {
        IUnoComposite iUnoComposite2 = CompositeFactory.createModulesSpaces(string);
        iUnoComposite.addChild(iUnoComposite2);
        IUnoComposite iUnoComposite3 = iUnoComposite2;
        while (iUnoComposite3.getChildren().length > 0) {
            IUnoComposite[] iUnoCompositeArray = iUnoComposite3.getChildren();
            if (iUnoCompositeArray.length != 1) continue;
            iUnoComposite3 = iUnoCompositeArray[0];
        }
        return iUnoComposite3;
    }

    private static void createIncludes(IUnoComposite iUnoComposite, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            iUnoComposite.addChild(CompositeFactory.createInclude(stringArray[i]));
        }
    }

    private static String getSkeletonServiceName(UnoFactoryData unoFactoryData) {
        String string = null;
        UnoFactoryData[] unoFactoryDataArray = unoFactoryData.getInnerData();
        for (int i = 0; i < unoFactoryDataArray.length && string == null; ++i) {
            int n = (Integer)unoFactoryDataArray[i].getProperty("type_nature");
            if (n != 4) continue;
            String string2 = (String)unoFactoryDataArray[i].getProperty("type_name");
            String string3 = (String)unoFactoryDataArray[i].getProperty("package_name");
            String string4 = string3 + "::" + string2;
            string = string4 = string4.replaceAll("::", ".");
        }
        return string;
    }

    private static String getSkeletonTypesRegistry(IUnoidlProject iUnoidlProject) {
        String[] stringArray;
        String string = "";
        for (String string2 : stringArray = iUnoidlProject.getOOo().getTypesPath()) {
            string2 = string2.replace("\\", "/");
            string2 = string2.replace(" ", "%20");
            string2 = "file:///" + string2;
            string = string + " -l " + string2;
        }
        String string3 = iUnoidlProject.getTypesPath().toString();
        string = string + " -l " + string3;
        return string;
    }
}

