/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.internal.model.Messages;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.SDKContainer;
import org.libreoffice.ide.eclipse.core.model.config.IConfigListener;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.language.AbstractLanguage;
import org.libreoffice.ide.eclipse.core.model.language.IProjectHandler;
import org.libreoffice.ide.eclipse.core.model.language.LanguagesHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UnoidlProject
implements IUnoidlProject,
IProjectNature {
    public static final String COMPANY_PREFIX = "project.prefix";
    public static final String OUTPUT_EXT = "project.implementation";
    public static final String SDK_NAME = "project.sdk";
    public static final String OOO_NAME = "project.ooo";
    public static final String LANGUAGE = "project.language";
    public static final String SRC_DIRECTORY = "project.srcdir";
    public static final String IDL_DIR = "project.idl";
    public static final String BUILD_DIR = "project.build";
    public static final String BUILD_FILE = "build.properties";
    private static final String CONFIG_FILE = ".unoproject";
    private static final String MANIFEST_FILE = "META-INF/manifest.xml";
    private IProject mProject;
    private String mCompanyPrefix;
    private String mOutputExtension;
    private ISdk mSdk;
    private IOOo mOOo;
    private AbstractLanguage mLanguage;
    private String mIdlDir;
    private String mSourcesDir;
    private IConfigListener mConfigListener = new configListener();

    public UnoidlProject() {
        SDKContainer.addListener(this.mConfigListener);
        OOoContainer.addListener(this.mConfigListener);
    }

    @Override
    public void dispose() {
        SDKContainer.removeListener(this.mConfigListener);
        OOoContainer.removeListener(this.mConfigListener);
    }

    public IPath getIdlRelativePath(IResource iResource) {
        IPath iPath = null;
        IPath iPath2 = iResource.getProjectRelativePath();
        if (iPath2.toString().startsWith(this.getIdlPath().toString())) {
            iPath = iPath2.removeFirstSegments(this.getIdlPath().segmentCount());
        }
        return iPath;
    }

    @Override
    public AbstractLanguage getLanguage() {
        return this.mLanguage;
    }

    @Override
    public String getName() {
        return this.getProject().getName();
    }

    @Override
    public IOOo getOOo() {
        return this.mOOo;
    }

    @Override
    public ISdk getSdk() {
        return this.mSdk;
    }

    @Override
    public void setLanguage(AbstractLanguage abstractLanguage) {
        if (this.mLanguage == null && abstractLanguage != null) {
            this.mLanguage = abstractLanguage;
            this.mLanguage.getProjectHandler().addProjectNature(this.getProject());
            PluginLogger.debug("Language specific nature added");
        }
    }

    @Override
    public void setOOo(IOOo iOOo) {
        this.setErrorMarker(null == iOOo || null == this.getSdk());
        try {
            IProjectHandler iProjectHandler = this.getLanguage().getProjectHandler();
            iProjectHandler.removeOOoDependencies(this.mOOo, this.getProject());
            iProjectHandler.addOOoDependencies(iOOo, this.getProject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mOOo = iOOo;
    }

    @Override
    public void setSdk(ISdk iSdk) {
        this.setErrorMarker(iSdk == null || null == this.getOOo());
        this.mSdk = iSdk;
    }

    @Override
    public void setIdlDir(String string) {
        this.mIdlDir = string;
    }

    @Override
    public void setSourcesDir(String string) {
        if (string == null || string.equals("")) {
            string = "/source";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        this.mSourcesDir = string;
    }

    @Override
    public String getRootModule() {
        String string = "";
        if (null != this.mCompanyPrefix) {
            string = this.mCompanyPrefix.replaceAll("\\.", "::");
        }
        return string;
    }

    @Override
    public IPath getRootModulePath() {
        IPath iPath = null;
        if (null != this.mCompanyPrefix) {
            iPath = this.getIdlPath().append(this.mCompanyPrefix.replaceAll("\\.", "/"));
        }
        return iPath;
    }

    @Override
    public void setCompanyPrefix(String string) {
        this.mCompanyPrefix = string;
    }

    @Override
    public String getCompanyPrefix() {
        return this.mCompanyPrefix;
    }

    @Override
    public void setOutputExtension(String string) {
        this.mOutputExtension = string;
    }

    @Override
    public String getOutputExtension() {
        return this.mOutputExtension;
    }

    @Override
    public IPath getBuildPath() {
        String string = this.getProperty(BUILD_DIR);
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.getFolder(string).getProjectRelativePath();
    }

    @Override
    public String getIdlDir() {
        String string = this.getProperty(IDL_DIR);
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public IPath getIdlPath() {
        String string = this.getProperty(IDL_DIR);
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.getFolder(string).getProjectRelativePath();
    }

    @Override
    public IPath getImplementationPath() {
        String string = new String(this.mCompanyPrefix + "." + this.mOutputExtension).replace('.', '/');
        return this.getSourcePath().append(string);
    }

    @Override
    public IPath getProjectPath() {
        return this.getProject().getLocation();
    }

    @Override
    public IPath getTypesPath() {
        return new Path("types.rdb");
    }

    @Override
    public IPath getServicesPath() {
        return new Path("services.rdb");
    }

    @Override
    public IPath getSourcePath() {
        if (this.mSourcesDir == null) {
            this.mSourcesDir = this.getProperty(SRC_DIRECTORY);
        }
        return this.getFolder(this.mSourcesDir).getProjectRelativePath();
    }

    @Override
    public IPath getUrdPath() {
        return this.getFolder(this.getBuildPath().append("/urd")).getProjectRelativePath();
    }

    @Override
    public IPath getDistPath() {
        return this.getFolder("dist").getProjectRelativePath();
    }

    @Override
    public IFolder getDistFolder() throws CoreException {
        IFolder iFolder = this.getFolder(this.getDistPath());
        if (!iFolder.exists()) {
            iFolder.getLocation().toFile().mkdirs();
        }
        return iFolder;
    }

    @Override
    public IPath getOfficeUserProfilePath() {
        return this.getFolder(this.getDistPath().append(".ooo-debug")).getProjectRelativePath();
    }

    @Override
    public IFolder getOfficeUserProfileFolder() throws CoreException {
        IFolder iFolder = this.getFolder(this.getOfficeUserProfilePath());
        if (!iFolder.exists()) {
            iFolder.getLocation().toFile().mkdirs();
        }
        return iFolder;
    }

    @Override
    public IFile getFile(IPath iPath) {
        return this.getProject().getFile(iPath);
    }

    @Override
    public IFile getFile(String string) {
        return this.getProject().getFile(string);
    }

    @Override
    public IFolder getFolder(IPath iPath) {
        return this.getProject().getFolder(iPath);
    }

    @Override
    public IFolder getFolder(String string) {
        return this.getProject().getFolder(string);
    }

    public File getConfigFile() {
        return new File(this.getProjectPath().append(CONFIG_FILE).toOSString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String string) {
        Properties properties = new Properties();
        File file = this.getConfigFile();
        String string2 = null;
        FileInputStream fileInputStream = null;
        try {
            if (!file.exists()) {
                UnoidlProjectHelper.createDefaultConfig(file);
            }
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            string2 = properties.getProperty(string);
        }
        catch (Exception exception) {
            String string3 = Messages.getString("UnoidlProject.UnreadableConfigFileWarning");
            PluginLogger.warning(MessageFormat.format(string3, CONFIG_FILE), exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, String string2) {
        Properties properties = new Properties();
        File file = this.getConfigFile();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (!file.exists()) {
                UnoidlProjectHelper.createDefaultConfig(file);
            }
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            properties.setProperty(string, string2);
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, Messages.getString("UnoidlProject.ConfigFileComment"));
            this.getFile(CONFIG_FILE).refreshLocal(0, null);
        }
        catch (Exception exception) {
            String string3 = Messages.getString("UnoidlProject.PropertyChangeError");
            PluginLogger.warning(MessageFormat.format(string3, string, string2), exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void saveAllProperties() {
        if (this.mLanguage == null || this.mOOo == null || this.mSdk == null) {
            PluginLogger.warning(Messages.getString("UnoidlProject.InconsistentConfigurationError"));
            return;
        }
        this.saveUnoProject();
        File file = this.getBuildFile();
        if (file.exists()) {
            Properties properties = this.getBuildProperties(file);
            this.setProjectBuildProperties(properties);
            this.saveBuildProperties(properties, file);
        }
    }

    @Override
    public void saveJavaBuildProperties(List<IResource> list) {
        File file = this.getBuildFile();
        Properties properties = this.getBuildProperties(file);
        String string = String.join((CharSequence)", ", list.stream().map(IResource::getFullPath).map(IPath::makeRelative).map(IPath::toString).collect(Collectors.toList()));
        String string2 = Messages.getString("UnoidlProject.SaveJavaBuildProperties");
        PluginLogger.debug(MessageFormat.format(string2, file.toString(), string));
        properties.put("uno.java.classpath", string);
        this.saveBuildProperties(properties, file);
    }

    @Override
    public boolean hasBuildFile() {
        return this.getBuildFile().exists();
    }

    @Override
    public void createBuildProperties() {
        Properties properties = new Properties();
        this.setProjectBuildProperties(properties);
        this.saveBuildProperties(properties, this.getBuildFile());
    }

    @Override
    public IFolder[] getBinFolders() {
        return this.getLanguage().getProjectHandler().getBinFolders(this);
    }

    @Override
    public IFile getComponentsFile() {
        return this.getFile("package.components");
    }

    @Override
    public IFile getTypesFile() {
        return this.getFile("types.rdb");
    }

    @Override
    public Document getComponentsDocument() {
        return this.getComponentsDocument(true);
    }

    @Override
    public Document getComponentsDocument(boolean bl) {
        Document document = null;
        File file = this.getComponentsFile().getLocation().toFile();
        try {
            DocumentBuilder documentBuilder = this.getNewDocumentBuilder();
            if (file.exists()) {
                document = documentBuilder.parse(file);
            } else if (bl) {
                document = documentBuilder.newDocument();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            PluginLogger.error(Messages.getString("UnoidlProject.GetComponentsFileError"), exception);
        }
        return document;
    }

    @Override
    public Element getComponentsElement(Document document) {
        Element element = null;
        File file = this.getComponentsFile().getLocation().toFile();
        if (file.exists()) {
            element = document.getDocumentElement();
        } else {
            element = document.createElement("components");
            element.setAttribute("xmlns", "http://openoffice.org/2010/uno-components");
            document.appendChild(element);
        }
        return element;
    }

    @Override
    public boolean removeImplementation(Element element, Element element2, String string) {
        boolean bl = false;
        NodeList nodeList = element2.getElementsByTagName("implementation");
        int n = nodeList.getLength();
        for (int i = n - 1; i >= 0 && !bl; --i) {
            bl = this.removeImplementation(element, element2, nodeList.item(i), string, n);
        }
        return bl;
    }

    @Override
    public Element createImplementation(Document document, Element element, String string, String[] stringArray) {
        Element element2 = document.createElement("implementation");
        this.setNameAttribute(element2, string);
        for (String string2 : stringArray) {
            element2.appendChild(this.createServiceElement(document, string2));
        }
        element.appendChild(element2);
        return element2;
    }

    @Override
    public Element getImplementationElement(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName("implementation");
        for (int i = 0; i < nodeList.getLength() && element2 == null; ++i) {
            element2 = this.getImplementation(nodeList.item(i), string);
        }
        return element2;
    }

    @Override
    public boolean addServiceElements(Document document, Element element, String[] stringArray) {
        boolean bl = true;
        NodeList nodeList = element.getElementsByTagName("service");
        int n = nodeList.getLength();
        if (n > 0 && n == stringArray.length) {
            bl = this.isServiceNamesChanged(nodeList, n, stringArray);
        }
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                element.removeChild(nodeList.item(i));
            }
            for (String string : stringArray) {
                element.appendChild(this.createServiceElement(document, string));
            }
        }
        return bl;
    }

    private boolean isServiceNamesChanged(NodeList nodeList, int n, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < n && !bl; ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || this.hasNameAttribute(element = (Element)node) && this.getNameAttribute(element).equals(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void removeImplementationElements(Element element, Element element2) {
        NodeList nodeList = element.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Element element3;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (element3 = (Element)node).equals(element2)) continue;
            element.removeChild(element3);
        }
    }

    @Override
    public void writeComponentsFile(Document document) {
        this.checkManifestComponents();
        this.writeXmlFile(document, this.getComponentsFile().getLocation().toFile());
    }

    @Override
    public void checkManifestTypes() {
        Document document;
        File file = this.getFile(MANIFEST_FILE).getLocation().toFile();
        if (!file.exists()) {
            this.createManifestFile();
        }
        if ((document = this.getManifestXmlDocument(file)) != null) {
            String string = "application/vnd.sun.star.uno-typelibrary;type=RDB";
            this.checkManifestFileEntry(document, file, string, "types.rdb");
        }
    }

    public void configure() throws CoreException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = this.getProperty(SDK_NAME);
        if (string7 != null) {
            this.setSdk(SDKContainer.getSDK(string7));
        }
        if ((string6 = this.getProperty(COMPANY_PREFIX)) != null) {
            this.mCompanyPrefix = string6;
        }
        if ((string5 = this.getProperty(OUTPUT_EXT)) != null) {
            this.mOutputExtension = string5;
        }
        if ((string4 = this.getProperty(LANGUAGE)) != null) {
            this.setLanguage(LanguagesHelper.getLanguageFromName(string4));
        }
        if ((string3 = this.getProperty(IDL_DIR)) != null) {
            this.setIdlDir(string3);
        }
        if ((string2 = this.getProperty(SRC_DIRECTORY)) != null) {
            this.setSourcesDir(string2);
        }
        if ((string = this.getProperty(OOO_NAME)) != null) {
            IOOo iOOo = OOoContainer.getSomeOOo(string);
            this.setOOo(iOOo);
        }
    }

    public void deconfigure() throws CoreException {
        this.dispose();
    }

    @Override
    public IProject getProject() {
        return this.mProject;
    }

    public void setProject(IProject iProject) {
        this.mProject = iProject;
    }

    public void setBuilders() throws CoreException {
        if (null != this.mSdk && null != this.mOOo && null != this.mCompanyPrefix && null != this.mOutputExtension) {
            IProjectDescription iProjectDescription = this.getProject().getDescription();
            ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
            ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
            ICommand iCommand = iProjectDescription.newCommand();
            iCommand.setBuilderName("org.libreoffice.ide.eclipse.core.types");
            iCommandArray2[0] = iCommand;
            System.arraycopy(iCommandArray, 0, iCommandArray2, 1, iCommandArray.length);
            iProjectDescription.setBuildSpec(iCommandArray2);
            this.getProject().setDescription(iProjectDescription, null);
        }
    }

    public String toString() {
        return "UNO Project " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUnoProject() {
        Properties properties = new Properties();
        File file = this.getConfigFile();
        if (!file.exists()) {
            UnoidlProjectHelper.createDefaultConfig(file);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            properties.setProperty(LANGUAGE, this.mLanguage.getName());
            properties.setProperty(OOO_NAME, this.mOOo.getName());
            properties.setProperty(SDK_NAME, this.mSdk.getName());
            properties.setProperty(IDL_DIR, this.mIdlDir);
            properties.setProperty(SRC_DIRECTORY, this.mSourcesDir);
            properties.setProperty(COMPANY_PREFIX, this.mCompanyPrefix);
            properties.setProperty(OUTPUT_EXT, this.mOutputExtension);
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, Messages.getString("UnoidlProject.ConfigFileComment"));
            this.getFile(CONFIG_FILE).refreshLocal(0, null);
        }
        catch (Exception exception) {
            PluginLogger.warning(Messages.getString("UnoidlProject.ConfigFileError"), exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void setErrorMarker(boolean bl) {
        IProject iProject = this.getProject();
        try {
            if (bl) {
                IMarker iMarker = iProject.createMarker("org.eclipse.core.resources.problemmarker");
                iMarker.setAttribute("severity", 2);
                iMarker.setAttribute("message", (Object)Messages.getString("UnoidlProject.NoOOoSdkError"));
            } else {
                iProject.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            }
        }
        catch (CoreException coreException) {
            if (bl) {
                PluginLogger.error(Messages.getString("UnoidlProject.CreateMarkerError") + this.getProjectPath().toString(), coreException);
            }
            PluginLogger.error(Messages.getString("UnoidlProject.RemoveMarkerError"), coreException);
        }
    }

    private File getBuildFile() {
        return new File(this.getProjectPath().toOSString(), BUILD_FILE);
    }

    private void saveBuildProperties(Properties properties, File file) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            properties.store(fileWriter, Messages.getString("UnoidlProject.BuildFileComment"));
            fileWriter.close();
        }
        catch (IOException iOException) {
            PluginLogger.warning(Messages.getString("UnoidlProject.BuildFileError"), iOException);
        }
    }

    private void setProjectBuildProperties(Properties properties) {
        properties.put("office.install.dir", this.getOOo().getHome());
        properties.put("sdk.dir", this.getSdk().getHome());
    }

    private Properties getBuildProperties(File file) {
        Properties properties = new Properties();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            properties.load(fileReader);
            fileReader.close();
        }
        catch (IOException iOException) {
            PluginLogger.warning(Messages.getString("UnoidlProject.BuildFileError"), iOException);
        }
        return properties;
    }

    private Element getImplementation(Node node, String string) {
        Element element = null;
        if (node.getNodeType() == 1 && this.hasNameAttribute((Element)node, string)) {
            element = (Element)node;
        }
        return element;
    }

    private boolean removeImplementation(Element element, Element element2, Node node, String string, int n) {
        boolean bl = false;
        if (node.getNodeType() == 1 && this.hasNameAttribute((Element)node, string)) {
            element2.removeChild(node);
            if (n == 1) {
                element.removeChild(element2);
            }
            bl = true;
        }
        return bl;
    }

    private Element createServiceElement(Document document, String string) {
        Element element = document.createElement("service");
        this.setNameAttribute(element, string);
        return element;
    }

    private boolean hasNameAttribute(Element element, String string) {
        return this.hasNameAttribute(element) && this.getNameAttribute(element).equals(string);
    }

    private boolean hasNameAttribute(Element element) {
        return element.hasAttribute("name");
    }

    private String getNameAttribute(Element element) {
        return element.getAttribute("name");
    }

    private void setNameAttribute(Element element, String string) {
        element.setAttribute("name", string);
    }

    private void checkManifestComponents() {
        Document document;
        File file = this.getFile(MANIFEST_FILE).getLocation().toFile();
        if (!file.exists()) {
            this.createManifestFile();
        }
        if ((document = this.getManifestXmlDocument(file)) != null) {
            String string = "application/vnd.sun.star.uno-components";
            this.checkManifestFileEntry(document, file, string, "package.components");
        }
    }

    private void createManifestFile() {
        Document document;
        File file = this.getFile(MANIFEST_FILE).getLocation().toFile();
        if (!file.exists() && (document = this.createManifestXmlDocument(file)) != null) {
            this.writeXmlFile(document, file);
        }
    }

    private Document getManifestXmlDocument(File file) {
        Document document = null;
        if (file.exists()) {
            try {
                document = this.getNewDocumentBuilder(true).parse(file);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                PluginLogger.error(Messages.getString("UnoidlProject.GetManifestXmlDocumentError"), exception);
            }
        } else {
            document = this.createManifestXmlDocument(file);
        }
        return document;
    }

    private Document createManifestXmlDocument(File file) {
        Document document = null;
        file.getParentFile().mkdir();
        String string = "manifest";
        String string2 = "http://openoffice.org/2001/manifest";
        try {
            document = this.getNewDocumentBuilder(true).newDocument();
            document.appendChild(document.createElementNS(string2, string + ":manifest"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            PluginLogger.error(Messages.getString("UnoidlProject.CreateManifestXmlDocumentError"), parserConfigurationException);
        }
        return document;
    }

    private DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        return this.getNewDocumentBuilder(false, false);
    }

    private DocumentBuilder getNewDocumentBuilder(boolean bl) throws ParserConfigurationException {
        return this.getNewDocumentBuilder(bl, false);
    }

    private DocumentBuilder getNewDocumentBuilder(boolean bl, boolean bl2) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        if (bl2) {
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    private void checkManifestFileEntry(Document document, File file, String string, String string2) {
        boolean bl = true;
        Element element = null;
        Element element2 = document.getDocumentElement();
        String string3 = element2.getNamespaceURI();
        String string4 = element2.getPrefix();
        NodeList nodeList = element2.getElementsByTagNameNS(string3, "file-entry");
        for (int i = 0; i < nodeList.getLength() && element == null; ++i) {
            Element element3;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element3 = (Element)node).hasAttributeNS(string3, "media-type") || !element3.getAttributeNS(string3, "media-type").equals(string)) continue;
            element = element3;
        }
        if (element == null) {
            element = document.createElementNS(string3, string4 + ":file-entry");
            element.setAttributeNS(string3, string4 + ":media-type", string);
            element.setAttributeNS(string3, string4 + ":full-path", string2);
            element2.appendChild(element);
        } else if (!element.hasAttributeNS(string3, "full-path") || !element.getAttributeNS(string3, "full-path").equals(string2)) {
            element.setAttributeNS(string3, string4 + ":full-path", string2);
        } else {
            bl = false;
        }
        if (bl) {
            this.writeXmlFile(document, file);
        }
    }

    private void writeXmlFile(Document document, File file) {
        this.writeXmlFile(document, file, false);
    }

    private void writeXmlFile(Document document, File file, boolean bl) {
        try {
            Object object;
            Object object2;
            document.setXmlStandalone(true);
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                object2 = nodeList.item(i);
                object2.getParentNode().removeChild((Node)object2);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            object2 = transformerFactory.newTransformer();
            ((Transformer)object2).setOutputProperty("encoding", "UTF-8");
            if (bl) {
                object = "-//OpenOffice.org//DTD Manifest 1.0//EN";
                ((Transformer)object2).setOutputProperty("doctype-public", (String)object);
                ((Transformer)object2).setOutputProperty("doctype-system", "Manifest.dtd");
            } else {
                ((Transformer)object2).setOutputProperty("doctype-public", "yes");
            }
            ((Transformer)object2).setOutputProperty("indent", "yes");
            object = new FileOutputStream(file);
            try {
                ((Transformer)object2).transform(new DOMSource(document), new StreamResult((OutputStream)object));
            }
            finally {
                ((FileOutputStream)object).close();
            }
            object = Messages.getString("UnoidlProject.WriteXmlFile");
            PluginLogger.debug(MessageFormat.format((String)object, file.toString()));
        }
        catch (IOException | TransformerException | XPathExpressionException exception) {
            String string = Messages.getString("UnoidlProject.WriteXmlFileError");
            PluginLogger.error(MessageFormat.format(string, file.toString()), exception);
        }
    }

    private class configListener
    implements IConfigListener {
        private configListener() {
        }

        @Override
        public void ConfigAdded(Object object) {
        }

        @Override
        public void ConfigRemoved(Object object) {
            if (object instanceof ISdk) {
                if (object == UnoidlProject.this.getSdk()) {
                    UnoidlProject.this.setSdk(null);
                }
            } else if (object instanceof IOOo && object == UnoidlProject.this.getOOo()) {
                UnoidlProject.this.getLanguage().getProjectHandler().removeOOoDependencies(UnoidlProject.this.getOOo(), UnoidlProject.this.getProject());
                UnoidlProject.this.setOOo(null);
            }
        }

        @Override
        public void ConfigUpdated(Object object) {
            if (object instanceof IOOo && object == UnoidlProject.this.getOOo()) {
                UnoidlProject.this.getLanguage().getProjectHandler().removeOOoDependencies(UnoidlProject.this.getOOo(), UnoidlProject.this.getProject());
                UnoidlProject.this.getLanguage().getProjectHandler().addOOoDependencies(UnoidlProject.this.getOOo(), UnoidlProject.this.getProject());
            }
        }
    }
}

