/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.office;

import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import com.sun.star.uri.XExternalUriReferenceTranslator;
import java.io.File;
import java.net.URL;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.office.Messages;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;

public class OfficeConnection {
    private IOOo mOOo;
    private XComponentContext mContext;

    public OfficeConnection(IOOo iOOo) {
        this.mOOo = iOOo;
    }

    public IOOo getOOo() {
        return this.mOOo;
    }

    public XComponentContext getContext() {
        return this.mContext;
    }

    public void startOffice() throws BootstrapException {
        this.mContext = Bootstrap.bootstrap();
        PluginLogger.info("Office bootstrapped");
    }

    public void stopOffice() {
        try {
            if (this.mContext != null) {
                XMultiComponentFactory xMultiComponentFactory = this.mContext.getServiceManager();
                Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.mContext);
                XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)object);
                xDesktop.terminate();
                this.mContext = null;
                PluginLogger.info("Office stopped");
            }
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("OfficeConnection.ERROR_STOP"), exception);
        }
    }

    public String convertToUrl(String string) {
        String string2 = null;
        try {
            if (string != null) {
                URL uRL = new File(string).toURI().toURL();
                XExternalUriReferenceTranslator xExternalUriReferenceTranslator = ExternalUriReferenceTranslator.create((XComponentContext)this.mContext);
                string2 = xExternalUriReferenceTranslator.translateToInternal(uRL.toExternalForm());
            }
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("OfficeConnection.ERROR_CONVERT_URL") + string, exception);
        }
        return string2;
    }
}

