/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.internal.office;

import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.TypeDescriptionSearchDepth;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.reflection.XTypeDescriptionEnumeration;
import com.sun.star.reflection.XTypeDescriptionEnumerationAccess;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.libreoffice.ide.eclipse.core.internal.office.OfficeConnection;
import org.libreoffice.ide.eclipse.core.unotypebrowser.InternalUnoType;

public class TypesGetter {
    private static final int TYPES_MAX = 1023;
    private static final Map<Integer, TypeClass> TYPES_MAPPING = new HashMap<Integer, TypeClass>();
    private OfficeConnection mConnection;
    private List<String> mLocalRegs = new LinkedList<String>();
    private List<String> mExternalRegs = new LinkedList<String>();
    private String mRoot;
    private int mMask;
    private TypeClass[] mTypeClasses;

    public void setConnection(OfficeConnection officeConnection) {
        this.mConnection = officeConnection;
    }

    public void setLocalRegs(List<String> list) {
        this.mLocalRegs.clear();
        this.mLocalRegs.addAll(list);
    }

    public void setExternalRegs(List<String> list) {
        this.mExternalRegs.clear();
        this.mExternalRegs.addAll(list);
    }

    public Map<String, List<InternalUnoType>> getTypes(String string, Integer n) throws Throwable {
        HashMap<String, List<InternalUnoType>> hashMap = new HashMap();
        this.mConnection.startOffice();
        this.initialize(string, n);
        hashMap = this.queryTypes();
        this.mConnection.stopOffice();
        return hashMap;
    }

    private void initialize(String string, int n) {
        this.mRoot = string == null || string.equals("/") ? "" : string;
        if (n >= 1024) {
            n = 1023;
        }
        if (n >= 0 && 1024 > n) {
            this.mMask = n;
            this.mTypeClasses = this.convertToTypeClasses();
        }
    }

    private Map<String, List<InternalUnoType>> queryTypes() throws Exception {
        String string;
        String string2;
        int n;
        HashMap<String, List<InternalUnoType>> hashMap = new HashMap<String, List<InternalUnoType>>();
        int n2 = this.mLocalRegs.size();
        for (n = 0; n < n2; ++n) {
            string2 = this.mLocalRegs.get(n);
            string = this.mConnection.convertToUrl(string2);
            if (string == null) continue;
            hashMap.put(string2, this.getTypesFromRegistry(string, true));
        }
        n2 = this.mExternalRegs.size();
        for (n = 0; n < n2; ++n) {
            string2 = this.mExternalRegs.get(n);
            string = this.mConnection.convertToUrl(string2);
            if (string == null) continue;
            String string3 = this.mConnection.getOOo().getName();
            ArrayList<InternalUnoType> arrayList = (ArrayList<InternalUnoType>)hashMap.get(string3);
            if (arrayList == null) {
                arrayList = new ArrayList<InternalUnoType>();
                hashMap.put(string3, arrayList);
            }
            arrayList.addAll(this.getTypesFromRegistry(string, false));
        }
        return hashMap;
    }

    private LinkedList<InternalUnoType> getTypesFromRegistry(String string, boolean bl) throws Exception {
        LinkedList<InternalUnoType> linkedList = new LinkedList<InternalUnoType>();
        if (null != string && string.startsWith("file:///")) {
            XComponentContext xComponentContext = this.mConnection.getContext();
            XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
            XSimpleRegistry xSimpleRegistry = (XSimpleRegistry)UnoRuntime.queryInterface(XSimpleRegistry.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.registry.SimpleRegistry", xComponentContext));
            xSimpleRegistry.open(string, true, false);
            Object[] objectArray = new Object[]{xSimpleRegistry};
            Object object = xMultiComponentFactory.createInstanceWithArgumentsAndContext("com.sun.star.reflection.TypeDescriptionProvider", objectArray, xComponentContext);
            XTypeDescriptionEnumerationAccess xTypeDescriptionEnumerationAccess = (XTypeDescriptionEnumerationAccess)UnoRuntime.queryInterface(XTypeDescriptionEnumerationAccess.class, (Object)object);
            XTypeDescriptionEnumeration xTypeDescriptionEnumeration = xTypeDescriptionEnumerationAccess.createTypeDescriptionEnumeration(this.mRoot, this.mTypeClasses, TypeDescriptionSearchDepth.INFINITE);
            while (xTypeDescriptionEnumeration.hasMoreElements()) {
                XTypeDescription xTypeDescription = xTypeDescriptionEnumeration.nextTypeDescription();
                linkedList.add(this.createInternalType(xTypeDescription, bl));
            }
        }
        return linkedList;
    }

    private boolean isOfType(int n, int n2) {
        return (n & n2) != 0;
    }

    private TypeClass[] convertToTypeClasses() {
        Vector<TypeClass> vector = new Vector<TypeClass>();
        this.tryAddingType(1, vector);
        this.tryAddingType(2, vector);
        this.tryAddingType(4, vector);
        this.tryAddingType(8, vector);
        this.tryAddingType(16, vector);
        this.tryAddingType(32, vector);
        this.tryAddingType(64, vector);
        this.tryAddingType(128, vector);
        this.tryAddingType(256, vector);
        this.tryAddingType(512, vector);
        TypeClass[] typeClassArray = vector.toArray(new TypeClass[vector.size()]);
        vector.clear();
        return typeClassArray;
    }

    private void tryAddingType(int n, Vector<TypeClass> vector) {
        if (this.isOfType(this.mMask, n)) {
            vector.add(TYPES_MAPPING.get(n));
        }
    }

    private InternalUnoType createInternalType(XTypeDescription xTypeDescription, boolean bl) {
        TypeClass typeClass = xTypeDescription.getTypeClass();
        int n = 0;
        Iterator<Map.Entry<Integer, TypeClass>> iterator = TYPES_MAPPING.entrySet().iterator();
        boolean bl2 = false;
        while (iterator.hasNext() && !bl2) {
            Map.Entry<Integer, TypeClass> entry = iterator.next();
            if (!entry.getValue().equals(typeClass)) continue;
            n = entry.getKey();
            bl2 = true;
        }
        return new InternalUnoType(xTypeDescription.getName(), n, bl);
    }

    static {
        TYPES_MAPPING.put(1, TypeClass.MODULE);
        TYPES_MAPPING.put(2, TypeClass.INTERFACE);
        TYPES_MAPPING.put(4, TypeClass.SERVICE);
        TYPES_MAPPING.put(8, TypeClass.STRUCT);
        TYPES_MAPPING.put(16, TypeClass.ENUM);
        TYPES_MAPPING.put(32, TypeClass.EXCEPTION);
        TYPES_MAPPING.put(64, TypeClass.TYPEDEF);
        TYPES_MAPPING.put(128, TypeClass.CONSTANT);
        TYPES_MAPPING.put(256, TypeClass.CONSTANTS);
        TYPES_MAPPING.put(512, TypeClass.SINGLETON);
    }
}

