/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.UnoProjectLabelProvider;
import org.libreoffice.ide.eclipse.core.launch.MainImplementationsProvider;
import org.libreoffice.ide.eclipse.core.launch.Messages;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;

public class UreTab
extends AbstractLaunchConfigurationTab {
    private static final int LAYOUT_COLUMNS = 3;
    private IUnoidlProject mProject;
    private Text mProjectTxt;
    private Button mProjectBtn;
    private Text mMainTxt;
    private Button mMainBtn;
    private Text mArgumentsTxt;
    private ChangeListener mListener = new ChangeListener();

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout());
        Group group = new Group(composite2, 0);
        group.setText(Messages.getString("UreTab.RunApplicationLabel"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.createProjectField((Composite)group);
        this.createMainField((Composite)group);
        Group group2 = new Group(composite2, 0);
        group2.setText(Messages.getString("UreTab.ApplicationArgsLabel"));
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(1808));
        this.mArgumentsTxt = new Text((Composite)group2, 2626);
        this.mArgumentsTxt.setLayoutData((Object)new GridData(1808));
        this.mArgumentsTxt.addModifyListener((ModifyListener)this.mListener);
        this.setControl((Control)composite2);
    }

    public Image getImage() {
        return OOEclipsePlugin.getImage("URE_APP");
    }

    public String getName() {
        return Messages.getString("UreTab.TabTitle");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            this.mProjectTxt.setText(iLaunchConfiguration.getAttribute("project_name", ""));
            this.mMainTxt.setText(iLaunchConfiguration.getAttribute("main_type", ""));
            this.mArgumentsTxt.setText(iLaunchConfiguration.getAttribute("program_args", ""));
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.getString("UreTab.ConfigurationError"), coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("project_name", this.mProjectTxt.getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute("main_type", this.mMainTxt.getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute("program_args", this.mArgumentsTxt.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = false;
        try {
            boolean bl2;
            boolean bl3 = !iLaunchConfiguration.getAttribute("project_name", "").equals("");
            boolean bl4 = bl2 = !iLaunchConfiguration.getAttribute("main_type", "").equals("");
            if (bl3 && bl2) {
                String string = iLaunchConfiguration.getAttribute("project_name", "");
                bl = ProjectsManager.getProject(string) != null;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return bl;
    }

    private void createProjectField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("UreTab.ProjectLabel"));
        label.setLayoutData((Object)new GridData(32));
        this.mProjectTxt = new Text(composite2, 2052);
        this.mProjectTxt.setLayoutData((Object)new GridData(768));
        this.mProjectTxt.addModifyListener((ModifyListener)this.mListener);
        this.mProjectBtn = new Button(composite2, 8);
        this.mProjectBtn.setText("...");
        this.mProjectBtn.addSelectionListener((SelectionListener)this.mListener);
    }

    private void createMainField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("UreTab.MainImplementationLabel"));
        label.setLayoutData((Object)new GridData(32));
        this.mMainTxt = new Text(composite2, 2052);
        this.mMainTxt.setLayoutData((Object)new GridData(768));
        this.mMainTxt.addModifyListener((ModifyListener)this.mListener);
        this.mMainBtn = new Button(composite2, 8);
        this.mMainBtn.setText("...");
        this.mMainBtn.addSelectionListener((SelectionListener)this.mListener);
    }

    private class ChangeListener
    implements SelectionListener,
    ModifyListener {
        private ChangeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource().equals(UreTab.this.mProjectBtn)) {
                UnoProjectLabelProvider unoProjectLabelProvider = new UnoProjectLabelProvider();
                ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(UreTab.this.getShell(), (ILabelProvider)unoProjectLabelProvider);
                elementListSelectionDialog.setTitle(Messages.getString("UreTab.ProjectChooserTitle"));
                elementListSelectionDialog.setMessage(Messages.getString("UreTab.ProjectChooserMessage"));
                elementListSelectionDialog.setElements((Object[])ProjectsManager.getProjects());
                if (elementListSelectionDialog.open() == 0) {
                    UreTab.this.mProject = (IUnoidlProject)elementListSelectionDialog.getFirstResult();
                    UreTab.this.mProjectTxt.setText(UreTab.this.mProject.getName());
                    UreTab.this.setDirty(true);
                    UreTab.this.getLaunchConfigurationDialog().updateButtons();
                }
            } else if (selectionEvent.getSource().equals(UreTab.this.mMainBtn)) {
                ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(UreTab.this.getShell(), (ILabelProvider)new LabelProvider(){

                    public String getText(Object object) {
                        String string = null;
                        if (object instanceof String) {
                            string = (String)object;
                        }
                        return string;
                    }
                });
                elementListSelectionDialog.setTitle(Messages.getString("UreTab.MainImplementationChooserTitle"));
                elementListSelectionDialog.setMessage(Messages.getString("UreTab.MainImplementationChooserMessage"));
                elementListSelectionDialog.setElements((Object[])new MainImplementationsProvider().getImplementations(UreTab.this.mProject));
                if (elementListSelectionDialog.open() == 0) {
                    UreTab.this.mMainTxt.setText((String)elementListSelectionDialog.getFirstResult());
                    UreTab.this.setDirty(true);
                    UreTab.this.getLaunchConfigurationDialog().updateButtons();
                }
            }
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (modifyEvent.getSource() == UreTab.this.mProjectTxt) {
                IUnoidlProject iUnoidlProject = ProjectsManager.getProject(UreTab.this.mProjectTxt.getText().trim());
                if (iUnoidlProject != null) {
                    UreTab.this.mProject = iUnoidlProject;
                    UreTab.this.setErrorMessage(null);
                } else {
                    UreTab.this.mProject = null;
                    UreTab.this.setErrorMessage(Messages.getString("UreTab.ProjectChooserError"));
                }
                UreTab.this.getLaunchConfigurationDialog().updateMessage();
            }
            UreTab.this.setDirty(true);
            UreTab.this.getLaunchConfigurationDialog().updateButtons();
        }
    }
}

