/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.launch.office;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.TypesBuilder;
import org.libreoffice.ide.eclipse.core.gui.PackageContentSelector;
import org.libreoffice.ide.eclipse.core.launch.office.Messages;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.NullExtraOptionsProvider;
import org.libreoffice.ide.eclipse.core.model.pack.PackagePropertiesModel;
import org.libreoffice.plugin.core.model.UnoPackage;

public class OfficeLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final int TASK_UNITS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(MessageFormat.format("{0}...", iLaunchConfiguration.getName()), 3);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String string2 = iLaunchConfiguration.getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", new String());
            boolean bl = iLaunchConfiguration.getAttribute("org.libreoffice.ide.eclipse.core.USE_CLEAN_USER_INSTALLATION_ATTR", false);
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string2);
            if (null != iUnoidlProject) {
                try {
                    IFolder iFolder;
                    IPath iPath = null;
                    if (bl) {
                        iFolder = iUnoidlProject.getOfficeUserProfileFolder();
                        iPath = iFolder.getLocation();
                    }
                    iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
                    TypesBuilder.build((IProject)iFolder, iProgressMonitor);
                    IFile iFile = iFolder.getFile("package.properties");
                    PackagePropertiesModel packagePropertiesModel = new PackagePropertiesModel(iFile);
                    List<IResource> list = packagePropertiesModel.getContents();
                    File file = this.exportComponent(iUnoidlProject, list);
                    iProgressMonitor.worked(1);
                    this.deployComponent(iUnoidlProject, iPath, file);
                    iProgressMonitor.worked(1);
                    if ("debug".equals(string)) {
                        iUnoidlProject.getLanguage().connectDebuggerToOffice(iUnoidlProject, iLaunch, iPath, iProgressMonitor);
                    } else {
                        iUnoidlProject.getOOo().runOffice(iUnoidlProject, iLaunch, iPath, new NullExtraOptionsProvider(), iProgressMonitor);
                    }
                    iProgressMonitor.worked(1);
                }
                catch (Exception exception) {
                    PluginLogger.error(Messages.OfficeLaunchDelegate_LaunchError, exception);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.OfficeLaunchDelegate_LaunchErrorTitle, (String)Messages.OfficeLaunchDelegate_LaunchError);
                        }
                    });
                }
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void deployComponent(IUnoidlProject iUnoidlProject, IPath iPath, File file) {
        IOOo iOOo = iUnoidlProject.getOOo();
        if (iOOo.canManagePackages()) {
            iOOo.updatePackage(file, iPath);
        }
    }

    private File exportComponent(IUnoidlProject iUnoidlProject, List<IResource> list) throws Exception {
        IFolder iFolder = iUnoidlProject.getDistFolder();
        File file = iFolder.getFile(iUnoidlProject.getName() + ".oxt").getLocation().toFile();
        UnoPackage unoPackage = PackageContentSelector.createPackage(iUnoidlProject, file, list);
        unoPackage.close();
        return file;
    }
}

