/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.launch.office;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.PackageContentSelector;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;

public class OfficeLaunchShortcut
implements ILaunchShortcut {
    private static final String OFFICE_LAUNCH_CONFIG_ID = "org.libreoffice.ide.eclipse.core.launchlibreoffice";

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            IUnoidlProject iUnoidlProject = null;
            while (iterator.hasNext() && iUnoidlProject == null) {
                IAdaptable iAdaptable;
                IResource iResource;
                Object e = iterator.next();
                if (!(e instanceof IAdaptable) || (iResource = (IResource)(iAdaptable = (IAdaptable)e).getAdapter(IResource.class)) == null) continue;
                iUnoidlProject = ProjectsManager.getProject(iResource.getProject().getName());
            }
            if (iUnoidlProject != null) {
                this.launch(iUnoidlProject, string);
            }
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IUnoidlProject iUnoidlProject;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile != null && (iUnoidlProject = ProjectsManager.getProject(iFile.getProject().getName())) != null) {
            this.launch(iUnoidlProject, string);
        }
    }

    private ILaunchConfiguration createDefaultLaunchConfiguration(IUnoidlProject iUnoidlProject) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            IFile iFile2;
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(OFFICE_LAUNCH_CONFIG_ID);
            String string = iLaunchManager.generateLaunchConfigurationName(iUnoidlProject.getName());
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", iUnoidlProject.getName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.USE_CLEAN_USER_INSTALLATION_ATTR", true);
            List<IFile> list = PackageContentSelector.getDefaultContent(iUnoidlProject);
            String string2 = new String();
            for (IFile iFile2 : list) {
                if (!string2.isEmpty()) {
                    string2 = string2 + ":";
                }
                string2 = string2 + iFile2.getProjectRelativePath().toString();
            }
            iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.PACKAGE_CONTENT_PATHS", string2);
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
            iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iProject});
            iFile2 = new CommonTab();
            iFile2.setDefaults(iLaunchConfigurationWorkingCopy);
            iFile2.dispose();
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            PluginLogger.error("Error creating the launch configuration", coreException);
            iLaunchConfiguration = null;
        }
        return iLaunchConfiguration;
    }

    protected List<ILaunchConfiguration> findExistingLaunchConfigurations(IUnoidlProject iUnoidlProject) {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(OFFICE_LAUNCH_CONFIG_ID);
        ArrayList<ILaunchConfiguration> arrayList = new ArrayList<ILaunchConfiguration>();
        if (iLaunchConfigurationType != null) {
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray = iLaunchManager.getLaunchConfigurations(iLaunchConfigurationType);
                for (int i = 0; i < iLaunchConfigurationArray.length; ++i) {
                    String string = iLaunchConfigurationArray[i].getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", "");
                    if (!iUnoidlProject.getName().equals(string)) continue;
                    arrayList.add(iLaunchConfigurationArray[i]);
                }
            }
            catch (CoreException coreException) {
                PluginLogger.error("Unexpected error", coreException);
            }
        }
        return arrayList;
    }

    private void launch(IUnoidlProject iUnoidlProject, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        List<ILaunchConfiguration> list = this.findExistingLaunchConfigurations(iUnoidlProject);
        iLaunchConfiguration = list.isEmpty() ? this.createDefaultLaunchConfiguration(iUnoidlProject) : list.get(0);
        if (iLaunchConfiguration != null) {
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
    }
}

