/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.launch.office;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.UnoProjectLabelProvider;
import org.libreoffice.ide.eclipse.core.launch.office.Messages;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;

public class OfficeTab
extends AbstractLaunchConfigurationTab {
    private static final int LAYOUT_COLUMNS = 3;
    private Text mProjectTxt;
    private Button mProjectBtn;
    private Button mUseCleanUserInstallation;
    private SelectionListener mListener = new ChangeListener();

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout());
        this.createProjectGroup(composite2);
        this.createOptionsGroup(composite2);
        this.setControl((Control)composite2);
    }

    private void createOptionsGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.OfficeTab_Options);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.mUseCleanUserInstallation = this.createCheckButton((Composite)group, Messages.OfficeTab_ChkUseCleanUserInstallation);
        this.mUseCleanUserInstallation.addSelectionListener(this.mListener);
        this.mUseCleanUserInstallation.setToolTipText(Messages.OfficeTab_ChkUseCleanUserInstallation_ToolTip);
    }

    private void createProjectGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.OfficeTab_UnoProject);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(Messages.OfficeTab_ProjectNameLabel);
        label.setLayoutData((Object)new GridData(32));
        this.mProjectTxt = new Text(composite2, 2052);
        this.mProjectTxt.setLayoutData((Object)new GridData(768));
        this.mProjectBtn = new Button(composite2, 8);
        this.mProjectBtn.setText("...");
        this.mProjectBtn.addSelectionListener(this.mListener);
    }

    public String getName() {
        return Messages.OfficeTab_Title;
    }

    public Image getImage() {
        return OOEclipsePlugin.getImage("OFFICE_APP");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            this.mProjectTxt.setText(iLaunchConfiguration.getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", ""));
            this.mUseCleanUserInstallation.setSelection(iLaunchConfiguration.getAttribute("org.libreoffice.ide.eclipse.core.USE_CLEAN_USER_INSTALLATION_ATTR", false));
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.OfficeTab_Configurationerror, coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", this.mProjectTxt.getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.USE_CLEAN_USER_INSTALLATION_ATTR", this.mUseCleanUserInstallation.getSelection());
        try {
            String string = iLaunchConfigurationWorkingCopy.getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", "");
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string);
            if (null != iUnoidlProject) {
                iUnoidlProject.getLanguage().configureSourceLocator(iLaunchConfigurationWorkingCopy);
            }
        }
        catch (CoreException coreException) {
            PluginLogger.error("Could not set language specific source locator attributes.", coreException);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", "");
        iLaunchConfigurationWorkingCopy.setAttribute("org.libreoffice.ide.eclipse.core.USE_CLEAN_USER_INSTALLATION_ATTR", false);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = false;
        try {
            boolean bl2;
            boolean bl3 = bl2 = !iLaunchConfiguration.getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", "").equals("");
            if (bl2) {
                String string = iLaunchConfiguration.getAttribute("org.libreoffice.ide.eclipse.core.PROJECT_ATTR", "");
                bl = ProjectsManager.getProject(string) != null;
            }
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.OfficeTab_Configurationerror, coreException);
        }
        return bl;
    }

    private class ChangeListener
    extends SelectionAdapter {
        private ChangeListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource().equals(OfficeTab.this.mProjectBtn)) {
                UnoProjectLabelProvider unoProjectLabelProvider = new UnoProjectLabelProvider();
                ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(OfficeTab.this.getShell(), (ILabelProvider)unoProjectLabelProvider);
                elementListSelectionDialog.setTitle(Messages.OfficeTab_ProjectChooserTitle);
                elementListSelectionDialog.setMessage(Messages.OfficeTab_ProjectChooserMessage);
                elementListSelectionDialog.setElements((Object[])ProjectsManager.getProjects());
                if (elementListSelectionDialog.open() == 0) {
                    IUnoidlProject iUnoidlProject = (IUnoidlProject)elementListSelectionDialog.getFirstResult();
                    OfficeTab.this.mProjectTxt.setText(iUnoidlProject.getName());
                }
            }
            OfficeTab.this.setDirty(true);
            OfficeTab.this.getLaunchConfigurationDialog().updateButtons();
        }
    }
}

