/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model;

import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.libreoffice.ide.eclipse.core.internal.model.UnoComposite;
import org.libreoffice.ide.eclipse.core.model.IUnoComposite;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;

public final class CompositeFactory {
    public static IUnoComposite createTypeFile(String string, IUnoidlProject iUnoidlProject) {
        IUnoComposite iUnoComposite = null;
        if (string != null && !string.equals("")) {
            String string2 = string.replace("::", "/") + ".idl";
            IFile iFile = iUnoidlProject.getFile(iUnoidlProject.getIdlPath().append(string2));
            iUnoComposite = CompositeFactory.createFile(iFile);
        }
        return iUnoComposite;
    }

    public static IUnoComposite createFile(IFile iFile) {
        UnoComposite unoComposite = null;
        if (iFile != null) {
            unoComposite = new UnoComposite();
            unoComposite.setType(0);
            unoComposite.configure(iFile.getLocation().toString());
        }
        return unoComposite;
    }

    public static IUnoComposite createFileContent(String string) {
        UnoComposite unoComposite = null;
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string2 = string.replace("::", "_");
            string2 = "__" + string2 + "_idl__";
            hashtable.put("define", string2.toLowerCase());
            String string3 = "#ifndef ${define}\n#define ${define}\n\n${children}\n#endif\n";
            unoComposite.configure(hashtable, string3);
        }
        return unoComposite;
    }

    public static IUnoComposite createInclude(String string) {
        UnoComposite unoComposite = null;
        if (string != null && !string.equals("")) {
            String string2 = string.replace("::", "/") + ".idl";
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("file", string2);
            String string3 = "#include <${file}>\n";
            unoComposite.configure(hashtable, string3);
        }
        return unoComposite;
    }

    public static IUnoComposite createModuleDir(String string, IUnoidlProject iUnoidlProject) {
        UnoComposite unoComposite = new UnoComposite();
        unoComposite.setType(1);
        String string2 = string.replace("::", "/");
        IFolder iFolder = iUnoidlProject.getFolder(iUnoidlProject.getIdlPath().append(string2));
        unoComposite.configure(iFolder.getLocation().toString());
        return unoComposite;
    }

    public static IUnoComposite createModuleSpace(String string) {
        UnoComposite unoComposite = new UnoComposite();
        unoComposite.setType(2);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", string);
        String string2 = "module ${name} { ${children} };";
        unoComposite.configure(hashtable, string2);
        return unoComposite;
    }

    public static IUnoComposite createModulesSpaces(String string) {
        String[] stringArray;
        IUnoComposite iUnoComposite = null;
        if (string != null && !string.equals("") && (stringArray = string.split("::")).length > 0) {
            IUnoComposite iUnoComposite2 = iUnoComposite = CompositeFactory.createModuleSpace(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                IUnoComposite iUnoComposite3 = CompositeFactory.createModuleSpace(stringArray[i]);
                iUnoComposite2.addChild(iUnoComposite3);
                iUnoComposite2 = iUnoComposite3;
            }
        }
        return iUnoComposite;
    }

    public static IUnoComposite createService(String string, boolean bl, String string2) {
        UnoComposite unoComposite = null;
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            unoComposite.setIndented(true);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string);
            if (string2 != null && !string2.equals("")) {
                hashtable.put("interface", ": " + string2 + " ");
            } else {
                hashtable.put("interface", "");
            }
            if (bl) {
                hashtable.put("published", "published ");
            } else {
                hashtable.put("published", "");
            }
            String string3 = "\n\n${published}service ${name} ${interface}{\n${children}\n};\n\n";
            unoComposite.configure(hashtable, string3);
        }
        return unoComposite;
    }

    public static IUnoComposite createService(String string, boolean bl) {
        return CompositeFactory.createService(string, bl, null);
    }

    public static IUnoComposite createService(String string) {
        return CompositeFactory.createService(string, false, null);
    }

    public static IUnoComposite createInterface(String string, boolean bl, String[] stringArray) {
        UnoComposite unoComposite = null;
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            unoComposite.setIndented(true);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string);
            if (stringArray.length == 1) {
                hashtable.put("interface", ": " + stringArray[0] + " ");
            } else {
                hashtable.put("interface", "");
            }
            if (bl) {
                hashtable.put("published", "published ");
            } else {
                hashtable.put("published", "");
            }
            String string2 = "\n\n${published}interface ${name} ${interface}{\n${children}\n};\n\n";
            unoComposite.configure(hashtable, string2);
            if (stringArray.length > 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    IUnoComposite iUnoComposite = CompositeFactory.createInterfaceInheritance(stringArray[i], false);
                    if (iUnoComposite == null) continue;
                    unoComposite.addChild(iUnoComposite);
                }
            }
        }
        return unoComposite;
    }

    public static IUnoComposite createInterfaceInheritance(String string, boolean bl) {
        UnoComposite unoComposite = null;
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string);
            String string2 = "";
            if (bl) {
                string2 = "[optional] ";
            }
            hashtable.put("optional", string2);
            String string3 = "\t${optional}interface ${name};\n";
            unoComposite.configure(hashtable, string3);
        }
        return unoComposite;
    }

    public static IUnoComposite createAttribute(String string, String string2, String string3) {
        UnoComposite unoComposite = null;
        if (string2 == null) {
            string2 = "void";
        }
        if (string3 == null) {
            string3 = "";
        }
        string3.trim();
        if (string3 == null || string3.equals("")) {
            string3 = "";
        } else {
            string3 = string3.replace(" ", ", ");
            string3 = ", " + string3;
        }
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string);
            hashtable.put("type", string2);
            hashtable.put("flags", string3);
            String string4 = "\t[attribute${flags}] ${type} ${name};\n";
            unoComposite.configure(hashtable, string4);
        }
        return unoComposite;
    }

    public static IUnoComposite createMethod(String string, String string2) {
        UnoComposite unoComposite = null;
        if (string2 == null || string2.trim().equals("")) {
            string2 = "void";
        }
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            unoComposite.setChildrenSeparator(", ");
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string);
            hashtable.put("type", string2);
            String string3 = "\t${type} ${name}(${children});\n";
            unoComposite.configure(hashtable, string3);
        }
        return unoComposite;
    }

    public static IUnoComposite createMethodArgument(String string, String string2, String string3) {
        UnoComposite unoComposite = null;
        if (string2 == null) {
            string2 = "any";
        }
        if (string3 == null) {
            string3 = "inout";
        }
        if (string != null && !string.equals("")) {
            unoComposite = new UnoComposite();
            unoComposite.setType(2);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", string);
            hashtable.put("type", string2);
            hashtable.put("direction", string3);
            String string4 = "[${direction}] ${type} ${name}";
            unoComposite.configure(hashtable, string4);
        }
        return unoComposite;
    }
}

