/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.PropertiesManager;
import org.libreoffice.ide.eclipse.core.internal.model.OOo;
import org.libreoffice.ide.eclipse.core.internal.model.URE;
import org.libreoffice.ide.eclipse.core.model.config.IConfigListener;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;

public class OOoContainer {
    private static OOoContainer sInstance = new OOoContainer();
    private Vector<IConfigListener> mListeners;
    private HashMap<String, IOOo> mElements = new HashMap();

    private OOoContainer() {
        this.mListeners = new Vector();
    }

    public static void addListener(IConfigListener iConfigListener) {
        if (null != iConfigListener) {
            OOoContainer.sInstance.mListeners.add(iConfigListener);
        }
    }

    public static void removeListener(IConfigListener iConfigListener) {
        if (null != iConfigListener) {
            OOoContainer.sInstance.mListeners.remove(iConfigListener);
        }
    }

    public static Object[] toArray() {
        Vector<IOOo> vector = OOoContainer.toVector();
        Object[] objectArray = vector.toArray();
        vector.clear();
        return objectArray;
    }

    public static void addOOo(IOOo iOOo) {
        if (null != iOOo) {
            if (!OOoContainer.sInstance.mElements.containsKey(iOOo.getName())) {
                OOoContainer.sInstance.mElements.put(iOOo.getName(), iOOo);
                sInstance.fireOOoAdded(iOOo);
            } else {
                IOOo iOOo2 = OOoContainer.sInstance.mElements.get(iOOo.getName());
                OOoContainer.updateOOo(iOOo2.getName(), iOOo);
            }
        }
    }

    private void fireOOoAdded(IOOo iOOo) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            IConfigListener iConfigListener = this.mListeners.get(i);
            iConfigListener.ConfigAdded(iOOo);
        }
    }

    public static void delOOo(IOOo iOOo) {
        if (null == iOOo || !OOoContainer.sInstance.mElements.containsKey(iOOo.getName())) {
            return;
        }
        OOoContainer.sInstance.mElements.remove(iOOo.getName());
        sInstance.fireOOoRemoved(iOOo);
    }

    public static void clear() {
        OOoContainer.sInstance.mElements.clear();
        sInstance.fireOOoRemoved(null);
    }

    public static Vector<String> getOOoKeys() {
        Set<String> set = OOoContainer.sInstance.mElements.keySet();
        return new Vector<String>(set);
    }

    public static boolean containsName(String string) {
        return OOoContainer.sInstance.mElements.containsKey(string);
    }

    public static String getUniqueName(String string) {
        String string2 = string;
        if (OOoContainer.containsName(string2)) {
            Matcher matcher = Pattern.compile("(.*)#([0-9]+)$").matcher(string2);
            int n = 0;
            String string3 = new String(string2);
            if (matcher.matches()) {
                n = Integer.parseInt(matcher.group(2));
                string3 = matcher.group(1);
            }
            while (OOoContainer.containsName(string2 = string3 + " #" + ++n)) {
            }
        }
        return string2;
    }

    private void fireOOoRemoved(IOOo iOOo) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            IConfigListener iConfigListener = this.mListeners.get(i);
            iConfigListener.ConfigRemoved(iOOo);
        }
    }

    public static void updateOOo(String string, IOOo iOOo) {
        if (null == iOOo || !OOoContainer.sInstance.mElements.containsKey(string)) {
            return;
        }
        IOOo iOOo2 = OOoContainer.sInstance.mElements.get(string);
        try {
            iOOo2.setHome(iOOo.getHome());
        }
        catch (InvalidConfigException invalidConfigException) {
            PluginLogger.error(invalidConfigException.getLocalizedMessage(), invalidConfigException);
        }
        OOoContainer.sInstance.mElements.put(string, iOOo2);
        sInstance.fireOOoUpdated(iOOo);
    }

    private void fireOOoUpdated(IOOo iOOo) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            IConfigListener iConfigListener = this.mListeners.get(i);
            iConfigListener.ConfigUpdated(iOOo);
        }
    }

    public static IOOo getOOo(String string) {
        IOOo iOOo = null;
        if (OOoContainer.sInstance.mElements.containsKey(string)) {
            iOOo = OOoContainer.sInstance.mElements.get(string);
        }
        return iOOo;
    }

    public static IOOo getSomeOOo(String string) {
        IOOo iOOo = null;
        iOOo = OOoContainer.getOOo(string);
        if (iOOo == null) {
            iOOo = OOoContainer.getOOoFromPath(string);
        }
        if (iOOo == null) {
            try {
                iOOo = new OOo(string);
            }
            catch (Exception exception) {
                try {
                    iOOo = new URE(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (iOOo != null) {
                OOoContainer.addOOo(iOOo);
            }
        }
        if (iOOo == null && OOoContainer.sInstance.mElements.size() > 0) {
            iOOo = OOoContainer.sInstance.mElements.values().iterator().next();
        }
        return iOOo;
    }

    private static IOOo getOOoFromPath(String string) {
        IOOo iOOo = null;
        Iterator<IOOo> iterator = OOoContainer.sInstance.mElements.values().iterator();
        while (iterator.hasNext() && iOOo == null) {
            IOOo iOOo2 = iterator.next();
            if (!iOOo2.getHome().equals(string)) continue;
            iOOo = iOOo2;
        }
        return iOOo;
    }

    public static int getOOoCount() {
        return OOoContainer.sInstance.mElements.size();
    }

    public static void dispose() {
        OOoContainer.sInstance.mListeners.clear();
        OOoContainer.sInstance.mElements.clear();
    }

    public static void load() {
        IOOo[] iOOoArray = PropertiesManager.loadOOos();
        for (int i = 0; i < iOOoArray.length; ++i) {
            OOoContainer.addOOo(iOOoArray[i]);
        }
    }

    public static void saveOOos() {
        Vector<IOOo> vector = OOoContainer.toVector();
        IOOo[] iOOoArray = new IOOo[OOoContainer.getOOoCount()];
        int n = OOoContainer.getOOoCount();
        for (int i = 0; i < n; ++i) {
            iOOoArray[i] = vector.get(i);
        }
        vector.clear();
        PropertiesManager.saveOOos(iOOoArray);
    }

    public static OOoContainer getInstance() {
        if (sInstance == null) {
            sInstance = new OOoContainer();
        }
        return sInstance;
    }

    private static Vector<IOOo> toVector() {
        Vector<IOOo> vector = new Vector<IOOo>();
        Set<Map.Entry<String, IOOo>> set = OOoContainer.sInstance.mElements.entrySet();
        Iterator<Map.Entry<String, IOOo>> iterator = set.iterator();
        while (iterator.hasNext()) {
            IOOo iOOo = iterator.next().getValue();
            vector.add(iOOo);
        }
        return vector;
    }
}

