/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model;

import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.model.UnoidlProject;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.Messages;

public class ProjectsManager {
    private static Hashtable<String, IUnoidlProject> sProjects = new Hashtable();

    public static void dispose() {
        sProjects.clear();
    }

    public static IUnoidlProject getProject(String string) {
        IUnoidlProject iUnoidlProject = null;
        if (string != null && sProjects.containsKey(string)) {
            iUnoidlProject = sProjects.get(string);
        }
        return iUnoidlProject;
    }

    public static void addProject(IProject iProject) {
        try {
            if (iProject.isAccessible() && iProject.hasNature("org.libreoffice.ide.eclipse.core.unonature")) {
                UnoidlProject unoidlProject = (UnoidlProject)iProject.getNature("org.libreoffice.ide.eclipse.core.unonature");
                unoidlProject.configure();
                ProjectsManager.addProject(unoidlProject);
            }
        }
        catch (CoreException coreException) {
            PluginLogger.error(Messages.getString("ProjectsManager.LoadProjectError") + iProject.getName(), coreException);
        }
    }

    public static void addProject(IUnoidlProject iUnoidlProject) {
        if (iUnoidlProject != null && !sProjects.containsKey(iUnoidlProject.getName())) {
            sProjects.put(iUnoidlProject.getName(), iUnoidlProject);
        }
    }

    public static void removeProject(String string) {
        if (sProjects.containsKey(string)) {
            IUnoidlProject iUnoidlProject = sProjects.get(string);
            iUnoidlProject.dispose();
            sProjects.remove(string);
        }
    }

    public static IUnoidlProject[] getProjects() {
        IUnoidlProject[] iUnoidlProjectArray = new IUnoidlProject[sProjects.size()];
        return sProjects.values().toArray(iUnoidlProjectArray);
    }

    public static void load() {
        for (IProject iProject : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            ProjectsManager.addProject(iProject);
        }
    }
}

