/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.PropertiesManager;
import org.libreoffice.ide.eclipse.core.model.config.IConfigListener;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.config.InvalidConfigException;

public class SDKContainer {
    private static SDKContainer sInstance = new SDKContainer();
    private Vector<IConfigListener> mListeners;
    private HashMap<String, ISdk> mElements = new HashMap();

    private SDKContainer() {
        this.mListeners = new Vector();
    }

    public static void addListener(IConfigListener iConfigListener) {
        if (null != iConfigListener) {
            SDKContainer.sInstance.mListeners.add(iConfigListener);
        }
    }

    public static void removeListener(IConfigListener iConfigListener) {
        if (null != iConfigListener) {
            SDKContainer.sInstance.mListeners.remove(iConfigListener);
        }
    }

    public static Object[] toArray() {
        Vector<ISdk> vector = SDKContainer.toVector();
        Object[] objectArray = vector.toArray();
        vector.clear();
        return objectArray;
    }

    public static void addSDK(ISdk iSdk) {
        if (null != iSdk) {
            if (!SDKContainer.sInstance.mElements.containsKey(iSdk.getName())) {
                SDKContainer.sInstance.mElements.put(iSdk.getName(), iSdk);
                sInstance.fireSDKAdded(iSdk);
            } else {
                ISdk iSdk2 = SDKContainer.sInstance.mElements.get(iSdk.getName());
                SDKContainer.updateSDK(iSdk2.getName(), iSdk);
            }
        }
    }

    private void fireSDKAdded(ISdk iSdk) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            IConfigListener iConfigListener = this.mListeners.get(i);
            iConfigListener.ConfigAdded(iSdk);
        }
    }

    public static void delSDK(ISdk iSdk) {
        if (null != iSdk && SDKContainer.sInstance.mElements.containsKey(iSdk.getName())) {
            SDKContainer.sInstance.mElements.remove(iSdk.getName());
            sInstance.fireSDKRemoved(iSdk);
        }
    }

    public static void clear() {
        SDKContainer.sInstance.mElements.clear();
        sInstance.fireSDKRemoved(null);
    }

    public static Vector<String> getSDKKeys() {
        Set<String> set = SDKContainer.sInstance.mElements.keySet();
        return new Vector<String>(set);
    }

    public static boolean containsName(String string) {
        return SDKContainer.sInstance.mElements.containsKey(string);
    }

    private void fireSDKRemoved(ISdk iSdk) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            IConfigListener iConfigListener = this.mListeners.get(i);
            iConfigListener.ConfigRemoved(iSdk);
        }
    }

    public static void updateSDK(String string, ISdk iSdk) {
        if (SDKContainer.sInstance.mElements.containsKey(string) && null != iSdk) {
            ISdk iSdk2 = SDKContainer.sInstance.mElements.get(string);
            try {
                iSdk2.initialize(iSdk.getHome(), string);
            }
            catch (InvalidConfigException invalidConfigException) {
                PluginLogger.error(invalidConfigException.getLocalizedMessage(), invalidConfigException);
            }
            SDKContainer.sInstance.mElements.put(string, iSdk2);
            sInstance.fireSDKUpdated(iSdk);
        }
    }

    private void fireSDKUpdated(ISdk iSdk) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            IConfigListener iConfigListener = this.mListeners.get(i);
            iConfigListener.ConfigUpdated(iSdk);
        }
    }

    public static ISdk getSDK(String string) {
        ISdk iSdk = null;
        if (SDKContainer.sInstance.mElements.containsKey(string)) {
            iSdk = SDKContainer.sInstance.mElements.get(string);
        }
        return iSdk;
    }

    public static int getSDKCount() {
        return SDKContainer.sInstance.mElements.size();
    }

    public static void dispose() {
        SDKContainer.sInstance.mListeners.clear();
        SDKContainer.sInstance.mElements.clear();
    }

    public static SDKContainer getInstance() {
        if (null == sInstance) {
            sInstance = new SDKContainer();
        }
        return sInstance;
    }

    public static void load() {
        ISdk[] iSdkArray = PropertiesManager.loadSDKs();
        for (int i = 0; i < iSdkArray.length; ++i) {
            SDKContainer.addSDK(iSdkArray[i]);
        }
    }

    public static void saveSDKs() {
        Vector<ISdk> vector = SDKContainer.toVector();
        ISdk[] iSdkArray = vector.toArray(new ISdk[SDKContainer.getSDKCount()]);
        vector.clear();
        PropertiesManager.saveSDKs(iSdkArray);
    }

    private static Vector<ISdk> toVector() {
        Vector<ISdk> vector = new Vector<ISdk>();
        Set<Map.Entry<String, ISdk>> set = SDKContainer.sInstance.mElements.entrySet();
        Iterator<Map.Entry<String, ISdk>> iterator = set.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next().getValue());
        }
        return vector;
    }
}

