/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model.description;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.libreoffice.ide.eclipse.core.model.description.DescriptionModel;
import org.libreoffice.ide.eclipse.core.model.description.PublisherInfos;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptionHandler
extends DefaultHandler {
    private static final int LANG_GROUP = 1;
    private static final int COUNTRY_GROUP = 2;
    private final Pattern mLocalePattern = Pattern.compile("([a-z]{2})(?:-([A-Z]{2})(?:-[^-]*)?)?");
    private DescriptionModel mModel;
    private String mHandlerRemoveOn;
    private DefaultHandler mCurrentHandler;

    public DescriptionHandler(DescriptionModel descriptionModel) {
        this.mModel = descriptionModel;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.mCurrentHandler != null) {
            this.mCurrentHandler.startElement(string, string2, string3, attributes);
        } else {
            switch (string3) {
                case "version": {
                    this.mModel.setVersion(attributes.getValue("value"));
                    break;
                }
                case "identifier": {
                    this.mModel.setId(attributes.getValue("value"));
                    break;
                }
                case "platform": {
                    this.mModel.setPlatforms(attributes.getValue("value"));
                    break;
                }
                case "dependencies": {
                    this.mCurrentHandler = new DependenciesHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "update-information": {
                    this.mCurrentHandler = new UpdatesHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "registration": {
                    this.mCurrentHandler = new LicenseHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "publisher": {
                    this.mCurrentHandler = new PublisherHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "release-notes": {
                    this.mCurrentHandler = new ReleasesHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "display-name": {
                    this.mCurrentHandler = new NameHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "icon": {
                    this.mCurrentHandler = new IconHandler();
                    this.mHandlerRemoveOn = string3;
                    break;
                }
                case "extension-description": {
                    this.mCurrentHandler = new DescriptionsHandler();
                    this.mHandlerRemoveOn = string3;
                }
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        if (this.mCurrentHandler != null) {
            this.mCurrentHandler.characters(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (this.mCurrentHandler != null) {
            if (this.mHandlerRemoveOn.equals(string3)) {
                this.mCurrentHandler = null;
            } else {
                this.mCurrentHandler.endElement(string, string2, string3);
            }
        }
    }

    private Locale parseLocale(String string) {
        Matcher matcher;
        Locale locale = null;
        if (string != null && (matcher = this.mLocalePattern.matcher(string)).matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            locale = string3 != null ? new Locale(string2, string3) : new Locale(string2);
        }
        return locale;
    }

    private class DependenciesHandler
    extends DefaultHandler {
        private DependenciesHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("OpenOffice.org-minimal-version".equals(string3)) {
                DescriptionHandler.this.mModel.setMinOOo(attributes.getValue("value"));
            } else if ("OpenOffice.org-maximal-version".equals(string3)) {
                DescriptionHandler.this.mModel.setMaxOOo(attributes.getValue("value"));
            }
        }
    }

    private class UpdatesHandler
    extends DefaultHandler {
        private UpdatesHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("src".equals(string3)) {
                String string4 = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                DescriptionHandler.this.mModel.addUpdateInfo(string4);
            }
        }
    }

    private class LicenseHandler
    extends DefaultHandler {
        private LicenseHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("simple-license".equals(string3)) {
                String string4 = attributes.getValue("accept-by");
                if (string4 != null) {
                    DescriptionHandler.this.mModel.setAcceptByUser(string4.equals("user"));
                }
                if ((string4 = attributes.getValue("suppress-on-update")) == null) {
                    string4 = Boolean.FALSE.toString();
                }
                DescriptionHandler.this.mModel.setSuppressOnUpdate(Boolean.parseBoolean(string4));
            } else if ("license-text".equals(string3)) {
                String string5 = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                String string6 = attributes.getValue("lang");
                Locale locale = DescriptionHandler.this.parseLocale(string6);
                if (locale != null) {
                    DescriptionHandler.this.mModel.addLicense(locale, string5);
                }
            }
        }
    }

    private class PublisherHandler
    extends DefaultHandler {
        private String mRef;
        private Locale mLocale;
        private String mName;

        private PublisherHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("name".equals(string3)) {
                this.mRef = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                this.mLocale = DescriptionHandler.this.parseLocale(attributes.getValue("lang"));
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            super.characters(cArray, n, n2);
            this.mName = new String(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if ("name".equals(string3) && this.mLocale != null) {
                PublisherInfos publisherInfos = new PublisherInfos();
                publisherInfos.setModel(DescriptionHandler.this.mModel);
                publisherInfos.setName(this.mName);
                publisherInfos.setUrl(this.mRef);
                DescriptionHandler.this.mModel.addPublisherInfo(this.mLocale, publisherInfos);
                this.mName = null;
                this.mLocale = null;
                this.mRef = null;
            }
        }
    }

    private class ReleasesHandler
    extends DefaultHandler {
        private ReleasesHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("src".equals(string3)) {
                String string4 = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                Locale locale = DescriptionHandler.this.parseLocale(attributes.getValue("lang"));
                if (locale != null) {
                    DescriptionHandler.this.mModel.addReleaseNote(locale, string4);
                }
            }
        }
    }

    private class NameHandler
    extends DefaultHandler {
        private Locale mLocale;
        private String mName;

        private NameHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("name".equals(string3)) {
                this.mLocale = DescriptionHandler.this.parseLocale(attributes.getValue("lang"));
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            super.characters(cArray, n, n2);
            this.mName = new String(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if ("name".equals(string3) && this.mLocale != null) {
                DescriptionHandler.this.mModel.getDisplayNames().put(this.mLocale, this.mName);
                this.mName = null;
                this.mLocale = null;
            }
        }
    }

    private class IconHandler
    extends DefaultHandler {
        private IconHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            String string4 = attributes.getValue("http://www.w3.org/1999/xlink", "href");
            if ("default".equals(string3)) {
                DescriptionHandler.this.mModel.setDefaultIcon(string4);
            } else if ("high-contrast".equals(string3)) {
                DescriptionHandler.this.mModel.setHCIcon(string4);
            }
        }
    }

    private class DescriptionsHandler
    extends DefaultHandler {
        private DescriptionsHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            if ("src".equals(string3)) {
                String string4 = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                Locale locale = DescriptionHandler.this.parseLocale(attributes.getValue("lang"));
                if (locale != null) {
                    DescriptionHandler.this.mModel.addDescription(locale, string4);
                }
            }
        }
    }
}

