/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model.description;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.libreoffice.ide.eclipse.core.model.description.PublisherInfos;
import org.libreoffice.ide.eclipse.core.model.description.XMLTokens;
import org.libreoffice.ide.eclipse.core.model.utils.IModel;
import org.libreoffice.ide.eclipse.core.model.utils.IModelDataListener;
import org.libreoffice.plugin.core.utils.XMLWriter;

public class DescriptionModel
implements IModel {
    private ArrayList<IModelDataListener> mListeners;
    private boolean mDirty;
    private boolean mSuspendEvents;
    private String mId = new String();
    private String mVersion = new String();
    private Map<Locale, String> mDisplayNames;
    private String mMinOOo = new String();
    private String mMaxOOo = new String();
    private String mPlatforms = new String();
    private String mDefaultIcon = new String();
    private String mHCIcon = new String();
    private Map<Locale, String> mDescriptions;
    private Map<Locale, String> mReleaseNotes;
    private ArrayList<String> mUpdateInfos;
    private boolean mAcceptByUser = false;
    private boolean mSuppressOnUpdate = false;
    private Map<Locale, String> mLicenses;
    private Map<Locale, PublisherInfos> mPublisherInfos;

    public DescriptionModel() {
        this.mListeners = new ArrayList();
        this.mDisplayNames = new HashMap<Locale, String>();
        this.mDescriptions = new HashMap<Locale, String>();
        this.mReleaseNotes = new HashMap<Locale, String>();
        this.mUpdateInfos = new ArrayList();
        this.mLicenses = new HashMap<Locale, String>();
        this.mPublisherInfos = new HashMap<Locale, PublisherInfos>();
    }

    @Override
    public void addListener(IModelDataListener iModelDataListener) {
        this.mListeners.add(iModelDataListener);
    }

    @Override
    public void removeListener(IModelDataListener iModelDataListener) {
        this.mListeners.remove(iModelDataListener);
    }

    @Override
    public boolean isDirty() {
        return this.mDirty;
    }

    @Override
    public void setSuspendEvent(boolean bl) {
        this.mSuspendEvents = bl;
    }

    public ArrayList<Locale> getAllLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        this.appendNew(arrayList, this.mDisplayNames.keySet());
        this.appendNew(arrayList, this.mDescriptions.keySet());
        this.appendNew(arrayList, this.mReleaseNotes.keySet());
        this.appendNew(arrayList, this.mLicenses.keySet());
        this.appendNew(arrayList, this.mPublisherInfos.keySet());
        return arrayList;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String string) {
        if (this.mId != string) {
            this.mId = string;
            this.fireModelChanged();
        }
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String string) {
        if (this.mVersion != string) {
            this.mVersion = string;
            this.fireModelChanged();
        }
    }

    public Map<Locale, String> getDisplayNames() {
        if (this.mDisplayNames == null) {
            this.mDisplayNames = new HashMap<Locale, String>();
        }
        return this.mDisplayNames;
    }

    public void addDisplayName(Locale locale, String string) {
        if (this.getDisplayNames().containsKey(locale) && !this.getDisplayNames().get(locale).equals(string) || !this.getDisplayNames().containsKey(locale)) {
            this.getDisplayNames().put(locale, string);
            this.fireModelChanged();
        }
    }

    public void removeDisplayName(Locale locale) {
        if (this.getDisplayNames().containsKey(locale)) {
            this.getDisplayNames().remove(locale);
            this.fireModelChanged();
        }
    }

    public String getMinOOo() {
        return this.mMinOOo;
    }

    public void setMinOOo(String string) {
        if (this.mMinOOo != string) {
            this.mMinOOo = string;
            this.fireModelChanged();
        }
    }

    public String getMaxOOo() {
        return this.mMaxOOo;
    }

    public void setMaxOOo(String string) {
        if (this.mMaxOOo != string) {
            this.mMaxOOo = string;
            this.fireModelChanged();
        }
    }

    public String getPlatforms() {
        return this.mPlatforms;
    }

    public void setPlatforms(String string) {
        if (this.mPlatforms != string) {
            this.mPlatforms = string;
            this.fireModelChanged();
        }
    }

    public String getDefaultIcon() {
        return this.mDefaultIcon;
    }

    public void setDefaultIcon(String string) {
        if (this.mDefaultIcon != string) {
            this.mDefaultIcon = string;
            this.fireModelChanged();
        }
    }

    public String getHCIcon() {
        return this.mHCIcon;
    }

    public void setHCIcon(String string) {
        if (this.mHCIcon != string) {
            this.mHCIcon = string;
            this.fireModelChanged();
        }
    }

    public Map<Locale, String> getDescriptions() {
        if (this.mDescriptions == null) {
            this.mDescriptions = new HashMap<Locale, String>();
        }
        return this.mDescriptions;
    }

    public void addDescription(Locale locale, String string) {
        if (this.getDescriptions().containsKey(locale) && !this.getDescriptions().get(locale).equals(string) || !this.getDescriptions().containsKey(locale)) {
            this.getDescriptions().put(locale, string);
            this.fireModelChanged();
        }
    }

    public void removeDescription(Locale locale) {
        if (this.getDescriptions().containsKey(locale)) {
            this.getDescriptions().remove(locale);
            this.fireModelChanged();
        }
    }

    public Map<Locale, String> getReleaseNotes() {
        if (this.mReleaseNotes == null) {
            this.mReleaseNotes = new HashMap<Locale, String>();
        }
        return this.mReleaseNotes;
    }

    public void addReleaseNote(Locale locale, String string) {
        if (this.getReleaseNotes().containsKey(locale) && !this.getReleaseNotes().get(locale).equals(string) || !this.getReleaseNotes().containsKey(locale)) {
            this.getReleaseNotes().put(locale, string);
            this.fireModelChanged();
        }
    }

    public void removeReleaseNote(Locale locale) {
        if (this.getReleaseNotes().containsKey(locale)) {
            this.getReleaseNotes().remove(locale);
            this.fireModelChanged();
        }
    }

    public ArrayList<String> getUpdateInfos() {
        if (this.mUpdateInfos == null) {
            this.mUpdateInfos = new ArrayList();
        }
        return this.mUpdateInfos;
    }

    public void addUpdateInfo(String string) {
        if (!this.getUpdateInfos().contains(string)) {
            this.getUpdateInfos().add(string);
            this.fireModelChanged();
        }
    }

    public void replaceUpdateInfo(int n, String string) {
        String string2 = this.getUpdateInfos().get(n);
        if (string2 != null && !string2.equals(string)) {
            this.getUpdateInfos().set(n, string);
            this.fireModelChanged();
        }
    }

    public void removeUpdateInfo(String string) {
        if (this.getUpdateInfos().contains(string)) {
            this.getUpdateInfos().remove(string);
            this.fireModelChanged();
        }
    }

    public boolean isAcceptByUser() {
        return this.mAcceptByUser;
    }

    public void setAcceptByUser(boolean bl) {
        if (this.mAcceptByUser != bl) {
            this.mAcceptByUser = bl;
            this.fireModelChanged();
        }
    }

    public boolean isSuppressOnUpdate() {
        return this.mSuppressOnUpdate;
    }

    public void setSuppressOnUpdate(boolean bl) {
        if (this.mSuppressOnUpdate != bl) {
            this.mSuppressOnUpdate = bl;
            this.fireModelChanged();
        }
    }

    public Map<Locale, String> getLicenses() {
        if (this.mLicenses == null) {
            this.mLicenses = new HashMap<Locale, String>();
        }
        return this.mLicenses;
    }

    public void addLicense(Locale locale, String string) {
        if (this.getLicenses().containsKey(locale) && !this.getLicenses().get(locale).equals(string) || !this.getLicenses().containsKey(locale)) {
            this.getLicenses().put(locale, string);
            this.fireModelChanged();
        }
    }

    public void removeLicense(Locale locale) {
        if (this.getLicenses().containsKey(locale)) {
            this.getLicenses().remove(locale);
            this.fireModelChanged();
        }
    }

    public Map<Locale, PublisherInfos> getPublisherInfos() {
        if (this.mPublisherInfos == null) {
            this.mPublisherInfos = new HashMap<Locale, PublisherInfos>();
        }
        return this.mPublisherInfos;
    }

    public void addPublisherInfo(Locale locale, PublisherInfos publisherInfos) {
        if (this.getPublisherInfos().containsKey(locale) && !this.getPublisherInfos().get(locale).equals(publisherInfos) || !this.getPublisherInfos().containsKey(locale)) {
            publisherInfos.setModel(this);
            this.getPublisherInfos().put(locale, publisherInfos);
            this.fireModelChanged();
        }
    }

    public void removePublisherInfo(Locale locale) {
        if (this.getLicenses().containsKey(locale)) {
            this.getPublisherInfos().remove(locale);
            this.fireModelChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream outputStream) {
        try (PrintWriter printWriter = null;){
            printWriter = new XMLWriter(outputStream);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("xmlns", "http://openoffice.org/extensions/description/2006");
            hashMap.put(XMLTokens.createQName("xmlns", "d"), "http://openoffice.org/extensions/description/2006");
            hashMap.put(XMLTokens.createQName("xmlns", "xlink"), "http://www.w3.org/1999/xlink");
            ((XMLWriter)printWriter).startTag("description", hashMap);
            if (this.mVersion != null && !"".equals(this.mVersion)) {
                this.printValueElement((XMLWriter)printWriter, "version", this.mVersion);
            }
            this.printValueElement((XMLWriter)printWriter, "identifier", this.mId);
            if (this.mPlatforms != null && !"".equals(this.mPlatforms)) {
                this.printValueElement((XMLWriter)printWriter, "platform", this.mPlatforms);
            }
            this.writeDependencies((XMLWriter)printWriter);
            this.writeUpdateInfos((XMLWriter)printWriter);
            this.writeLicenses((XMLWriter)printWriter);
            this.writePublisherInfos((XMLWriter)printWriter);
            this.writeReleaseNotes((XMLWriter)printWriter);
            this.writeDisplayNames((XMLWriter)printWriter);
            this.writeIcons((XMLWriter)printWriter);
            this.writeDescriptions((XMLWriter)printWriter);
            ((XMLWriter)printWriter).endTag("description");
        }
        this.fireModelSaved();
    }

    private void writeDependencies(XMLWriter xMLWriter) {
        boolean bl;
        boolean bl2 = 0 != this.mMinOOo.trim().length();
        boolean bl3 = bl = 0 != this.mMaxOOo.trim().length();
        if (bl2 || bl) {
            HashMap<String, String> hashMap;
            xMLWriter.startTag("dependencies", null);
            if (bl2) {
                hashMap = new HashMap<String, String>();
                hashMap.put("value", this.mMinOOo.trim());
                hashMap.put(XMLTokens.createQName("d", "name"), this.mMinOOo.trim());
                xMLWriter.printSingleTag("OpenOffice.org-minimal-version", hashMap);
            }
            if (bl) {
                hashMap = new HashMap();
                hashMap.put("value", this.mMaxOOo.trim());
                hashMap.put(XMLTokens.createQName("d", "name"), this.mMaxOOo.trim());
                xMLWriter.printSingleTag("OpenOffice.org-maximal-version", hashMap);
            }
            xMLWriter.endTag("dependencies");
        }
    }

    private void writeUpdateInfos(XMLWriter xMLWriter) {
        if (this.mUpdateInfos.size() > 0) {
            xMLWriter.startTag("update-information", null);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : this.mUpdateInfos) {
                hashMap.clear();
                hashMap.put(XMLTokens.createQName("xlink", "href"), string.trim());
                xMLWriter.printSingleTag("src", hashMap);
            }
            xMLWriter.endTag("update-information");
        }
    }

    private void writeLicenses(XMLWriter xMLWriter) {
        boolean bl;
        Object object;
        Iterator<String> iterator = this.mLicenses.values().iterator();
        for (bl = false; !bl && iterator.hasNext(); bl |= 0 != ((String)(object = iterator.next())).trim().length()) {
        }
        if (bl) {
            xMLWriter.startTag("registration", null);
            object = new HashMap();
            String string = "admin";
            if (this.mAcceptByUser) {
                string = "user";
            }
            object.put("accept-by", string);
            if (this.mSuppressOnUpdate) {
                object.put("suppress-on-update", Boolean.toString(this.mSuppressOnUpdate));
            }
            xMLWriter.startTag("simple-license", (Map<String, ? extends Object>)object);
            for (Map.Entry<Locale, String> entry : this.mLicenses.entrySet()) {
                String string2 = this.writeLocale(entry.getKey());
                object.clear();
                object.put(XMLTokens.createQName("xlink", "href"), entry.getValue().trim());
                object.put("lang", string2);
                xMLWriter.printSingleTag("license-text", (Map<String, ? extends Object>)object);
            }
            xMLWriter.endTag("simple-license");
            xMLWriter.endTag("registration");
        }
    }

    private void writePublisherInfos(XMLWriter xMLWriter) {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        Iterator<PublisherInfos> iterator = this.mPublisherInfos.values().iterator();
        for (bl = false; !bl && iterator.hasNext(); bl |= bl3 && bl2) {
            object = iterator.next();
            bl3 = 0 != ((PublisherInfos)object).getName().length();
            bl2 = 0 != ((PublisherInfos)object).getUrl().length();
        }
        if (bl) {
            xMLWriter.startTag("publisher", null);
            object = new HashMap();
            for (Map.Entry<Locale, PublisherInfos> entry : this.mPublisherInfos.entrySet()) {
                String string = this.writeLocale(entry.getKey());
                object.clear();
                PublisherInfos publisherInfos = entry.getValue();
                boolean bl4 = 0 != publisherInfos.getName().length();
                boolean bl5 = 0 != publisherInfos.getUrl().length();
                object.put(XMLTokens.createQName("xlink", "href"), publisherInfos.getUrl());
                object.put("lang", string);
                if (!bl4 || !bl5) continue;
                xMLWriter.startTag("name", (Map<String, ? extends Object>)object, false);
                xMLWriter.print(XMLWriter.getEscaped(publisherInfos.getName().trim()));
                xMLWriter.endTag("name", false);
            }
            xMLWriter.endTag("publisher");
        }
    }

    private void writeReleaseNotes(XMLWriter xMLWriter) {
        boolean bl;
        Object object;
        Iterator<String> iterator = this.mReleaseNotes.values().iterator();
        for (bl = false; !bl && iterator.hasNext(); bl |= 0 != ((String)(object = iterator.next())).trim().length()) {
        }
        if (bl) {
            xMLWriter.startTag("release-notes", null);
            object = new HashMap();
            for (Map.Entry<Locale, String> entry : this.mReleaseNotes.entrySet()) {
                String string = this.writeLocale(entry.getKey());
                object.clear();
                object.put(XMLTokens.createQName("xlink", "href"), entry.getValue().trim());
                object.put("lang", string);
                xMLWriter.printSingleTag("src", (Map<String, ? extends Object>)object);
            }
            xMLWriter.endTag("release-notes");
        }
    }

    private void writeDisplayNames(XMLWriter xMLWriter) {
        boolean bl;
        Object object;
        Iterator<String> iterator = this.mDisplayNames.values().iterator();
        for (bl = false; !bl && iterator.hasNext(); bl |= 0 != ((String)(object = iterator.next())).trim().length()) {
        }
        if (bl) {
            xMLWriter.startTag("display-name", null);
            object = new HashMap();
            for (Map.Entry<Locale, String> entry : this.mDisplayNames.entrySet()) {
                String string = this.writeLocale(entry.getKey());
                object.clear();
                object.put("lang", string);
                xMLWriter.startTag("name", (Map<String, ? extends Object>)object, false);
                xMLWriter.print(XMLWriter.getEscaped(entry.getValue().trim()));
                xMLWriter.endTag("name", false);
            }
            xMLWriter.endTag("display-name");
        }
    }

    private void writeIcons(XMLWriter xMLWriter) {
        boolean bl;
        boolean bl2 = 0 != this.mDefaultIcon.trim().length();
        boolean bl3 = bl = 0 != this.mHCIcon.trim().length();
        if (bl2 || bl) {
            xMLWriter.startTag("icon", null);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl2) {
                hashMap.put(XMLTokens.createQName("xlink", "href"), this.mDefaultIcon.trim());
                xMLWriter.printSingleTag("default", hashMap);
            }
            if (bl) {
                hashMap.clear();
                hashMap.put(XMLTokens.createQName("xlink", "href"), this.mHCIcon.trim());
                xMLWriter.printSingleTag("high-contrast", hashMap);
            }
            xMLWriter.endTag("icon");
        }
    }

    private void writeDescriptions(XMLWriter xMLWriter) {
        boolean bl;
        Object object;
        Iterator<String> iterator = this.mDescriptions.values().iterator();
        for (bl = false; !bl && iterator.hasNext(); bl |= 0 != ((String)(object = iterator.next())).trim().length()) {
        }
        if (bl) {
            xMLWriter.startTag("extension-description", null);
            object = new HashMap();
            for (Map.Entry<Locale, String> entry : this.mDescriptions.entrySet()) {
                String string = this.writeLocale(entry.getKey());
                object.clear();
                object.put(XMLTokens.createQName("xlink", "href"), entry.getValue().trim());
                object.put("lang", string);
                xMLWriter.printSingleTag("src", (Map<String, ? extends Object>)object);
            }
            xMLWriter.endTag("extension-description");
        }
    }

    private String writeLocale(Locale locale) {
        char c = '-';
        String string = new String();
        string = locale.toString().replace('_', c);
        return string;
    }

    private void printValueElement(XMLWriter xMLWriter, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("value", string2);
        xMLWriter.printSingleTag(string, hashMap);
    }

    private void appendNew(ArrayList<Locale> arrayList, Set<Locale> set) {
        for (Locale locale : set) {
            if (arrayList.contains(locale)) continue;
            arrayList.add(locale);
        }
    }

    protected void fireModelChanged() {
        if (!this.mSuspendEvents) {
            this.mDirty = true;
            for (IModelDataListener iModelDataListener : this.mListeners) {
                iModelDataListener.modelChanged();
            }
        }
    }

    protected void fireModelSaved() {
        if (!this.mSuspendEvents) {
            this.mDirty = false;
            for (IModelDataListener iModelDataListener : this.mListeners) {
                iModelDataListener.modelSaved();
            }
        }
    }
}

