/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model.pack;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.Messages;
import org.libreoffice.ide.eclipse.core.model.utils.IModelDataListener;
import org.libreoffice.ide.eclipse.core.model.utils.IModelTreeListener;

public class PackagePropertiesModel {
    private static final String CONTENTS = "contents";
    private static final String BASICLIBS = "basicLibs";
    private static final String DIALOGLIBS = "dialogLibs";
    private static final String DESCRIPTION = "description";
    private static final String SEPARATOR = ", ";
    private IFile mPropertiesFile;
    private Properties mProperties = new Properties();
    private List<IResource> mFiles = null;
    private Map<IResource, Boolean> mFolders = null;
    private short mDirty = 0;
    private boolean mIsQuiet = false;
    private boolean mIsModified = false;
    private Vector<IModelDataListener> mDataListeners = new Vector();
    private Vector<IModelTreeListener> mTreeListeners = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackagePropertiesModel(IFile iFile) throws IllegalArgumentException {
        Object object;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(iFile.getLocation().toFile());
            this.mPropertiesFile = iFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.mPropertiesFile = null;
            String string = Messages.getString("PackagePropertiesModel.NullFileException");
            throw new IllegalArgumentException(string);
        }
        try {
            this.mProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            object = Messages.getString("PackagePropertiesModel.FileReadException");
            PluginLogger.warning((String)object + iFile.getLocation());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        object = new HashMap();
        this.mFiles = this.deserializeContent((Map<IResource, Boolean>)object, hashMap);
        this.mFolders = this.getFolderCheckState((Map<IResource, Boolean>)object);
        if (!hashMap.isEmpty()) {
            this.logMissingPaths(hashMap, true);
            this.logMissingPaths(hashMap, false);
            this.firePackageChanged();
            this.mDirty = (short)2;
        }
    }

    public void setQuiet(boolean bl) {
        this.mIsQuiet = bl;
    }

    public void setModified(boolean bl) {
        this.mIsModified = bl;
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public boolean isFilteredResource(IResource iResource) {
        boolean bl = false;
        if (iResource.getName().startsWith(".") || iResource.getName().equals("bin") || iResource.getName().equals("build")) {
            bl = true;
        } else if (this.getBasicLibraries().contains(iResource) || this.getDialogLibraries().contains(iResource) || this.getDescriptionFiles().containsValue(iResource)) {
            bl = true;
        }
        return bl;
    }

    public boolean isDirty() {
        return this.mDirty != 0;
    }

    public void addDataListener(IModelDataListener iModelDataListener) {
        this.mDataListeners.add(iModelDataListener);
    }

    public void removeDataListener(IModelDataListener iModelDataListener) {
        if (this.mDataListeners.contains(iModelDataListener)) {
            this.mDataListeners.remove(iModelDataListener);
        }
    }

    public void addTreeListener(IModelTreeListener iModelTreeListener) {
        this.mTreeListeners.add(iModelTreeListener);
    }

    public void removeTreeListener(IModelTreeListener iModelTreeListener) {
        if (this.mTreeListeners.contains(iModelTreeListener)) {
            this.mTreeListeners.remove(iModelTreeListener);
        }
    }

    public void firePackageSaved() {
        if (!this.mIsQuiet) {
            this.mDirty = 0;
            for (IModelDataListener iModelDataListener : this.mDataListeners) {
                iModelDataListener.modelSaved();
            }
        }
    }

    public void firePackageChanged() {
        if (!this.mIsQuiet) {
            this.mDirty = 1;
            for (IModelDataListener iModelDataListener : this.mDataListeners) {
                iModelDataListener.modelChanged();
            }
        }
    }

    public void fireTreeRefresh() {
        this.mDirty = (short)2;
        for (IModelTreeListener iModelTreeListener : this.mTreeListeners) {
            iModelTreeListener.modelRefreshed();
        }
    }

    public boolean write() throws Exception {
        boolean bl = this.hasPendingChanges();
        if (bl) {
            this.mProperties.setProperty(CONTENTS, this.serializeContent());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.mPropertiesFile.getLocation().toFile());
        try {
            this.mProperties.store(fileOutputStream, Messages.getString("PackagePropertiesModel.Comment"));
            this.firePackageSaved();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public void reloadFromString(String string) {
        if (!string.equals(this.writeToString())) {
            this.mProperties.clear();
            try {
                this.mProperties.load(new StringReader(string));
            }
            catch (IOException iOException) {
                return;
            }
            HashMap<IResource, Boolean> hashMap = new HashMap<IResource, Boolean>();
            this.mFiles.clear();
            this.mFiles.addAll(this.deserializeContent(hashMap, null));
            this.mFolders.clear();
            this.mFolders.putAll(this.getFolderCheckState(hashMap));
        }
    }

    public String writeToString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.mProperties.store(stringWriter, Messages.getString("PackagePropertiesModel.Comment"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)stringWriter).toString();
    }

    public void addBasicLibrary(IFolder iFolder) throws IllegalArgumentException {
        String string = this.mProperties.getProperty(BASICLIBS);
        if (string == null) {
            string = "";
        }
        try {
            if (!string.equals("")) {
                string = string + SEPARATOR;
            }
            string = string + iFolder.getProjectRelativePath().toString();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        this.mProperties.setProperty(BASICLIBS, string);
        this.firePackageChanged();
    }

    public void addDialogLibrary(IFolder iFolder) throws IllegalArgumentException {
        String string = this.mProperties.getProperty(DIALOGLIBS);
        if (string == null) {
            string = "";
        }
        try {
            if (!string.equals("")) {
                string = string + SEPARATOR;
            }
            string = string + iFolder.getProjectRelativePath().toString();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        this.mProperties.setProperty(DIALOGLIBS, string);
        this.firePackageChanged();
    }

    public List<IFolder> getDialogLibraries() {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        try {
            String string = this.mProperties.getProperty(DIALOGLIBS);
            IProject iProject = this.mPropertiesFile.getProject();
            if (string != null && !string.equals("")) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(SEPARATOR)) {
                    arrayList.add(iProject.getFolder(string2));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return arrayList;
    }

    public List<IFolder> getBasicLibraries() {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        try {
            String string = this.mProperties.getProperty(BASICLIBS);
            IProject iProject = this.mPropertiesFile.getProject();
            if (string != null && !string.equals("")) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(SEPARATOR)) {
                    arrayList.add(iProject.getFolder(string2));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return arrayList;
    }

    public void clearBasicLibraries() {
        this.mProperties.setProperty(BASICLIBS, "");
        this.firePackageChanged();
    }

    public void clearDialogLibraries() {
        this.mProperties.setProperty(DIALOGLIBS, "");
        this.firePackageChanged();
    }

    public void addResource(IResource iResource) {
        try {
            if (iResource.getType() == 2) {
                this.addFolderResource(iResource);
            } else if (iResource.getType() == 1) {
                this.addFileResource(iResource);
            }
            this.mProperties.setProperty(CONTENTS, this.serializeContent());
            this.mIsModified = true;
            this.firePackageChanged();
            this.mIsModified = false;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void removeResource(IResource iResource) {
        try {
            if (iResource.getType() == 2) {
                this.removeFolderResource(iResource);
            } else if (iResource.getType() == 1) {
                this.removeFileResource(iResource);
            }
            this.mProperties.setProperty(CONTENTS, this.serializeContent());
            this.mIsModified = true;
            this.firePackageChanged();
            this.mIsModified = false;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public boolean isChecked(IResource iResource) {
        boolean bl = false;
        if (iResource.getType() == 1) {
            bl = this.mFiles.contains(iResource);
        } else if (iResource.getType() == 2) {
            bl = this.mFolders.containsKey(iResource);
        }
        return bl;
    }

    public boolean isGrayed(IResource iResource) {
        boolean bl = false;
        if (iResource.getType() == 2) {
            bl = this.mFolders.getOrDefault(iResource, false);
        }
        return bl;
    }

    public List<IResource> getContents() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        arrayList.addAll(this.mFiles);
        try {
            for (Map.Entry<IResource, Boolean> entry : this.mFolders.entrySet()) {
                IResource iResource;
                if (entry.getValue().booleanValue() || this.hasVisibleMembers(iResource = entry.getKey())) continue;
                arrayList.add(iResource);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return arrayList;
    }

    public void clearContents() {
        this.mProperties.setProperty(CONTENTS, "");
        this.mFiles.clear();
        this.mFolders.clear();
        this.firePackageChanged();
    }

    public void addDescriptionFile(IFile iFile, Locale locale) throws IllegalArgumentException {
        if (locale == null) {
            String string = Messages.getString("PackagePropertiesModel.NoLocaleException");
            throw new IllegalArgumentException(string);
        }
        if (iFile == null || !iFile.exists()) {
            String string = Messages.getString("PackagePropertiesModel.NoDescriptionFileException");
            throw new IllegalArgumentException(string);
        }
        String string = "";
        if (locale.getCountry() != "") {
            string = "_" + locale.getCountry();
        }
        String string2 = "description-" + locale.getLanguage() + string;
        this.mProperties.setProperty(string2, iFile.getProjectRelativePath().toString());
        this.firePackageChanged();
    }

    public Map<Locale, IFile> getDescriptionFiles() {
        HashMap<Locale, IFile> hashMap = new HashMap<Locale, IFile>();
        IProject iProject = this.mPropertiesFile.getProject();
        for (String string : this.mProperties.keySet()) {
            IFile iFile;
            String string2 = "description-([a-zA-Z]{2})(?:_([a-zA-Z]{2}))?";
            Matcher matcher = Pattern.compile(string2).matcher(string);
            if (!matcher.matches()) continue;
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            Locale locale = new Locale(string3);
            if (string4 != null) {
                locale = new Locale(string3, string4);
            }
            if ((iFile = iProject.getFile(this.mProperties.getProperty(string))) == null) continue;
            hashMap.put(locale, iFile);
        }
        return hashMap;
    }

    public void clearDescriptions() {
        int n = 0;
        for (String string : ((Properties)this.mProperties.clone()).keySet()) {
            String string2 = "description-([a-zA-Z]{2})(?:_([a-zA-Z]{2}))?";
            Matcher matcher = Pattern.compile(string2).matcher(string);
            if (!matcher.matches()) continue;
            this.mProperties.remove(string);
            ++n;
        }
        if (n > 0) {
            this.firePackageChanged();
        }
    }

    private boolean hasPendingChanges() {
        return this.mDirty == 2;
    }

    private void addFolderResource(IResource iResource) throws CoreException {
        IResource[] iResourceArray;
        this.mFolders.put(iResource, false);
        for (IResource iResource2 : iResourceArray = ((IContainer)iResource).members()) {
            if (this.isFilteredResource(iResource2)) continue;
            if (iResource2.getType() == 2) {
                this.addFolderResource(iResource2);
                continue;
            }
            if (this.mFiles.contains(iResource2)) continue;
            this.mFiles.add(iResource2);
        }
    }

    private void removeFolderResource(IResource iResource) throws CoreException {
        IResource[] iResourceArray;
        if (this.mFolders.containsKey(iResource)) {
            this.mFolders.remove(iResource);
        }
        for (IResource iResource2 : iResourceArray = ((IContainer)iResource).members()) {
            if (iResource2.getType() == 2) {
                this.removeFolderResource(iResource2);
                continue;
            }
            if (!this.mFiles.contains(iResource2)) continue;
            this.mFiles.remove(iResource2);
        }
    }

    private void addFileResource(IResource iResource) throws CoreException {
        if (!this.mFiles.contains(iResource)) {
            this.mFiles.add(iResource);
        }
        this.setFileCheckState(iResource);
    }

    private void removeFileResource(IResource iResource) throws CoreException {
        if (this.mFiles.contains(iResource)) {
            this.mFiles.remove(iResource);
        }
        this.setFileCheckState(iResource);
    }

    private String serializeContent() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        try {
            for (IResource object : this.mFiles) {
                if (object.getType() != 1 || !object.exists()) continue;
                arrayList.add(object.getProjectRelativePath().toString());
                ++n;
            }
            for (Map.Entry<IResource, Boolean> entry : this.mFolders.entrySet()) {
                n2 += this.serializeFolder(arrayList, entry);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        Iterator<Map.Entry<IResource, Boolean>> iterator = Messages.getString("PackagePropertiesModel.SerializeContent");
        PluginLogger.info(String.format(iterator, new Object[]{n, n2}));
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return String.join((CharSequence)SEPARATOR, arrayList);
    }

    private int serializeFolder(List<String> list, Map.Entry<IResource, Boolean> entry) throws CoreException {
        int n = 0;
        IResource iResource = entry.getKey();
        if (iResource.getType() == 2 && iResource.exists() && !this.isFilteredResource(iResource) && !entry.getValue().booleanValue() && !this.hasVisibleMembers(iResource)) {
            list.add(iResource.getProjectRelativePath().toString());
            ++n;
        }
        return n;
    }

    private List<IResource> deserializeContent(Map<IResource, Boolean> map, Map<String, Boolean> map2) {
        String string;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        IProject iProject = this.mPropertiesFile.getProject();
        int n = 0;
        int n2 = 0;
        try {
            string = this.mProperties.getProperty(CONTENTS);
            if (string != null && !string.equals("")) {
                for (String string2 : string.split(SEPARATOR)) {
                    if (iProject.getFile(string2).exists()) {
                        IFile iFile = iProject.getFile(string2);
                        if (arrayList.contains(iFile)) continue;
                        arrayList.add((IResource)iFile);
                        ++n;
                        continue;
                    }
                    if (iProject.getFolder(string2).exists()) {
                        n2 += this.deserializeFolder(iProject, map, map2, string2);
                        continue;
                    }
                    if (map2 == null) continue;
                    map2.put(string2, true);
                }
            }
        }
        catch (NullPointerException | CoreException throwable) {
            // empty catch block
        }
        string = Messages.getString("PackagePropertiesModel.DeserializeContent");
        PluginLogger.info(String.format(string, n, n2));
        return arrayList;
    }

    private int deserializeFolder(IProject iProject, Map<IResource, Boolean> map, Map<String, Boolean> map2, String string) throws CoreException {
        int n = 0;
        IFolder iFolder = iProject.getFolder(string);
        if (!this.hasVisibleMembers((IResource)iFolder)) {
            map.put((IResource)iFolder, false);
            ++n;
        } else if (map2 != null) {
            map2.put(string, false);
        }
        return n;
    }

    private Map<IResource, Boolean> getFolderCheckState(Map<IResource, Boolean> map) {
        try {
            IProject iProject = this.mPropertiesFile.getProject();
            this.setFolderCheckState(map, (IContainer)iProject);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return map;
    }

    private void setFolderCheckState(Map<IResource, Boolean> map, IContainer iContainer) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        for (IResource iResource : iResourceArray) {
            if (this.isFilteredResource(iResource)) continue;
            ++n;
            if (iResource.getType() == 1) {
                if (this.mFiles.contains(iResource)) {
                    bl2 = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (iResource.getType() != 2) continue;
            this.setFolderCheckState(map, (IContainer)iResource);
            if (!map.containsKey(iResource)) {
                bl = false;
                continue;
            }
            if (!map.get(iResource).booleanValue()) continue;
            bl2 = true;
        }
        if (this.isCheckStateSetable(map, iContainer)) {
            if (n == 0) {
                bl = false;
            }
            this.setCheckState(map, (IResource)iContainer, bl, bl2);
        }
    }

    private boolean isCheckStateSetable(Map<IResource, Boolean> map, IContainer iContainer) {
        return iContainer.getType() != 4 && !map.containsKey(iContainer);
    }

    private void setFileCheckState(IResource iResource) throws CoreException {
        IContainer iContainer = iResource.getParent();
        while (iContainer.getType() != 4) {
            this.setParentCheckState(iContainer);
            iContainer = iContainer.getParent();
        }
    }

    private void setParentCheckState(IContainer iContainer) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        for (IResource iResource : iResourceArray) {
            if (this.isFilteredResource(iResource)) continue;
            ++n;
            if (iResource.getType() == 1) {
                if (this.mFiles.contains(iResource)) {
                    bl2 = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (iResource.getType() != 2) continue;
            if (!this.mFolders.containsKey(iResource)) {
                bl = false;
                continue;
            }
            if (!this.mFolders.get(iResource).booleanValue()) continue;
            bl2 = true;
        }
        if (n == 0) {
            bl = false;
        }
        this.setCheckState(this.mFolders, (IResource)iContainer, bl, bl2);
    }

    private boolean hasVisibleMembers(IResource iResource) throws CoreException {
        IResource[] iResourceArray;
        boolean bl = false;
        for (IResource iResource2 : iResourceArray = ((IContainer)iResource).members()) {
            if (this.isFilteredResource(iResource2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void setCheckState(Map<IResource, Boolean> map, IResource iResource, boolean bl, boolean bl2) {
        if (bl || bl2) {
            map.put(iResource, bl2 && !bl);
        } else if (map.containsKey(iResource)) {
            map.remove(iResource);
        }
    }

    private void logMissingPaths(Map<String, Boolean> map, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            if (entry.getValue() != bl) continue;
            arrayList.add(entry.getKey());
        }
        if (!arrayList.isEmpty()) {
            Map.Entry<String, Boolean> entry;
            String string = bl ? Messages.getString("PackagePropertiesModel.DeserializeAsMissingResource") : Messages.getString("PackagePropertiesModel.DeserializeAsModifiedResource");
            entry = String.join((CharSequence)SEPARATOR, arrayList.toArray(new String[0]));
            PluginLogger.warning(String.format(string, entry));
        }
    }
}

