/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.model.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;

public class SystemHelper {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final int COMMAND_ARGS_LENGTH = 3;

    public static File getFile(IResource iResource) {
        return iResource.getLocation().toFile();
    }

    public static File getFile(IUnoidlProject iUnoidlProject) {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        return SystemHelper.getFile((IResource)iProject);
    }

    public static String[] addPathEnv(String[] stringArray, String string, String[] stringArray2) {
        String string2 = new String();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            String string4 = new Path(string3).toOSString();
            if (i < stringArray2.length - 1) {
                string4 = string4 + PATH_SEPARATOR;
            }
            string2 = string2 + string4;
        }
        return SystemHelper.addEnv(stringArray, string, string2, PATH_SEPARATOR);
    }

    public static String[] addEnv(String[] stringArray, String string, String string2, String string3) {
        String[] stringArray2 = new String[1];
        if (stringArray != null) {
            String string4;
            int n = 0;
            boolean bl = false;
            while (!bl && n < stringArray.length) {
                string4 = stringArray[n];
                String string5 = string;
                if (Platform.getOS().equals("win32")) {
                    string4 = string4.toLowerCase();
                    string5 = string.toLowerCase();
                }
                if (string4.startsWith(string5 + "=")) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) {
                stringArray2 = new String[stringArray.length];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                if (null != string3) {
                    string4 = stringArray[n].replaceFirst(string + "=", "");
                    stringArray2[n] = string + "=" + string2 + string3 + string4;
                } else {
                    stringArray2[n] = string + "=" + string2;
                }
            } else {
                stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray2.length - 1] = string + "=" + string2;
            }
        } else {
            stringArray2[0] = string + "=" + string2;
        }
        return stringArray2;
    }

    public static String[] getSystemEnvironement() {
        Set<Map.Entry<String, String>> set = System.getenv().entrySet();
        String[] stringArray = new String[set.size()];
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringArray[n] = entry.getKey() + "=" + entry.getValue();
            ++n;
        }
        return stringArray;
    }

    public static Process runToolWithSysEnv(String string, File file) throws IOException {
        return SystemHelper.runTool(string, SystemHelper.getSystemEnvironement(), file);
    }

    public static Process runTool(String string, String[] stringArray, File file) throws IOException {
        String string2;
        String[] stringArray2 = new String[3];
        if (Platform.getOS().equals("win32")) {
            string2 = System.getProperty("os.name").toLowerCase();
            stringArray2[0] = string2.startsWith("windows 9") ? "command.com" : "cmd.exe";
            stringArray2[1] = "/C";
            stringArray2[2] = string;
        } else {
            stringArray2[0] = "sh";
            stringArray2[1] = "-c";
            stringArray2[2] = string;
        }
        string2 = "";
        if (file != null) {
            string2 = " from dir: ";
            string2 = string2 + file.getAbsolutePath();
        }
        PluginLogger.debug("Running command: " + string + " with env: " + Arrays.toString(stringArray) + string2);
        Process process = null;
        process = file != null ? Runtime.getRuntime().exec(stringArray2, stringArray, file) : Runtime.getRuntime().exec(stringArray2, stringArray);
        return process;
    }
}

