/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.office;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.office.Messages;

public class OfficeClassLoader
extends URLClassLoader {
    private static Map<String, OfficeClassLoader> sClassLoaders = new HashMap<String, OfficeClassLoader>();

    private OfficeClassLoader(IOOo iOOo, ClassLoader classLoader) {
        super(OfficeClassLoader.getUrls(iOOo), classLoader);
    }

    public static OfficeClassLoader getClassLoader(IOOo iOOo, ClassLoader classLoader) {
        OfficeClassLoader officeClassLoader = sClassLoaders.get(iOOo.getHome());
        if (officeClassLoader == null) {
            officeClassLoader = new OfficeClassLoader(iOOo, classLoader);
            sClassLoaders.put(iOOo.getHome(), officeClassLoader);
        }
        return officeClassLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        try {
            if (clazz == null && string.startsWith("org.libreoffice.ide.eclipse.core.internal.office")) {
                clazz = this.findClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = super.loadClass(string, bl);
        }
        return clazz;
    }

    private static URL[] getUrls(IOOo iOOo) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        try {
            String[] stringArray = iOOo.getClassesPath();
            URL uRL = OOEclipsePlugin.getDefault().getBundle().getResource("/");
            URL uRL2 = FileLocator.resolve((URL)uRL);
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                File[] fileArray;
                String string = stringArray2[i];
                File object = new File(string);
                for (File file : fileArray = object.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().endsWith(".jar");
                    }
                })) {
                    linkedList.add(file.toURI().toURL());
                }
            }
            for (String string : stringArray2 = iOOo.getLibsPath()) {
                linkedList.add(new File(string).toURI().toURL());
            }
            linkedList.add(uRL2);
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("OfficeClassLoader.LoaderError"), exception);
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }
}

