/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.libreoffice.ide.eclipse.core.LogLevels;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.rows.ChoiceRow;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.preferences.Messages;

public class MainPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String LOGLEVEL = "__log_level";
    private IFieldChangedListener mListener = new loglevelListener();
    private ChoiceRow mLoglevel;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        this.mLoglevel = new ChoiceRow(composite2, LOGLEVEL, Messages.getString("MainPage.LogLevel"), null, false);
        this.mLoglevel.add(Messages.getString("MainPage.Error"), LogLevels.ERROR.toString());
        this.mLoglevel.add(Messages.getString("MainPage.Warning"), LogLevels.WARNING.toString());
        this.mLoglevel.add(Messages.getString("MainPage.Info"), LogLevels.INFO.toString());
        this.mLoglevel.add(Messages.getString("MainPage.Debug"), LogLevels.DEBUG.toString());
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.mLoglevel.select(iPreferenceStore.getString("loglevel"));
        this.mLoglevel.setFieldChangedListener(this.mListener);
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return OOEclipsePlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("loglevel", this.mLoglevel.getValue());
        return bl;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.mLoglevel.select(iPreferenceStore.getDefaultString("loglevel"));
    }

    private class loglevelListener
    implements IFieldChangedListener {
        private loglevelListener() {
        }

        @Override
        public void fieldChanged(FieldEvent fieldEvent) {
            if (fieldEvent.getProperty().equals(MainPage.LOGLEVEL)) {
                PluginLogger.setLevel(LogLevels.valueOf(fieldEvent.getValue()));
            }
        }
    }
}

