/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.rows.OOoRow;
import org.libreoffice.ide.eclipse.core.gui.rows.SdkRow;
import org.libreoffice.ide.eclipse.core.internal.model.UnoidlProject;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.SDKContainer;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;

public class ProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String SDK = "__sdk";
    private static final String OOO = "__ooo";
    private SdkRow mSdkRow;
    private OOoRow mOOoRow;
    private UnoidlProject mProject;

    public ProjectPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    public void dispose() {
        this.mOOoRow.dispose();
        this.mSdkRow.dispose();
        super.dispose();
    }

    public void setElement(IAdaptable iAdaptable) {
        super.setElement(iAdaptable);
        try {
            IProject iProject = (IProject)iAdaptable.getAdapter(IProject.class);
            if (iProject != null) {
                this.mProject = (UnoidlProject)ProjectsManager.getProject(iProject.getName());
            }
        }
        catch (Exception exception) {
            PluginLogger.debug(exception.getMessage());
        }
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.mOOoRow = new OOoRow(composite2, OOO, this.mProject.getOOo());
        this.mSdkRow = new SdkRow(composite2, SDK, this.mProject.getSdk());
        return composite2;
    }

    public boolean performOk() {
        this.saveValues();
        return true;
    }

    private void saveValues() {
        Object object;
        if (!this.mSdkRow.getValue().equals("")) {
            object = SDKContainer.getSDK(this.mSdkRow.getValue());
            this.mProject.setSdk((ISdk)object);
        }
        if (!this.mOOoRow.getValue().equals("")) {
            object = OOoContainer.getOOo(this.mOOoRow.getValue());
            this.mProject.setOOo((IOOo)object);
        }
        this.mProject.saveAllProperties();
    }
}

