/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.unotypebrowser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InternalUnoType {
    public static final InternalUnoType STRING = new InternalUnoType("string", 1024, true);
    public static final InternalUnoType VOID = new InternalUnoType("void", 1024, true);
    public static final InternalUnoType BOOLEAN = new InternalUnoType("boolean", 1024, true);
    public static final InternalUnoType BYTE = new InternalUnoType("byte", 1024, true);
    public static final InternalUnoType SHORT = new InternalUnoType("short", 1024, true);
    public static final InternalUnoType LONG = new InternalUnoType("long", 1024, true);
    public static final InternalUnoType HYPER = new InternalUnoType("hyper", 1024, true);
    public static final InternalUnoType FLOAT = new InternalUnoType("float", 1024, true);
    public static final InternalUnoType DOUBLE = new InternalUnoType("double", 1024, true);
    public static final InternalUnoType CHAR = new InternalUnoType("char", 1024, true);
    public static final InternalUnoType TYPE = new InternalUnoType("type", 1024, true);
    public static final InternalUnoType ANY = new InternalUnoType("any", 1024, true);
    public static final InternalUnoType USHORT = new InternalUnoType("unsigned short", 1024, true);
    public static final InternalUnoType ULONG = new InternalUnoType("unsigned long", 1024, true);
    public static final InternalUnoType UHYPER = new InternalUnoType("unsigned hyper", 1024, true);
    public static final int ALL_TYPES = 2047;
    private static final String LOCAL_TAG = "L";
    private static final String EXTERNAL_TAG = "E";
    private static final int TYPE_REGEX_GROUPS = 3;
    private static final int TYPE_VALUE_GROUP = 3;
    private static final int ALL_TYPES_FILTER = 2048;
    private String mPath;
    private int mType;
    private boolean mLocal = false;

    public InternalUnoType(String string) {
        Matcher matcher;
        if (null != string && (matcher = Pattern.compile("(E|L) ([^\\s]*) ([0-9]+)").matcher(string)).matches() && 3 == matcher.groupCount()) {
            this.setLocal(matcher.group(1));
            this.setType(Integer.parseInt(matcher.group(3)));
            this.mPath = matcher.group(2);
        }
    }

    public InternalUnoType(String string, int n, boolean bl) {
        this.mLocal = bl;
        this.setType(n);
        this.mPath = string;
    }

    public String getName() {
        String string = "";
        String[] stringArray = this.mPath.split("\\.");
        if (stringArray.length > 0) {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    public String getFullName() {
        return this.mPath;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isLocalType() {
        return this.mLocal;
    }

    public String toString() {
        String string = EXTERNAL_TAG;
        if (this.isLocalType()) {
            string = LOCAL_TAG;
        }
        return string + " " + this.getFullName() + " " + this.getType();
    }

    private void setType(int n) {
        if (n >= 0 && n < 2048) {
            this.mType = n;
        }
    }

    private void setLocal(String string) {
        this.mLocal = string.equals(LOCAL_TAG);
    }
}

