/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.unotypebrowser;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.gui.rows.ChoiceRow;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.internal.helpers.Flags;
import org.libreoffice.ide.eclipse.core.unotypebrowser.IInitListener;
import org.libreoffice.ide.eclipse.core.unotypebrowser.InternalUnoType;
import org.libreoffice.ide.eclipse.core.unotypebrowser.Messages;
import org.libreoffice.ide.eclipse.core.unotypebrowser.TypeProviderState;
import org.libreoffice.ide.eclipse.core.unotypebrowser.UnoTypeProvider;

public class UnoTypeBrowser
extends StatusDialog
implements IFieldChangedListener,
IInitListener {
    private static final String F_INPUT = "__input";
    private static final String F_TYPE_FILTER = "__type_filter";
    private static final int TITLE_HEIGHT = 20;
    private static final int TABLE_HEIGHT = 150;
    private static final int COLUMN_WIDTH = 300;
    private static final int ID_REFRESH = 3;
    private TextRow mInputRow;
    private TableViewer mTypesList;
    private Button mRefreshBtn;
    private ChoiceRow mTypeFilterRow;
    private InternalUnoType mSelectedType;
    private Flags mTypes;

    public UnoTypeBrowser(Shell shell, int n) {
        super(shell);
        this.mTypes = new Flags(2047, n, n);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.setTitle(Messages.getString("UnoTypeBrowser.Title"));
        UnoTypeProvider unoTypeProvider = UnoTypeProvider.getInstance();
        unoTypeProvider.addInitListener(this);
        if (!unoTypeProvider.getState().equals((Object)TypeProviderState.INITIALIZED)) {
            this.updateStatus((IStatus)new Status(1, "org.libreoffice.ide.eclipse.core", 1, Messages.getString("UnoTypeBrowser.WaitTypes"), null));
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.mRefreshBtn = this.createButton(composite, 3, Messages.getString("UnoTypeBrowser.RefreshButton"), false);
        Image image = OOEclipsePlugin.getImage("REFRESH");
        this.mRefreshBtn.setImage(image);
        this.mRefreshBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UnoTypeBrowser.this.activateFields(false);
                UnoTypeBrowser.this.updateStatus((IStatus)new Status(1, "org.libreoffice.ide.eclipse.core", 1, Messages.getString("UnoTypeBrowser.WaitTypes"), null));
                UnoTypeProvider.getInstance().refreshCache();
            }
        });
        UnoTypeProvider unoTypeProvider = UnoTypeProvider.getInstance();
        if (!unoTypeProvider.getState().equals((Object)TypeProviderState.INITIALIZED)) {
            this.activateFields(false);
        }
        super.createButtonsForButtonBar(composite);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(1810);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 20;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("UnoTypeBrowser.TitleTitle"));
        this.mInputRow = new TextRow(composite2, F_INPUT, Messages.getString("UnoTypeBrowser.TypeName"));
        this.mInputRow.setFieldChangedListener(this);
        this.createList(composite2);
        this.mTypeFilterRow = new ChoiceRow(composite2, F_TYPE_FILTER, Messages.getString("UnoTypeBrowser.FilterLabel"), null, false);
        this.mTypeFilterRow.setTooltip(Messages.getString("UnoTypeBrowser.FilterTooltip"));
        this.mTypeFilterRow.setFieldChangedListener(this);
        this.setFilterValues();
        this.mTypeFilterRow.select(0);
        UnoTypeProvider unoTypeProvider = UnoTypeProvider.getInstance();
        this.mTypesList.setInput((Object)unoTypeProvider);
        this.mInputRow.setFocus();
        return composite2;
    }

    @Override
    public void initialized() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!UnoTypeBrowser.this.mTypesList.getTable().isDisposed()) {
                    UnoTypeBrowser.this.mTypesList.refresh();
                    UnoTypeBrowser.this.activateFields(true);
                    UnoTypeBrowser.this.updateStatus((IStatus)new Status(1, "org.libreoffice.ide.eclipse.core", 1, "", null));
                }
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private void createList(Composite composite) {
        Table table = new Table(composite, 2564);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(300);
        this.mTypesList = new TableViewer(table);
        this.mTypesList.setUseHashlookup(true);
        this.mTypesList.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.mTypesList.setContentProvider((IContentProvider)new InternalTypesProvider());
        this.mTypesList.addFilter((ViewerFilter)new UnoTypesFilter());
        this.mTypesList.setComparator(new ViewerComparator());
        this.mTypesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection().isEmpty()) {
                    UnoTypeBrowser.this.updateStatus((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", 4, Messages.getString("UnoTypeBrowser.EmptySelectionError"), null));
                    UnoTypeBrowser.this.mSelectedType = null;
                    UnoTypeBrowser.this.getButton(0).setEnabled(false);
                } else {
                    UnoTypeBrowser.this.updateStatus((IStatus)new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null));
                    UnoTypeBrowser.this.getButton(0).setEnabled(true);
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    UnoTypeBrowser.this.mSelectedType = (InternalUnoType)iStructuredSelection.getFirstElement();
                    UnoTypeBrowser.this.mTypesList.refresh((Object)UnoTypeBrowser.this.mSelectedType, true);
                }
            }
        });
    }

    private void setFilterValues() {
        this.addFilter(2047, "UnoTypeBrowser.FilterAll");
        this.addFilter(1024, "UnoTypeBrowser.FilterSimple");
        this.addFilter(4, "UnoTypeBrowser.FilterServices");
        this.addFilter(2, "UnoTypeBrowser.FilterInterfaces");
        this.addFilter(512, "UnoTypeBrowser.FilterSingletons");
        this.addFilter(16, "UnoTypeBrowser.FilterEnumerations");
        this.addFilter(8, "UnoTypeBrowser.FilterStructures");
        this.addFilter(128, "UnoTypeBrowser.FilterConstants");
        this.addFilter(256, "UnoTypeBrowser.FilterConstantsGroups");
        this.addFilter(32, "UnoTypeBrowser.FilterException");
        this.addFilter(64, "UnoTypeBrowser.FilterTypedefs");
    }

    private void addFilter(int n, String string) {
        if (n == 2047 || this.mTypes.isFlagSet(n)) {
            String string2 = Integer.toString(n);
            this.mTypeFilterRow.add(Messages.getString(string), string2);
        }
    }

    public void activateFields(boolean bl) {
        Button button;
        Button button2;
        this.mInputRow.setEnabled(bl);
        this.mTypesList.getTable().setEnabled(bl);
        this.mTypeFilterRow.setEnabled(bl);
        if (this.mRefreshBtn != null) {
            this.mRefreshBtn.setEnabled(bl);
        }
        if (null != (button2 = this.getButton(0))) {
            button2.setEnabled(bl);
        }
        if (null != (button = this.getButton(1))) {
            button.setEnabled(bl);
        }
    }

    protected void okPressed() {
        if (this.mTypesList.getSelection().isEmpty()) {
            this.updateStatus((IStatus)new Status(4, "org.libreoffice.ide.eclipse.core", 4, Messages.getString("UnoTypeBrowser.EmptySelectionError"), null));
            this.getButton(0).setEnabled(false);
            UnoTypeProvider.getInstance().removeInitListener(this);
        } else {
            super.okPressed();
        }
    }

    private void refresh() {
        this.activateFields(false);
        this.mTypesList.refresh();
        this.activateFields(true);
    }

    @Override
    public void fieldChanged(FieldEvent fieldEvent) {
        if (fieldEvent.getProperty().equals(F_TYPE_FILTER)) {
            try {
                this.mTypes.setTypes(Integer.parseInt(fieldEvent.getValue()));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.refresh();
        this.mInputRow.setFocus();
    }

    public InternalUnoType getSelectedType() {
        return this.mSelectedType;
    }

    public void setSelectedType(InternalUnoType internalUnoType) {
        this.mSelectedType = internalUnoType;
        if (null != this.mTypesList) {
            StructuredSelection structuredSelection = StructuredSelection.EMPTY;
            if (null != this.mSelectedType) {
                structuredSelection = new StructuredSelection((Object)this.mSelectedType);
            }
            this.mTypesList.setSelection((ISelection)structuredSelection);
        }
    }

    class TypeLabelProvider
    extends LabelProvider {
        TypeLabelProvider() {
        }

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof InternalUnoType) {
                int n = ((InternalUnoType)object).getType();
                if (4 == n) {
                    image = OOEclipsePlugin.getImage("SERVICE");
                } else if (2 == n) {
                    image = OOEclipsePlugin.getImage("INTERFACE");
                } else if (8 == n) {
                    image = OOEclipsePlugin.getImage("STRUCT");
                } else if (16 == n) {
                    image = OOEclipsePlugin.getImage("ENUM");
                } else if (32 == n) {
                    image = OOEclipsePlugin.getImage("EXCEPTION");
                } else if (256 == n) {
                    image = OOEclipsePlugin.getImage("CONSTANTS");
                } else if (64 == n) {
                    image = OOEclipsePlugin.getImage("TYPEDEF");
                }
            }
            return image;
        }

        public String getText(Object object) {
            String string = "";
            if (object instanceof InternalUnoType) {
                IStructuredSelection iStructuredSelection;
                InternalUnoType internalUnoType = (InternalUnoType)object;
                string = internalUnoType.getName();
                if (!UnoTypeBrowser.this.mTypesList.getSelection().isEmpty() && (iStructuredSelection = (IStructuredSelection)UnoTypeBrowser.this.mTypesList.getSelection()).getFirstElement().equals(internalUnoType)) {
                    string = string + " - " + internalUnoType.getFullName();
                }
            }
            return string;
        }
    }

    private class InternalTypesProvider
    implements IStructuredContentProvider {
        private InternalTypesProvider() {
        }

        public Object[] getElements(Object object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (UnoTypeBrowser.this.mTypes.isFlagSet(1024)) {
                arrayList.add("basic-types");
            }
            return UnoTypeProvider.getInstance().toArray(arrayList.toArray(new String[arrayList.size()]));
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class UnoTypesFilter
    extends ViewerFilter {
        private UnoTypesFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = false;
            if (object2 instanceof InternalUnoType) {
                InternalUnoType internalUnoType = (InternalUnoType)object2;
                if (UnoTypeBrowser.this.mTypes.isFlagSet(internalUnoType.getType()) && internalUnoType.getName().startsWith(UnoTypeBrowser.this.mInputRow.getValue())) {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

