/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.unotypebrowser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.office.TypesGetter;
import org.libreoffice.ide.eclipse.core.unotypebrowser.IInitListener;
import org.libreoffice.ide.eclipse.core.unotypebrowser.InternalUnoType;
import org.libreoffice.ide.eclipse.core.unotypebrowser.Messages;
import org.libreoffice.ide.eclipse.core.unotypebrowser.TypeProviderState;

public class UnoTypeProvider {
    public static final int ALL_TYPES = 2047;
    public static final String BASIC_TYPES_KEY = "basic-types";
    private static final InternalUnoType[] SIMPLE_TYPES = new InternalUnoType[]{InternalUnoType.STRING, InternalUnoType.VOID, InternalUnoType.BOOLEAN, InternalUnoType.BYTE, InternalUnoType.SHORT, InternalUnoType.LONG, InternalUnoType.HYPER, InternalUnoType.FLOAT, InternalUnoType.DOUBLE, InternalUnoType.CHAR, InternalUnoType.TYPE, InternalUnoType.ANY, InternalUnoType.USHORT, InternalUnoType.ULONG, InternalUnoType.UHYPER};
    private static UnoTypeProvider sInstance = new UnoTypeProvider();
    private LinkedList<IInitListener> mListeners = new LinkedList();
    private Map<String, List<InternalUnoType>> mCache;
    private IOOo mOooInstance;
    private String mPathToRegister;
    private TypeProviderState mState = TypeProviderState.EMPTY;

    private UnoTypeProvider() {
    }

    public static UnoTypeProvider getInstance() {
        return sInstance;
    }

    public void refreshCache() {
        if (this.mOooInstance != null) {
            this.mState = TypeProviderState.INITIALIZING;
            this.removeAllTypes();
            new UnoTypesGetterThread().start();
        }
    }

    public boolean contains(String string, String[] stringArray) {
        boolean bl = false;
        string = string.replaceAll("::", ".");
        if (this.getState().equals((Object)TypeProviderState.INITIALIZED)) {
            for (String string2 : stringArray) {
                List<InternalUnoType> list = this.mCache.get(string2);
                if (list == null) continue;
                Iterator<InternalUnoType> iterator = list.iterator();
                while (iterator.hasNext() && !bl) {
                    InternalUnoType internalUnoType = iterator.next();
                    if (!internalUnoType.getFullName().equals(string)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void setProject(IUnoidlProject iUnoidlProject) {
        if (null != iUnoidlProject) {
            this.mOooInstance = iUnoidlProject.getOOo();
            this.mPathToRegister = iUnoidlProject.getFile(iUnoidlProject.getTypesPath()).getLocation().toOSString();
            PluginLogger.debug("UnoTypeProvider initialized with " + iUnoidlProject);
        }
    }

    public void setOOoInstance(IOOo iOOo) {
        if (null != iOOo && !iOOo.equals(this.mOooInstance)) {
            this.mOooInstance = iOOo;
            PluginLogger.debug("UnoTypeProvider initialized with " + iOOo);
        }
    }

    public TypeProviderState getState() {
        return this.mState;
    }

    public void addInitListener(IInitListener iInitListener) {
        this.mListeners.add(iInitListener);
    }

    public void removeInitListener(IInitListener iInitListener) {
        this.mListeners.remove(iInitListener);
    }

    private void setInitialized() {
        this.mState = TypeProviderState.INITIALIZED;
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            this.mListeners.get(i).initialized();
        }
    }

    protected Object[] toArray(String[] stringArray) {
        if (this.mCache == null) {
            this.refreshCache();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        if (this.mPathToRegister != null) {
            arrayList.add(this.mPathToRegister);
        }
        if (this.mOooInstance != null) {
            arrayList.add(this.mOooInstance.getName());
        }
        LinkedList<InternalUnoType> linkedList = new LinkedList<InternalUnoType>();
        for (String string : arrayList) {
            List<InternalUnoType> list = this.mCache.get(string);
            if (list == null) continue;
            linkedList.addAll(list);
        }
        return linkedList.toArray();
    }

    protected void removeAllTypes() {
        if (this.mCache != null) {
            this.mCache.clear();
        } else {
            this.mCache = new HashMap<String, List<InternalUnoType>>();
        }
    }

    private class UnoTypesGetterThread
    extends Thread {
        private UnoTypesGetterThread() {
        }

        @Override
        public void run() {
            try {
                UnoTypeProvider.this.removeAllTypes();
                TypesGetter typesGetter = new TypesGetter();
                typesGetter.setOOo(UnoTypeProvider.this.mOooInstance);
                LinkedList<String> linkedList = new LinkedList<String>();
                linkedList.add(UnoTypeProvider.this.mPathToRegister);
                typesGetter.setLocalRegs(linkedList);
                Map<String, List<InternalUnoType>> map = typesGetter.getTypes(null, 2047);
                for (String string : map.keySet()) {
                    List list = (List)UnoTypeProvider.this.mCache.get(string);
                    if (list != null) {
                        list.clear();
                        UnoTypeProvider.this.mCache.remove(string);
                    }
                    UnoTypeProvider.this.mCache.put(string, map.get(string));
                }
                UnoTypeProvider.this.mCache.put(UnoTypeProvider.BASIC_TYPES_KEY, Arrays.asList(SIMPLE_TYPES));
                UnoTypeProvider.this.setInitialized();
                PluginLogger.debug("Types fetched");
            }
            catch (Exception exception) {
                PluginLogger.error(Messages.getString("UnoTypeProvider.UnexpectedError"), exception);
            }
        }
    }
}

