/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.model.UnoFactory;
import org.libreoffice.ide.eclipse.core.internal.model.UnoidlProject;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.NewInterfaceWizardPage;

public class NewInterfaceWizard
extends BasicNewResourceWizard
implements INewWizard {
    private IWorkbenchPage mActivePage = WorkbenchHelper.getActivePage();
    private NewInterfaceWizardPage mPage;

    public boolean performFinish() {
        final UnoFactoryData unoFactoryData = this.mPage.fillData(new UnoFactoryData());
        Job job = new Job(Messages.getString("NewInterfaceWizard.JobName")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(Messages.getString("NewInterfaceWizard.TaskName"), 1);
                Status status = new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null);
                try {
                    IUnoidlProject iUnoidlProject = NewInterfaceWizard.this.mPage.getProject();
                    UnoFactory.createInterface(unoFactoryData, iUnoidlProject, NewInterfaceWizard.this.mActivePage, iProgressMonitor);
                    unoFactoryData.dispose();
                    iProgressMonitor.worked(1);
                }
                catch (Exception exception) {
                    status = new Status(8, "org.libreoffice.ide.eclipse.core", 0, Messages.getString("NewInterfaceWizard.InterfaceCreationError"), (Throwable)exception);
                    iProgressMonitor.setCanceled(true);
                }
                iProgressMonitor.done();
                return status;
            }
        };
        job.setPriority(10);
        job.schedule();
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        if (iStructuredSelection.getFirstElement() instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iStructuredSelection.getFirstElement();
            IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
            if (iResource != null) {
                this.createPages(iResource.getProject());
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"You need to create/select a LibreOffice project first to use the selection");
        }
    }

    private void createPages(IProject iProject) {
        if (null != iProject) {
            try {
                if (iProject.hasNature("org.libreoffice.ide.eclipse.core.unonature")) {
                    UnoidlProject unoidlProject = (UnoidlProject)iProject.getNature("org.libreoffice.ide.eclipse.core.unonature");
                    this.mPage = new NewInterfaceWizardPage("newiface", unoidlProject);
                    this.addPage((IWizardPage)this.mPage);
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"The Selection only works with LibreOffice projects");
                }
            }
            catch (CoreException coreException) {
                PluginLogger.debug(coreException.getMessage());
            }
        }
    }

    protected void openResource(final IFile iFile) {
        Display display;
        if (this.mActivePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)NewInterfaceWizard.this.mActivePage, (IFile)iFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        PluginLogger.debug(partInitException.getMessage());
                    }
                }
            });
        }
    }
}

