/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.model.UnoidlProject;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.ServiceWizardSet;
import org.libreoffice.ide.eclipse.core.wizards.utils.NoSuchPageException;

public class NewServiceWizard
extends BasicNewResourceWizard
implements INewWizard {
    private IWorkbenchPage mActivePage = WorkbenchHelper.getActivePage();
    private ServiceWizardSet mWizardSet;

    public boolean performFinish() {
        Job job = new Job(Messages.getString("NewServiceWizard.JobName")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Status status = new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null);
                try {
                    NewServiceWizard.this.mWizardSet.doFinish(iProgressMonitor, NewServiceWizard.this.mActivePage);
                }
                catch (Exception exception) {
                    status = new Status(8, "org.libreoffice.ide.eclipse.core", 0, Messages.getString("NewServiceWizard.CreateServiceError"), (Throwable)exception);
                }
                return status;
            }
        };
        job.setPriority(10);
        job.schedule();
        return true;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = null;
        try {
            iWizardPage2 = this.mWizardSet.getNextPage(iWizardPage);
        }
        catch (NoSuchPageException noSuchPageException) {
            // empty catch block
        }
        return iWizardPage2;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = null;
        try {
            iWizardPage2 = this.mWizardSet.getPreviousPage(iWizardPage);
        }
        catch (NoSuchPageException noSuchPageException) {
            // empty catch block
        }
        return iWizardPage2;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        if (iStructuredSelection.getFirstElement() instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iStructuredSelection.getFirstElement();
            IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
            if (iResource != null) {
                this.createPages(iResource.getProject());
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"You need to create/select a LibreOffice project first to use the selection");
        }
    }

    private void createPages(IProject iProject) {
        if (null != iProject) {
            try {
                if (iProject.hasNature("org.libreoffice.ide.eclipse.core.unonature")) {
                    UnoidlProject unoidlProject = (UnoidlProject)iProject.getNature("org.libreoffice.ide.eclipse.core.unonature");
                    this.mWizardSet = new ServiceWizardSet((IWizard)this);
                    IWizardPage[] iWizardPageArray = this.mWizardSet.getPages();
                    for (IWizardPage iWizardPage : iWizardPageArray) {
                        this.addPage(iWizardPage);
                    }
                    UnoFactoryData unoFactoryData = new UnoFactoryData();
                    unoFactoryData.setProperty("project_name", unoidlProject.getName());
                    unoFactoryData.setProperty("project_prefix", unoidlProject.getCompanyPrefix());
                    unoFactoryData.setProperty("project_ooo", unoidlProject.getOOo());
                    UnoFactoryData unoFactoryData2 = new UnoFactoryData();
                    unoFactoryData2.setProperty("type_nature", 4);
                    unoFactoryData2.setProperty("type_name", Messages.getString("NewServiceWizard.DefaultName"));
                    unoFactoryData.addInnerData(unoFactoryData2);
                    this.mWizardSet.initialize(unoFactoryData);
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"The Selection only works with LibreOffice projects");
                }
            }
            catch (CoreException coreException) {
                PluginLogger.debug(coreException.getMessage());
            }
        }
    }
}

