/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.internal.model.UnoFactory;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.OOoContainer;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.language.AbstractLanguage;
import org.libreoffice.ide.eclipse.core.model.language.LanguageWizardPage;
import org.libreoffice.ide.eclipse.core.utils.WorkbenchHelper;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.ServiceWizardSet;
import org.libreoffice.ide.eclipse.core.wizards.pages.NewUnoProjectPage;
import org.libreoffice.ide.eclipse.core.wizards.utils.NoSuchPageException;

public class NewUnoProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    protected NewUnoProjectPage mMainPage;
    private LanguageWizardPage mLanguagePage = null;
    private ServiceWizardSet mServiceSet = null;
    private String mServiceIfaceName = null;
    private IWorkbenchPage mActivePage = WorkbenchHelper.getActivePage();

    public NewUnoProjectWizard() {
        this.setForcePreviousAndNextButtons(false);
    }

    protected void setDisableServicePage(String string) {
        this.mServiceIfaceName = string;
    }

    public void addPages() {
        IWizardPage[] iWizardPageArray;
        this.mMainPage = new NewUnoProjectPage("mainpage");
        this.addPage((IWizardPage)this.mMainPage);
        this.mServiceSet = new ServiceWizardSet((IWizard)this);
        for (IWizardPage iWizardPage : iWizardPageArray = this.mServiceSet.getPages()) {
            this.addPage(iWizardPage);
            if (this.mServiceIfaceName != null && !this.mServiceIfaceName.equals("")) continue;
            this.mServiceSet.setHidden(iWizardPage, true);
        }
    }

    public void setLanguagePage(LanguageWizardPage languageWizardPage) {
        if (languageWizardPage != null) {
            if (this.mLanguagePage == null || !((Object)((Object)this.mLanguagePage)).getClass().equals(((Object)((Object)languageWizardPage)).getClass())) {
                this.mLanguagePage = languageWizardPage;
                this.addPage((IWizardPage)this.mLanguagePage);
            }
        } else {
            if (this.mLanguagePage != null) {
                this.mLanguagePage.dispose();
            }
            this.mLanguagePage = null;
        }
    }

    public void pageChanged(IWizardPage iWizardPage) {
        if (this.mMainPage.equals(iWizardPage)) {
            this.updateLanguagePage();
            try {
                String string = this.mMainPage.getProjectName().trim();
                string = string.replace(" ", "");
                String string2 = string.substring(0, 1).toUpperCase();
                string = string2 + string.substring(1);
                String string3 = this.mMainPage.getPrefix() + ".X" + string;
                if (this.mServiceIfaceName != null && !this.mServiceIfaceName.equals("")) {
                    string3 = this.mServiceIfaceName;
                }
                UnoFactoryData unoFactoryData = new UnoFactoryData();
                unoFactoryData.setProperty("project_ooo", OOoContainer.getOOo(this.mMainPage.getOOoName()));
                unoFactoryData.setProperty("project_prefix", this.mMainPage.getPrefix());
                UnoFactoryData unoFactoryData2 = new UnoFactoryData();
                unoFactoryData2.setProperty("type_nature", 4);
                unoFactoryData2.setProperty("type_name", string);
                unoFactoryData2.setProperty("inherited_interfaces", new String[]{string3.replaceAll("\\.", "::")});
                unoFactoryData2.setProperty("package_name", this.mMainPage.getPrefix().replaceAll("\\.", "::"));
                unoFactoryData.addInnerData(unoFactoryData2);
                if (this.mServiceIfaceName != null && !this.mServiceIfaceName.equals("")) {
                    UnoFactoryData unoFactoryData3 = new UnoFactoryData();
                    unoFactoryData3.setProperty("type_nature", 2);
                    String[] stringArray = this.mServiceIfaceName.split("::");
                    String string4 = stringArray[0];
                    for (int i = 1; i < stringArray.length - 1; ++i) {
                        string4 = string4 + "::" + stringArray[i];
                    }
                    unoFactoryData3.setProperty("type_name", stringArray[stringArray.length - 1]);
                    unoFactoryData3.setProperty("package_name", string4);
                    unoFactoryData.addInnerData(unoFactoryData3);
                }
                this.mServiceSet.dataChanged(unoFactoryData);
                unoFactoryData.dispose();
                unoFactoryData = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        Object object = null;
        try {
            object = this.mServiceSet.getNextPage(iWizardPage);
        }
        catch (NoSuchPageException noSuchPageException) {
            object = super.getNextPage(iWizardPage);
            try {
                if (this.mMainPage.equals(iWizardPage)) {
                    object = this.mLanguagePage != null ? this.mLanguagePage : this.mServiceSet.getPage("service");
                } else if (this.mLanguagePage != null && ((Object)((Object)this.mLanguagePage)).equals(iWizardPage)) {
                    object = this.mServiceSet.getPage("service");
                }
            }
            catch (Exception exception) {
                object = null;
            }
        }
        return object;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        Object object = null;
        try {
            object = this.mServiceSet.getPreviousPage(iWizardPage);
        }
        catch (NoSuchPageException noSuchPageException) {
            object = super.getPreviousPage(iWizardPage);
        }
        if (this.mServiceSet != null) {
            boolean bl;
            IWizardPage iWizardPage2 = this.mServiceSet.getPage("service");
            boolean bl2 = bl = object == null && iWizardPage.equals((Object)iWizardPage2);
            if (bl && this.mLanguagePage != null) {
                object = this.mLanguagePage;
            } else if (bl && this.mLanguagePage == null) {
                object = this.mMainPage;
            }
        }
        return object;
    }

    public boolean performFinish() {
        UnoFactoryData unoFactoryData = new UnoFactoryData();
        unoFactoryData = this.mMainPage.fillData(unoFactoryData, true);
        if (this.mLanguagePage != null) {
            unoFactoryData = this.mLanguagePage.fillData(unoFactoryData);
        }
        new ProjectCreationJob(unoFactoryData).schedule();
        return true;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private void updateLanguagePage() {
        UnoFactoryData unoFactoryData;
        AbstractLanguage abstractLanguage = this.mMainPage.getChosenLanguage();
        if (abstractLanguage != null && !abstractLanguage.toString().contains("python")) {
            unoFactoryData = new UnoFactoryData();
            LanguageWizardPage languageWizardPage = abstractLanguage.getNewWizardPage();
            if (languageWizardPage != null) {
                languageWizardPage.setProjectInfos(this.mMainPage.fillData(unoFactoryData, false));
            }
            this.setLanguagePage(languageWizardPage);
            unoFactoryData.dispose();
        } else {
            this.setLanguagePage(null);
        }
        if (this.mLanguagePage != null) {
            unoFactoryData = new UnoFactoryData();
            this.mLanguagePage.setProjectInfos(this.mMainPage.fillData(unoFactoryData, false));
            unoFactoryData.dispose();
        }
    }

    private class ProjectCreationJob
    extends Job {
        private UnoFactoryData mData;

        public ProjectCreationJob(UnoFactoryData unoFactoryData) {
            super(Messages.getString("NewUnoProjectWizard.JobName"));
            this.setPriority(10);
            this.mData = unoFactoryData;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Status status = new Status(0, "org.libreoffice.ide.eclipse.core", 0, "", null);
            try {
                IUnoidlProject iUnoidlProject;
                ((NewUnoProjectWizard)NewUnoProjectWizard.this).mServiceSet.mProject = iUnoidlProject = UnoFactory.createProject(this.mData, iProgressMonitor);
                NewUnoProjectWizard.this.mServiceSet.doFinish(iProgressMonitor, NewUnoProjectWizard.this.mActivePage);
                UnoidlProjectHelper.setProjectBuilders(iUnoidlProject);
            }
            catch (Exception exception) {
                PluginLogger.error(null, exception);
                Object object = this.mData.getProperty("project_handle");
                if (object instanceof IProject) {
                    this.rollback((IProject)object);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("NewUnoProjectWizard.ProjectCreationErrorTitle"), (String)Messages.getString("NewUnoProjectWizard.ProjectCreationErrorMessage"));
                    }
                });
                PluginLogger.error(Messages.getString("NewUnoProjectWizard.CreateProjectError"), exception);
                status = new Status(0, "org.libreoffice.ide.eclipse.core", 0, Messages.getString("NewUnoProjectWizard.CreateProjectError"), (Throwable)exception);
            }
            if (this.mData != null) {
                this.mData.dispose();
            }
            this.mData = null;
            return status;
        }

        private void rollback(IProject iProject) {
            try {
                iProject.delete(true, true, null);
            }
            catch (CoreException coreException) {
                PluginLogger.debug(Messages.getString("NewUnoProjectWizard.DeleteProjectError"));
            }
        }
    }
}

