/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.ManifestExportPage;
import org.libreoffice.ide.eclipse.core.wizards.pages.UnoPackageExportPage;
import org.libreoffice.plugin.core.model.UnoPackage;

public class PackageExportWizard
extends Wizard
implements IExportWizard {
    private static final String DIALOG_SETTINGS_KEY = "oxt.export";
    private UnoPackageExportPage mMainPage;
    private ManifestExportPage mManifestPage;
    private boolean mHasNewDialogSettings;

    public PackageExportWizard() {
        IDialogSettings iDialogSettings = OOEclipsePlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_KEY);
        if (iDialogSettings2 == null) {
            this.mHasNewDialogSettings = true;
        } else {
            this.mHasNewDialogSettings = false;
            this.setDialogSettings(iDialogSettings2);
        }
    }

    public boolean performFinish() {
        boolean bl = false;
        UnoPackage unoPackage = this.mMainPage.getPackageModel();
        if (unoPackage != null) {
            try {
                this.mMainPage.forceBuild();
                this.mManifestPage.configureManifest(unoPackage);
                File file = unoPackage.close();
                bl = file != null;
                this.mMainPage.refreshProject();
                if (this.mHasNewDialogSettings) {
                    IDialogSettings iDialogSettings = OOEclipsePlugin.getDefault().getDialogSettings();
                    IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_KEY);
                    iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_KEY);
                    this.setDialogSettings(iDialogSettings2);
                }
                this.mMainPage.saveWidgetValues();
            }
            catch (Exception exception) {
                PluginLogger.error("Project couldn't be built", exception);
            }
        }
        return bl;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        IUnoidlProject iUnoidlProject = null;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext() && iUnoidlProject == null) {
            IResource iResource;
            Object e = iterator.next();
            if (!(e instanceof IAdaptable) || (iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class)) == null) continue;
            iUnoidlProject = ProjectsManager.getProject(iResource.getProject().getName());
        }
        this.setWindowTitle(Messages.getString("PackageExportWizard2.DialogTitle"));
        this.mManifestPage = new ManifestExportPage("page2", iUnoidlProject);
        this.mMainPage = new UnoPackageExportPage("page1", iUnoidlProject, this.mManifestPage);
        this.addPage((IWizardPage)this.mMainPage);
        this.addPage((IWizardPage)this.mManifestPage);
    }
}

