/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.internal.helpers.UnoidlProjectHelper;
import org.libreoffice.ide.eclipse.core.internal.model.UnoFactory;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.NewInterfaceWizardPage;
import org.libreoffice.ide.eclipse.core.wizards.pages.NewScopedElementWizardPage;
import org.libreoffice.ide.eclipse.core.wizards.pages.NewServiceWizardPage;
import org.libreoffice.ide.eclipse.core.wizards.utils.WizardPageSet;

public class ServiceWizardSet
extends WizardPageSet {
    public static final String SERVICE_PAGE_ID = "service";
    public static final String INTERFACE_PAGE_ID = "interface";
    protected IUnoidlProject mProject;
    private boolean mShowInterfacePage = true;

    public ServiceWizardSet(IWizard iWizard) {
        super(iWizard);
        NewServiceWizardPage newServiceWizardPage = new NewServiceWizardPage(SERVICE_PAGE_ID, null);
        newServiceWizardPage.addPageListener(this.mPageListener);
        this.addPage((IWizardPage)newServiceWizardPage);
        this.addPage((IWizardPage)new NewInterfaceWizardPage(INTERFACE_PAGE_ID, null));
    }

    @Override
    public void initialize(UnoFactoryData unoFactoryData) {
        try {
            UnoFactoryData unoFactoryData2;
            String string = (String)unoFactoryData.getProperty("project_name");
            IOOo iOOo = (IOOo)unoFactoryData.getProperty("project_ooo");
            String string2 = (String)unoFactoryData.getProperty("project_prefix");
            String string3 = null;
            if (string2 != null) {
                string3 = string2.replaceAll("\\.", "::");
            }
            UnoFactoryData[] unoFactoryDataArray = unoFactoryData.getInnerData();
            Map<Integer, Integer> map = this.getPagesId(unoFactoryDataArray);
            String string4 = null;
            if (map.containsKey(4)) {
                unoFactoryData2 = unoFactoryDataArray[map.get(4)];
                this.setServicePageData(unoFactoryData2, string3, string, iOOo);
                string4 = this.getServiceInheritance(unoFactoryData2, string3, string);
            }
            if (map.containsKey(2)) {
                unoFactoryData2 = unoFactoryDataArray[map.get(2)];
                this.setInterfacePageData(unoFactoryData2, string3, string, iOOo, string4);
            }
        }
        catch (Exception exception) {
            PluginLogger.warning(Messages.getString("ServiceWizardSet.WrongInitDataWarning"), exception);
        }
    }

    private void setInterfacePageData(UnoFactoryData unoFactoryData, String string, String string2, IOOo iOOo, String string3) {
        String string4 = (String)unoFactoryData.getProperty("type_name");
        String string5 = (String)unoFactoryData.getProperty("package_name");
        if (string4 == null) {
            string4 = string3.substring(string3.lastIndexOf(58) + 1);
        }
        if (string5 == null) {
            string5 = string3.substring(0, string3.lastIndexOf(":") - 1);
        }
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string2);
        this.checkIsInterfacePageNeeded(iUnoidlProject, string3);
        if (string3 != null) {
            string4 = string3.substring(string3.lastIndexOf(58) + 1);
            string5 = string3.substring(0, string3.lastIndexOf(":") - 1);
        }
        NewInterfaceWizardPage newInterfaceWizardPage = (NewInterfaceWizardPage)this.getPage(INTERFACE_PAGE_ID);
        this.setHidden((IWizardPage)newInterfaceWizardPage, !this.mShowInterfacePage);
        this.mChangingPages = true;
        newInterfaceWizardPage.setPackageRoot(string);
        newInterfaceWizardPage.setPackage(string5.substring(string.length()), false);
        newInterfaceWizardPage.setName(string4, false);
        if (iOOo != null) {
            newInterfaceWizardPage.setOOoInstance(iOOo);
        }
        if (iUnoidlProject != null) {
            newInterfaceWizardPage.setUnoidlProject(iUnoidlProject);
        }
        this.mChangingPages = false;
    }

    private void setServicePageData(UnoFactoryData unoFactoryData, String string, String string2, IOOo iOOo) {
        String string3 = null;
        String string4 = null;
        string3 = (String)unoFactoryData.getProperty("type_name");
        string4 = (String)unoFactoryData.getProperty("package_name");
        NewServiceWizardPage newServiceWizardPage = (NewServiceWizardPage)this.getPage(SERVICE_PAGE_ID);
        if (string4 == null) {
            string4 = newServiceWizardPage.getPackage();
        }
        if (string3 == null) {
            string3 = newServiceWizardPage.getElementName();
        }
        if (string4 == null || string4.equals("")) {
            string4 = string;
        }
        if ((string3 == null || string3.equals("")) && string2 != null) {
            string3 = string2.replace("\\W", "");
            string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        }
        String string5 = this.getServiceInheritance(unoFactoryData, string, string2);
        string4 = this.guessPackage(string4, string);
        this.mChangingPages = true;
        newServiceWizardPage.setName(string3, false);
        newServiceWizardPage.setPackageRoot(string);
        newServiceWizardPage.setPackage(string4, false);
        if (iOOo != null) {
            newServiceWizardPage.setOOoInstance(iOOo);
        }
        if (string2 != null) {
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string2);
            newServiceWizardPage.setUnoidlProject(iUnoidlProject);
        }
        newServiceWizardPage.setInheritanceName(string5, false);
        this.mChangingPages = false;
    }

    private Map<Integer, Integer> getPagesId(UnoFactoryData[] unoFactoryDataArray) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < unoFactoryDataArray.length && (n == -1 || n2 == -1); ++i) {
            Integer n3 = (Integer)unoFactoryDataArray[i].getProperty("type_nature");
            if (n3 == null) continue;
            if (n3 == 4) {
                n = i;
                hashMap.put(4, n);
            }
            if (n3 != 2) continue;
            n2 = i;
            hashMap.put(2, n2);
        }
        return hashMap;
    }

    @Override
    public void dataChanged(UnoFactoryData unoFactoryData) {
        try {
            UnoFactoryData unoFactoryData2;
            UnoFactoryData[] unoFactoryDataArray;
            String string = (String)unoFactoryData.getProperty("project_name");
            IOOo iOOo = (IOOo)unoFactoryData.getProperty("project_ooo");
            String string2 = (String)unoFactoryData.getProperty("project_prefix");
            String string3 = null;
            if (string2 != null) {
                string3 = string2.replaceAll("\\.", "::");
            }
            if (string3 == null) {
                unoFactoryDataArray = (NewServiceWizardPage)this.getPage(SERVICE_PAGE_ID);
                string3 = unoFactoryDataArray.getPackageRoot();
            }
            unoFactoryDataArray = unoFactoryData.getInnerData();
            Map<Integer, Integer> map = this.getPagesId(unoFactoryDataArray);
            String string4 = null;
            if (map.containsKey(4)) {
                unoFactoryData2 = unoFactoryDataArray[map.get(4)];
                this.setServicePageData(unoFactoryData2, string3, string, iOOo);
                string4 = this.getServiceInheritance(unoFactoryData2, string3, string);
            }
            unoFactoryData2 = new UnoFactoryData();
            if (map.containsKey(2)) {
                unoFactoryData2 = unoFactoryDataArray[map.get(2)];
            }
            this.setInterfacePageData(unoFactoryData2, string3, string, iOOo, string4);
        }
        catch (Exception exception) {
            PluginLogger.warning(Messages.getString("ServiceWizardSet.WrongInitDataWarning"), exception);
        }
    }

    private String getServiceInheritance(UnoFactoryData unoFactoryData, String string, String string2) {
        String[] stringArray;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string4 = (String)unoFactoryData.getProperty("type_name");
        string5 = (String)unoFactoryData.getProperty("package_name");
        NewServiceWizardPage newServiceWizardPage = (NewServiceWizardPage)this.getPage(SERVICE_PAGE_ID);
        if (string5 == null) {
            string5 = newServiceWizardPage.getPackage();
        }
        if (string4 == null) {
            string4 = newServiceWizardPage.getElementName();
        }
        if (string5 == null) {
            string5 = string;
        }
        if ((string4 == null || string4.equals("")) && string2 != null) {
            string4 = string2.replace("\\W", "");
            string4 = string4.substring(0, 1).toUpperCase() + string4.substring(1);
        }
        if ((stringArray = (String[])unoFactoryData.getProperty("inherited_interfaces")) != null && stringArray.length > 0) {
            string3 = stringArray[0];
        }
        if (string3 == null) {
            string3 = string5 + "::X" + string4;
        }
        return string3;
    }

    private void checkIsInterfacePageNeeded(IUnoidlProject iUnoidlProject, String string) {
        if (string != null) {
            boolean bl;
            NewServiceWizardPage newServiceWizardPage = (NewServiceWizardPage)this.getPage(SERVICE_PAGE_ID);
            if (iUnoidlProject == null) {
                iUnoidlProject = newServiceWizardPage.getProject();
            }
            String string2 = newServiceWizardPage.getPackageRoot();
            if (iUnoidlProject != null) {
                string2 = iUnoidlProject.getRootModule();
            }
            this.mShowInterfacePage = string2 != null && !string2.equals("") ? (bl = (bl = string.startsWith(string2)) && !NewScopedElementWizardPage.existsIdlFile(string, iUnoidlProject)) : false;
        }
    }

    private String guessPackage(String string, String string2) {
        if (string2 == null) {
            NewServiceWizardPage newServiceWizardPage = (NewServiceWizardPage)this.getPage(SERVICE_PAGE_ID);
            string2 = newServiceWizardPage.getPackageRoot();
        }
        if (string != null && (string = string.substring(string2.length())).startsWith("::")) {
            string = string.substring(2);
        }
        return string;
    }

    @Override
    public void doFinish(IProgressMonitor iProgressMonitor, IWorkbenchPage iWorkbenchPage) {
        NewServiceWizardPage newServiceWizardPage = (NewServiceWizardPage)this.getPage(SERVICE_PAGE_ID);
        NewInterfaceWizardPage newInterfaceWizardPage = (NewInterfaceWizardPage)this.getPage(INTERFACE_PAGE_ID);
        try {
            UnoFactoryData unoFactoryData;
            IUnoidlProject iUnoidlProject = newServiceWizardPage.getProject();
            if (iUnoidlProject == null) {
                iUnoidlProject = this.mProject;
            }
            if (this.mShowInterfacePage) {
                unoFactoryData = new UnoFactoryData();
                unoFactoryData = newInterfaceWizardPage.fillData(unoFactoryData);
                UnoFactory.createInterface(unoFactoryData, iUnoidlProject, iWorkbenchPage, iProgressMonitor, false);
                unoFactoryData.dispose();
            }
            unoFactoryData = new UnoFactoryData();
            unoFactoryData = newServiceWizardPage.fillData(unoFactoryData);
            UnoFactory.createService(unoFactoryData, iUnoidlProject, iWorkbenchPage, iProgressMonitor, false);
            UnoidlProjectHelper.refreshProject(iUnoidlProject, null);
            UnoidlProjectHelper.forceBuild(iUnoidlProject, iProgressMonitor);
            if (!iUnoidlProject.getLanguage().getName().contains("Python")) {
                UnoFactoryData unoFactoryData2 = new UnoFactoryData();
                unoFactoryData2.addInnerData(unoFactoryData);
                unoFactoryData2.setProperty("project_language", iUnoidlProject.getLanguage());
                unoFactoryData2.setProperty("project_name", iUnoidlProject.getName());
                UnoFactory.makeSkeleton(unoFactoryData2, iWorkbenchPage, iProgressMonitor);
                unoFactoryData2.dispose();
            }
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("ServiceWizardSet.ServiceCreationError"), exception);
        }
    }
}

