/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.libreoffice.ide.eclipse.core.gui.TypeCellEditor;
import org.libreoffice.ide.eclipse.core.gui.rows.BooleanRow;
import org.libreoffice.ide.eclipse.core.gui.rows.ChoiceRow;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.gui.rows.TypeRow;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.wizards.Messages;

public class InterfaceMemberDialog
extends TitleAreaDialog
implements IFieldChangedListener {
    private static final String MEMBER_TYPE = "__member_type";
    private static final String NAME = "__name";
    private static final String TYPE = "__type";
    private static final String BOUND = "__bound";
    private static final String READONLY = "__readonly";
    private static final String PARAM_TYPE = "__param_type";
    private static final String PARAM_INOUT = "__param_inout";
    private static final String PARAM_NAME = "__param_name";
    private static final int WIDTH = 500;
    private static final int HEIGHT = 480;
    private static final int NAME_WITH = 200;
    private static final int TYPE_WIDTH = 170;
    private static final int DIRECTION_WIDTH = 70;
    private UnoFactoryData mData;
    private ChoiceRow mMemberTypeRow;
    private TextRow mNameRow;
    private TypeRow mTypeRow;
    private BooleanRow mBoundRow;
    private BooleanRow mReadonlyRow;
    private Button mAddButton;
    private Button mDelButton;
    private TableViewer mArgumentTableViewer;
    private Composite mSpecificPanel;
    private boolean mShowAttribute;
    private String mTitle = "";
    private String mMessage = "";

    public InterfaceMemberDialog() {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.mTitle = Messages.getString("InterfaceMemberDialog.CreationDialogTitle");
        this.mMessage = Messages.getString("InterfaceMemberDialog.NewMemberDescription");
        this.mData = new UnoFactoryData();
    }

    public InterfaceMemberDialog(UnoFactoryData unoFactoryData) {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.mData = unoFactoryData;
        try {
            int n = (Integer)this.mData.getProperty("member_type");
            if (n == 2) {
                this.mTitle = Messages.getString("InterfaceMemberDialog.MethodDialogTitle");
                this.mMessage = Messages.getString("InterfaceMemberDialog.EditMethodDescription");
            } else if (n == 1) {
                this.mTitle = Messages.getString("InterfaceMemberDialog.AttributeDialogTitle");
                this.mMessage = Messages.getString("InterfaceMemberDialog.EditAttributeDescription");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Rectangle rectangle = Display.getDefault().getClientArea();
        shell.setBounds((rectangle.width - 500) / 2, (rectangle.height - 480) / 2, 500, 480);
    }

    public UnoFactoryData getData() {
        return this.mData;
    }

    public void disposeData() {
        if (this.mData != null) {
            this.mData.dispose();
        }
    }

    protected Control createDialogArea(Composite composite) {
        Integer n;
        this.setTitle(this.mTitle);
        this.setMessage(this.mMessage);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        String string = "";
        if (this.mData != null && null != this.mData.getProperty("member_type") && (n = (Integer)this.mData.getProperty("member_type")) != null) {
            switch (n) {
                case 2: {
                    string = "method";
                    this.mShowAttribute = true;
                    break;
                }
                case 1: {
                    string = "attribute";
                    this.mShowAttribute = false;
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        this.createCommonRows(composite2, string.equals(""));
        this.mSpecificPanel = new Composite(composite2, 0);
        n = new GridData(1808);
        ((GridData)n).horizontalSpan = 3;
        this.mSpecificPanel.setLayoutData((Object)n);
        this.mSpecificPanel.setLayout((Layout)new GridLayout(3, false));
        if (string.equals("")) {
            string = this.mMemberTypeRow.getValue();
        }
        this.showSpecificControls(string.equals("attribute"));
        return composite2;
    }

    private void createCommonRows(Composite composite, boolean bl) {
        String string;
        Object object;
        Object object2;
        if (bl) {
            object2 = new Composite(composite, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            object2.setLayoutData((Object)gridData);
            object2.setLayout((Layout)new GridLayout(3, false));
            this.mMemberTypeRow = new ChoiceRow((Composite)object2, MEMBER_TYPE, null, null, false);
            object = Messages.getString("InterfaceMemberDialog.MethodChoice");
            this.mMemberTypeRow.add((String)object, "method");
            object = Messages.getString("InterfaceMemberDialog.AttributeChoice");
            this.mMemberTypeRow.add((String)object, "attribute");
            this.mMemberTypeRow.select(0);
            this.mMemberTypeRow.setFieldChangedListener(this);
            this.mData.setProperty("member_type", 2);
            this.mShowAttribute = true;
            string = new Label(object2, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            string.setLayoutData((Object)gridData);
        }
        this.mNameRow = new TextRow(composite, NAME, Messages.getString("InterfaceMemberDialog.Name"));
        if (this.mData != null && (object2 = (String)this.mData.getProperty("name")) != null) {
            this.mNameRow.setValue((String)object2);
        }
        this.mNameRow.setFieldChangedListener(this);
        object2 = Messages.getString("InterfaceMemberDialog.Type");
        if (this.mShowAttribute) {
            object2 = Messages.getString("InterfaceMemberDialog.ReturnType");
        }
        int n = 90;
        this.mTypeRow = new TypeRow(composite, TYPE, (String)object2, n |= 0x400);
        this.mTypeRow.includeSequences(true);
        this.mTypeRow.includeSimpleTypes(true);
        this.mTypeRow.setFieldChangedListener(this);
        if (this.mData != null && (object = this.mData.getProperty("type")) instanceof String) {
            string = (String)object;
            this.mTypeRow.setValue(string);
        }
    }

    protected void showSpecificControls(boolean bl) {
        if (this.mShowAttribute != bl) {
            Control[] controlArray = this.mSpecificPanel.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].dispose();
            }
            if (bl) {
                this.mShowAttribute = true;
                this.createAttributeControls(this.mSpecificPanel);
            } else {
                this.mShowAttribute = false;
                this.createMethodControls(this.mSpecificPanel);
            }
        }
        this.mSpecificPanel.layout();
    }

    protected void createAttributeControls(Composite composite) {
        Object object;
        this.mTypeRow.setLabel(Messages.getString("InterfaceMemberDialog.Type"));
        String string = Messages.getString("InterfaceMemberDialog.Readonly");
        this.mReadonlyRow = new BooleanRow(composite, READONLY, string);
        this.mReadonlyRow.setTooltip(Messages.getString("InterfaceMemberDialog.ReadonlyTooltip"));
        this.mReadonlyRow.setFieldChangedListener(this);
        this.mBoundRow = new BooleanRow(composite, BOUND, Messages.getString("InterfaceMemberDialog.Bound"));
        this.mBoundRow.setTooltip(Messages.getString("InterfaceMemberDialog.BoundTooltip"));
        this.mBoundRow.setFieldChangedListener(this);
        if (this.mData != null && (object = this.mData.getProperty("flags")) instanceof String) {
            String string2 = (String)object;
            this.mReadonlyRow.setValue(string2.contains("readonly"));
            this.mBoundRow.setValue(string2.contains("bound"));
        }
    }

    protected void createMethodControls(Composite composite) {
        this.mTypeRow.setLabel(Messages.getString("InterfaceMemberDialog.ReturnType"));
        Group group = new Group(composite, 32);
        group.setText(Messages.getString("InterfaceMemberDialog.ArgumentsTitle"));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout());
        Table table = new Table((Composite)group, 67588);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        table.setToolTipText(Messages.getString("InterfaceMemberDialog.ArgumentTableTooltip"));
        TableColumn tableColumn = new TableColumn(table, 16400);
        tableColumn.setText(Messages.getString("InterfaceMemberDialog.ArgumentNameColumnTitle"));
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(table, 16400);
        tableColumn.setText(Messages.getString("InterfaceMemberDialog.ArgumentTypeColumnTitle"));
        tableColumn.setWidth(170);
        tableColumn = new TableColumn(table, 16400);
        tableColumn.setWidth(70);
        tableColumn.setText(Messages.getString("InterfaceMemberDialog.ArgumentDirectionColumnTitle"));
        this.mArgumentTableViewer = new TableViewer(table);
        this.mArgumentTableViewer.setLabelProvider((IBaseLabelProvider)new ParamLabelProvider());
        this.mArgumentTableViewer.setContentProvider((IContentProvider)new ParamContentProvider());
        this.mArgumentTableViewer.setColumnProperties(new String[]{PARAM_NAME, PARAM_TYPE, PARAM_INOUT});
        int n = 90;
        TypeCellEditor typeCellEditor = new TypeCellEditor((Composite)table, n |= 0x400);
        typeCellEditor.includeSequences(true);
        typeCellEditor.includeSimpleTypes(true);
        typeCellEditor.includeVoid(false);
        this.mArgumentTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), typeCellEditor, new ComboBoxCellEditor((Composite)table, new String[]{"inout", "in", "out"})});
        this.mArgumentTableViewer.setCellModifier((ICellModifier)new ParamCellModifier());
        this.mArgumentTableViewer.setInput((Object)this.mData);
        this.createMethodButtons((Composite)group);
    }

    private void createMethodButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(64);
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.mAddButton = new Button(composite2, 0);
        this.mAddButton.setText(Messages.getString("InterfaceMemberDialog.New"));
        this.mAddButton.setLayoutData((Object)new GridData());
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UnoFactoryData unoFactoryData = new UnoFactoryData();
                unoFactoryData.setProperty("name", "arg");
                unoFactoryData.setProperty("type", "short");
                unoFactoryData.setProperty("argument_inout", "inout");
                InterfaceMemberDialog.this.mData.addInnerData(unoFactoryData);
                InterfaceMemberDialog.this.mArgumentTableViewer.add((Object)unoFactoryData);
            }
        });
        this.mDelButton = new Button(composite2, 0);
        this.mDelButton.setText(Messages.getString("InterfaceMemberDialog.Remove"));
        this.mDelButton.setLayoutData((Object)new GridData(544));
        this.mDelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection iSelection = InterfaceMemberDialog.this.mArgumentTableViewer.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    InterfaceMemberDialog.this.mData.removeInnerData((UnoFactoryData)object);
                    InterfaceMemberDialog.this.mArgumentTableViewer.remove(object);
                }
            }
        });
    }

    @Override
    public void fieldChanged(FieldEvent fieldEvent) {
        if (fieldEvent.getProperty().equals(MEMBER_TYPE)) {
            String string = this.mMemberTypeRow.getValue();
            if (string.equals("method")) {
                this.mData.setProperty("member_type", 2);
                this.showSpecificControls(false);
            } else {
                this.mData.setProperty("member_type", 1);
                this.showSpecificControls(true);
            }
        } else if (fieldEvent.getProperty().equals(NAME)) {
            this.mData.setProperty("name", fieldEvent.getValue().trim());
        } else if (fieldEvent.getProperty().equals(TYPE)) {
            this.mData.setProperty("type", fieldEvent.getValue().trim());
        } else if (fieldEvent.getProperty().equals(BOUND)) {
            this.toggleFlag("bound");
        } else if (fieldEvent.getProperty().equals(READONLY)) {
            this.toggleFlag("readonly");
        }
    }

    private void toggleFlag(String string) {
        String string2 = (String)this.mData.getProperty("flags");
        if (string2 != null && string2.contains(string)) {
            string2 = string2.replace(string, "").trim();
        } else {
            if (string2 == null) {
                string2 = "";
            }
            string2 = string2 + " " + string;
            string2 = string2.trim();
        }
        this.mData.setProperty("flags", string2);
    }

    class ParamLabelProvider
    implements ITableLabelProvider {
        ParamLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            UnoFactoryData unoFactoryData = (UnoFactoryData)object;
            switch (n) {
                case 0: {
                    string = (String)unoFactoryData.getProperty("name");
                    break;
                }
                case 1: {
                    string = (String)unoFactoryData.getProperty("type");
                    break;
                }
                case 2: {
                    string = (String)unoFactoryData.getProperty("argument_inout");
                }
            }
            return string;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return true;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    class ParamContentProvider
    implements IStructuredContentProvider {
        ParamContentProvider() {
        }

        public Object[] getElements(Object object) {
            return InterfaceMemberDialog.this.mData.getInnerData();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class ParamCellModifier
    implements ICellModifier {
        ParamCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return object instanceof UnoFactoryData && (string.equals(InterfaceMemberDialog.PARAM_TYPE) || string.equals(InterfaceMemberDialog.PARAM_NAME) || string.equals(InterfaceMemberDialog.PARAM_INOUT));
        }

        public Object getValue(Object object, String string) {
            Object object2 = null;
            if (object instanceof UnoFactoryData) {
                UnoFactoryData unoFactoryData = (UnoFactoryData)object;
                if (string.equals(InterfaceMemberDialog.PARAM_NAME)) {
                    object2 = unoFactoryData.getProperty("name");
                } else if (string.equals(InterfaceMemberDialog.PARAM_TYPE)) {
                    object2 = unoFactoryData.getProperty("type");
                } else if (string.equals(InterfaceMemberDialog.PARAM_INOUT)) {
                    String string2 = (String)unoFactoryData.getProperty("argument_inout");
                    if ("in".equals(string2)) {
                        object2 = 1;
                    } else if ("out".equals(string2)) {
                        object2 = 2;
                    } else if ("inout".equals(string2)) {
                        object2 = 0;
                    }
                }
            }
            if (object2 == null) {
                object2 = "";
            }
            return object2;
        }

        public void modify(Object object, String string, Object object2) {
            if (((TableItem)object).getData() instanceof UnoFactoryData) {
                UnoFactoryData unoFactoryData = (UnoFactoryData)((TableItem)object).getData();
                if (string.equals(InterfaceMemberDialog.PARAM_NAME) && object2 instanceof String) {
                    unoFactoryData.setProperty("name", object2);
                    InterfaceMemberDialog.this.mArgumentTableViewer.setInput((Object)InterfaceMemberDialog.this.mData);
                } else if (string.equals(InterfaceMemberDialog.PARAM_TYPE) && object2 instanceof String) {
                    unoFactoryData.setProperty("type", object2);
                    InterfaceMemberDialog.this.mArgumentTableViewer.setInput((Object)InterfaceMemberDialog.this.mData);
                } else if (string.equals(InterfaceMemberDialog.PARAM_INOUT) && object2 instanceof Integer) {
                    String string2 = this.getDirectionFromId((Integer)object2);
                    unoFactoryData.setProperty("argument_inout", string2);
                    InterfaceMemberDialog.this.mArgumentTableViewer.setInput((Object)InterfaceMemberDialog.this.mData);
                }
            }
        }

        private String getDirectionFromId(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "inout";
                    break;
                }
                case 1: {
                    string = "in";
                    break;
                }
                case 2: {
                    string = "out";
                }
            }
            return string;
        }
    }
}

