/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import java.util.Vector;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.gui.AbstractTable;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.InterfaceMemberDialog;

public class InterfaceMembersTable
extends AbstractTable {
    private static final String TYPE = "__type";
    private static final String NAME = "__name";
    private static final String OPTIONS = "__options";
    private static final int NAME_WIDTH = 100;
    private static final int TYPE_WIDTH = 50;
    private static final int OPTIONS_WIDTH = 300;

    public InterfaceMembersTable(Composite composite) {
        super(composite, Messages.getString("InterfaceMembersTable.Title"), new String[]{Messages.getString("InterfaceMembersTable.NameColumnTitle"), Messages.getString("InterfaceMembersTable.TypeColumnTitle"), Messages.getString("InterfaceMembersTable.FlagsColumnTitle")}, new int[]{100, 50, 300}, new String[]{NAME, TYPE, OPTIONS});
    }

    public UnoFactoryData[] getUnoFactoryData() {
        Vector<ITableElement> vector = this.getLines();
        int n = vector.size();
        UnoFactoryData[] unoFactoryDataArray = new UnoFactoryData[n];
        for (int i = 0; i < n; ++i) {
            unoFactoryDataArray[i] = ((MemberLine)vector.get(i)).mData;
        }
        return unoFactoryDataArray;
    }

    @Override
    protected ITableElement addLine() {
        MemberLine memberLine = null;
        UnoFactoryData unoFactoryData = this.openDialog(null);
        if (unoFactoryData != null) {
            memberLine = new MemberLine(unoFactoryData);
        }
        return memberLine;
    }

    @Override
    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection;
        Object object;
        super.handleDoubleClick(doubleClickEvent);
        if (this.getSelection() instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)this.getSelection()).getFirstElement()) instanceof MemberLine) {
            MemberLine memberLine = (MemberLine)object;
            UnoFactoryData unoFactoryData = this.openDialog(memberLine.mData);
            memberLine.mData = unoFactoryData;
            this.mTableViewer.refresh((Object)memberLine);
        }
    }

    protected UnoFactoryData openDialog(UnoFactoryData unoFactoryData) {
        UnoFactoryData unoFactoryData2 = unoFactoryData;
        InterfaceMemberDialog interfaceMemberDialog = unoFactoryData == null ? new InterfaceMemberDialog() : new InterfaceMemberDialog(unoFactoryData);
        if (0 == interfaceMemberDialog.open()) {
            unoFactoryData2 = interfaceMemberDialog.getData();
        } else if (unoFactoryData == null) {
            interfaceMemberDialog.disposeData();
        }
        return unoFactoryData2;
    }

    class MemberLine
    implements ITableElement {
        private UnoFactoryData mData;

        public MemberLine() {
            this.mData = new UnoFactoryData();
        }

        public MemberLine(UnoFactoryData unoFactoryData) {
            this.mData = unoFactoryData;
        }

        @Override
        public boolean canModify(String string) {
            return false;
        }

        @Override
        public Image getImage(String string) {
            Image image = null;
            if (string.equals(InterfaceMembersTable.NAME)) {
                int n = (Integer)this.mData.getProperty("member_type");
                if (n == 1) {
                    image = OOEclipsePlugin.getImage("ATTRIBUTE");
                } else if (n == 2) {
                    image = OOEclipsePlugin.getImage("METHOD");
                }
            }
            return image;
        }

        @Override
        public String getLabel(String string) {
            String string2 = null;
            if (string.equals(InterfaceMembersTable.TYPE)) {
                String string3;
                string2 = string3 = (String)this.mData.getProperty("type");
            } else if (string.equals(InterfaceMembersTable.NAME)) {
                String string4;
                string2 = string4 = (String)this.mData.getProperty("name");
            } else if (string.equals(InterfaceMembersTable.OPTIONS)) {
                int n = (Integer)this.mData.getProperty("member_type");
                if (n == 1) {
                    string2 = (String)this.mData.getProperty("flags");
                } else if (n == 2) {
                    UnoFactoryData[] unoFactoryDataArray = this.mData.getInnerData();
                    string2 = "";
                    for (int i = 0; i < unoFactoryDataArray.length; ++i) {
                        String string5 = (String)unoFactoryDataArray[i].getProperty("name");
                        if (string5 == null) continue;
                        string2 = string2 + string5 + " ";
                    }
                }
            }
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public String[] getProperties() {
            return new String[]{InterfaceMembersTable.TYPE, InterfaceMembersTable.NAME, InterfaceMembersTable.OPTIONS};
        }

        @Override
        public Object getValue(String string) {
            return null;
        }

        @Override
        public void setValue(String string, Object object) {
        }
    }
}

