/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.gui.AbstractTable;
import org.libreoffice.ide.eclipse.core.gui.ITableElement;
import org.libreoffice.ide.eclipse.core.unotypebrowser.InternalUnoType;
import org.libreoffice.ide.eclipse.core.unotypebrowser.UnoTypeBrowser;
import org.libreoffice.ide.eclipse.core.wizards.Messages;

public class InterfacesTable
extends AbstractTable {
    private static final int OPTIONAL_WIDTH = 25;
    private static final int NAME_WIDTH = 400;

    public InterfacesTable(Composite composite) {
        super(composite, Messages.getString("InterfacesTable.Title"), new String[]{Messages.getString("InterfacesTable.OptionalTitle"), Messages.getString("InterfacesTable.NameTitle")}, new int[]{25, 400}, new String[]{"__optional", "__name"});
    }

    public void addInterface(String string, boolean bl) {
        InheritanceLine inheritanceLine = new InheritanceLine();
        inheritanceLine.mInterfaceName = string;
        inheritanceLine.mOptional = bl;
        this.addLine(inheritanceLine);
    }

    @Override
    protected CellEditor[] createCellEditors(Table table) {
        CellEditor[] cellEditorArray = new CellEditor[]{new CheckboxCellEditor(), null};
        return cellEditorArray;
    }

    @Override
    protected ITableElement addLine() {
        InheritanceLine inheritanceLine = null;
        UnoTypeBrowser unoTypeBrowser = new UnoTypeBrowser(this.getShell(), 2);
        if (0 == unoTypeBrowser.open()) {
            String string = null;
            InternalUnoType internalUnoType = unoTypeBrowser.getSelectedType();
            if (null != internalUnoType) {
                string = internalUnoType.getFullName();
            }
            inheritanceLine = new InheritanceLine();
            inheritanceLine.setInterfaceName(string);
        }
        return inheritanceLine;
    }

    public class InheritanceLine
    implements ITableElement {
        public static final String OPTIONAL = "__optional";
        public static final String NAME = "__name";
        private String mInterfaceName;
        private boolean mOptional = false;

        public String getInterfaceName() {
            return this.mInterfaceName;
        }

        public boolean isOptional() {
            return this.mOptional;
        }

        public void setInterfaceName(String string) {
            this.mInterfaceName = string;
        }

        public void setOptional(boolean bl) {
            this.mOptional = bl;
        }

        @Override
        public Image getImage(String string) {
            Image image = null;
            if (string.equals(OPTIONAL)) {
                image = this.isOptional() ? OOEclipsePlugin.getImage("CHECKED") : OOEclipsePlugin.getImage("UNCHECKED");
            }
            return image;
        }

        @Override
        public String getLabel(String string) {
            String string2 = null;
            if (string.equals(NAME)) {
                string2 = this.getInterfaceName().toString();
            }
            return string2;
        }

        @Override
        public String[] getProperties() {
            return new String[]{OPTIONAL, NAME};
        }

        @Override
        public boolean canModify(String string) {
            return string.equals(OPTIONAL);
        }

        @Override
        public Object getValue(String string) {
            Boolean bl = null;
            if (string.equals(OPTIONAL)) {
                bl = this.isOptional();
            }
            return bl;
        }

        @Override
        public void setValue(String string, Object object) {
            if (string.equals(OPTIONAL) && object instanceof Boolean) {
                this.setOptional((Boolean)object);
            }
        }
    }
}

