/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.ManifestExportPageController;
import org.libreoffice.plugin.core.model.UnoPackage;

public class ManifestExportPage
extends WizardPage {
    public static final int HORIZONTAL_INDENT = 20;
    public static final String MANIFEST_FILENAME = "manifest.xml";
    private static final int LAYOUT_COLS = 3;
    private IUnoidlProject mProject;
    private Button mGenerateManifestBtn;
    private Button mReuseManifestBtn;
    private Button mSaveManifestBtn;
    private Label mSaveRowLbl;
    private Text mSaveRowTxt;
    private Button mSaveRowBtn;
    private Label mLoadRowLbl;
    private Text mLoadRowTxt;
    private Button mLoadRowBtn;
    private ManifestExportPageController mController = new ManifestExportPageController();

    public ManifestExportPage(String string, IUnoidlProject iUnoidlProject) {
        super(string);
        this.setTitle(Messages.getString("ManifestExportPage.Title"));
        this.setDescription(Messages.getString("ManifestExportPage.Description"));
        this.mProject = iUnoidlProject;
    }

    public void setProject(IUnoidlProject iUnoidlProject) {
        this.mProject = iUnoidlProject;
    }

    public IUnoidlProject getProject() {
        return this.mProject;
    }

    public void configureManifest(UnoPackage unoPackage) {
        IFile iFile;
        IFile iFile2 = this.getSaveManifestFile();
        if (iFile2 != null) {
            unoPackage.setCopyManifestFileTo(SystemHelper.getFile((IResource)iFile2));
        }
        if ((iFile = this.getReadManifestFile()) != null) {
            unoPackage.setReadManifestFile(SystemHelper.getFile((IResource)iFile));
        }
    }

    public void setManifestPath(IFile iFile) {
        this.mController.setGenerateManifest(true);
        this.mController.setSaveManifest(true);
        this.mController.setSaveManifestPath(iFile.getFullPath().toString());
        this.updateControls();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite2);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("ManifestExportPage.DefineManifestText"));
        this.createOptionsGroup(composite2);
        this.updateControls();
    }

    private void updateControls() {
        this.mGenerateManifestBtn.setSelection(this.mController.getGenerateManifest());
        this.mSaveManifestBtn.setSelection(this.mController.getSaveManifest());
        this.mSaveManifestBtn.setEnabled(this.mController.isSaveManifestEnabled());
        this.mSaveRowTxt.setText(this.mController.getSaveManifestPath());
        this.mSaveRowLbl.setEnabled(this.mController.isSaveManifestPathEnabled());
        this.mSaveRowTxt.setEnabled(this.mController.isSaveManifestPathEnabled());
        this.mSaveRowBtn.setEnabled(this.mController.isSaveManifestPathEnabled());
        this.mReuseManifestBtn.setSelection(!this.mController.getGenerateManifest());
        this.mLoadRowTxt.setText(this.mController.getLoadManifestPath());
        this.mLoadRowLbl.setEnabled(this.mController.isLoadManifestPathEnabled());
        this.mLoadRowTxt.setEnabled(this.mController.isLoadManifestPathEnabled());
        this.mLoadRowBtn.setEnabled(this.mController.isLoadManifestPathEnabled());
    }

    private void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalIndent = 20;
        composite2.setLayoutData((Object)gridData);
        this.mGenerateManifestBtn = new Button(composite2, 16);
        this.mGenerateManifestBtn.setText(Messages.getString("ManifestExportPage.GenerateManifestText"));
        this.mGenerateManifestBtn.setLayoutData((Object)new GridData(4, 1, true, false));
        this.mGenerateManifestBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManifestExportPage.this.mController.setGenerateManifest(ManifestExportPage.this.mGenerateManifestBtn.getSelection());
                ManifestExportPage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalIndent = 20;
        composite3.setLayoutData((Object)gridData);
        this.createManifestSaveOptions(composite3);
        this.mReuseManifestBtn = new Button(composite2, 16);
        this.mReuseManifestBtn.setText(Messages.getString("ManifestExportPage.UserManifestText"));
        this.mReuseManifestBtn.setLayoutData((Object)new GridData(4, 1, true, false));
        this.mReuseManifestBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManifestExportPage.this.mController.setGenerateManifest(!ManifestExportPage.this.mReuseManifestBtn.getSelection());
                ManifestExportPage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData(4, 1, true, false);
        gridData.horizontalIndent = 20;
        composite4.setLayoutData((Object)gridData);
        this.createManifestLoadRow(composite4);
    }

    private void createManifestSaveOptions(Composite composite) {
        this.mSaveManifestBtn = new Button(composite, 32);
        this.mSaveManifestBtn.setText(Messages.getString("ManifestExportPage.SaveManifestText"));
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 3;
        this.mSaveManifestBtn.setLayoutData((Object)gridData);
        this.mSaveManifestBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManifestExportPage.this.mController.setSaveManifest(ManifestExportPage.this.mSaveManifestBtn.getSelection());
                ManifestExportPage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        this.mSaveRowLbl = new Label(composite, 0);
        this.mSaveRowLbl.setText(Messages.getString("ManifestExportPage.SaveRowLabel"));
        this.mSaveRowLbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.mSaveRowTxt = new Text(composite, 2052);
        this.mSaveRowTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mSaveRowTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ManifestExportPage.this.mController.setSaveManifestPath(ManifestExportPage.this.mSaveRowTxt.getText());
            }
        });
        this.mSaveRowBtn = new Button(composite, 8);
        this.mSaveRowBtn.setText(Messages.getString("ManifestExportPage.Browse"));
        this.mSaveRowBtn.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.mSaveRowBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SaveAsDialog saveAsDialog = new SaveAsDialog(ManifestExportPage.this.getShell());
                saveAsDialog.setOriginalName(ManifestExportPage.MANIFEST_FILENAME);
                saveAsDialog.setOriginalFile(ManifestExportPage.this.mProject.getFile(ManifestExportPage.MANIFEST_FILENAME));
                saveAsDialog.create();
                saveAsDialog.getShell().setText(Messages.getString("ManifestExportPage.SaveDialogTitle"));
                saveAsDialog.setMessage(Messages.getString("ManifestExportPage.SaveDialogMessage"));
                if (saveAsDialog.open() == 0) {
                    ManifestExportPage.this.mController.setSaveManifestPath(saveAsDialog.getResult().toString());
                    ManifestExportPage.this.updateControls();
                }
            }
        });
    }

    private void createManifestLoadRow(Composite composite) {
        this.mLoadRowLbl = new Label(composite, 0);
        this.mLoadRowLbl.setText(Messages.getString("ManifestExportPage.LoadRowLabel"));
        this.mLoadRowLbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.mLoadRowTxt = new Text(composite, 2052);
        this.mLoadRowTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mLoadRowTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ManifestExportPage.this.mController.setLoadManifestPath(ManifestExportPage.this.mLoadRowTxt.getText());
            }
        });
        this.mLoadRowBtn = new Button(composite, 8);
        this.mLoadRowBtn.setText(Messages.getString("ManifestExportPage.Browse"));
        this.mLoadRowBtn.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.mLoadRowBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(ManifestExportPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                elementTreeSelectionDialog.setAllowMultiple(false);
                elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] objectArray) {
                        Status status = new Status(4, "org.libreoffice.ide.eclipse.core", new String());
                        if (objectArray.length == 1 && objectArray[0] instanceof IFile) {
                            status = new Status(0, "org.libreoffice.ide.eclipse.core", new String());
                        }
                        return status;
                    }
                });
                elementTreeSelectionDialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object object, Object object2) {
                        boolean bl = true;
                        if (object2 instanceof IResource) {
                            IResource iResource = (IResource)object2;
                            bl &= !iResource.getName().startsWith(".");
                            bl &= iResource instanceof IContainer || iResource.getName().equals(ManifestExportPage.MANIFEST_FILENAME);
                        }
                        return bl;
                    }
                });
                elementTreeSelectionDialog.setTitle(Messages.getString("ManifestExportPage.LoadDialogTitle"));
                elementTreeSelectionDialog.setMessage(Messages.getString("ManifestExportPage.LoadDialogMessage"));
                elementTreeSelectionDialog.setStatusLineAboveButtons(true);
                elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                elementTreeSelectionDialog.setInitialSelection((Object)ManifestExportPage.this.getProject().getFile(ManifestExportPage.MANIFEST_FILENAME));
                if (elementTreeSelectionDialog.open() == 0) {
                    Object object = elementTreeSelectionDialog.getFirstResult();
                    IFile iFile = (IFile)object;
                    ManifestExportPage.this.mController.setLoadManifestPath(iFile.getFullPath().toString());
                    ManifestExportPage.this.updateControls();
                }
            }
        });
    }

    private IFile getReadManifestFile() {
        IFile iFile = null;
        if (!this.mController.getGenerateManifest()) {
            Path path = new Path(this.mController.getLoadManifestPath().trim());
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return iFile;
    }

    private IFile getSaveManifestFile() {
        IFile iFile = null;
        if (this.mController.isSaveManifestPathEnabled()) {
            Path path = new Path(this.mController.getSaveManifestPath().trim());
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return iFile;
    }
}

