/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.rows.BooleanRow;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.unotypebrowser.UnoTypeProvider;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.utils.IListenablePage;
import org.libreoffice.ide.eclipse.core.wizards.utils.IPageListener;

public abstract class NewScopedElementWizardPage
extends WizardPage
implements IFieldChangedListener,
IListenablePage {
    private static final String P_PACKAGE = "__package";
    private static final String P_NAME = "__name";
    private static final String P_PUBLISHED = "__published";
    private IUnoidlProject mUnoProject;
    private String mRootName;
    private String mSubpackageName;
    private String mElementName;
    private Vector<IPageListener> mListeners = new Vector();
    private TextRow mPackageRow;
    private TextRow mNameRow;
    private BooleanRow mPublishedRow;

    public NewScopedElementWizardPage(String string) {
        this(string, "", "");
    }

    public NewScopedElementWizardPage(String string, IUnoidlProject iUnoidlProject) {
        this(string, iUnoidlProject, "", "");
    }

    public NewScopedElementWizardPage(String string, IUnoidlProject iUnoidlProject, String string2, String string3) {
        this(string, string2, string3);
        this.setUnoidlProject(iUnoidlProject);
    }

    public NewScopedElementWizardPage(String string, IOOo iOOo) {
        this(string, "", "", iOOo);
    }

    public NewScopedElementWizardPage(String string, String string2, String string3, IOOo iOOo) {
        this(string, string2, string3);
        this.setOOoInstance(iOOo);
    }

    private NewScopedElementWizardPage(String string, String string2, String string3) {
        super(string);
        this.setTitle(this.getTitle());
        this.setDescription(this.getDescription());
        this.setImageDescriptor(this.getImageDescriptor());
        this.mRootName = "";
        if (null != string2) {
            this.mRootName = string2;
        }
        this.mElementName = "";
        if (null != string3) {
            this.mElementName = string3;
        }
        this.mSubpackageName = "";
    }

    public IUnoidlProject getProject() {
        return this.mUnoProject;
    }

    protected abstract String getTypeLabel();

    protected abstract ImageDescriptor getImageDescriptor();

    protected abstract void createSpecificControl(Composite var1);

    public abstract int getProvidedTypes();

    public void setOOoInstance(IOOo iOOo) {
        if (iOOo != null) {
            UnoTypeProvider unoTypeProvider = UnoTypeProvider.getInstance();
            unoTypeProvider.setOOoInstance(iOOo);
        }
    }

    public void setUnoidlProject(IUnoidlProject iUnoidlProject) {
        this.mUnoProject = iUnoidlProject;
        UnoTypeProvider unoTypeProvider = UnoTypeProvider.getInstance();
        unoTypeProvider.setProject(this.mUnoProject);
    }

    public String getPackageRoot() {
        String string = "";
        if (this.mUnoProject != null) {
            string = this.mUnoProject.getRootModule();
        }
        if (this.mRootName != null && !this.mRootName.equals("")) {
            if (!string.equals("")) {
                string = string + "::";
            }
            string = this.mRootName.replaceAll("\\.", "::");
        }
        return string;
    }

    public String getPackage() {
        String string = this.getPackageRoot();
        if (this.mPackageRow != null && !this.mPackageRow.getValue().equals("")) {
            if (!string.equals("")) {
                string = string + "::";
            }
            string = string + this.mPackageRow.getValue();
        }
        return string;
    }

    public String getElementName() {
        return this.mElementName;
    }

    public void setPackageRoot(String string) {
        String string2 = Messages.getString("NewScopedElementWizardPage.Package") + string;
        this.mRootName = string;
        if (this.mPackageRow != null) {
            this.mPackageRow.setLabel(string2);
        }
    }

    public void setPackage(String string, boolean bl) {
        String string2 = "::";
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if (this.mPackageRow != null) {
            this.mPackageRow.setValue(string);
            this.mPackageRow.setEnabled(!bl);
        } else {
            this.mSubpackageName = string;
        }
    }

    public void setName(String string, boolean bl) {
        this.mElementName = string;
        if (this.mNameRow != null) {
            string = string.replace(" ", "");
            this.mNameRow.setValue(string);
            this.mNameRow.setEnabled(!bl);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPublished() {
        boolean bl = false;
        if (this.mPublishedRow != null) {
            bl = this.mPublishedRow.getBooleanValue();
        }
        return bl;
    }

    public void setPublished(boolean bl, boolean bl2) {
        this.mPublishedRow.setValue(bl);
        this.mPublishedRow.setEnabled(!bl2);
    }

    public void dispose() {
        try {
            this.mPackageRow.removeFieldChangedlistener();
            this.mNameRow.removeFieldChangedlistener();
            this.mPublishedRow.removeFieldChangedlistener();
        }
        catch (NullPointerException nullPointerException) {
            PluginLogger.debug(nullPointerException.getMessage());
        }
        super.dispose();
    }

    @Override
    public void addPageListener(IPageListener iPageListener) {
        if (!this.mListeners.contains(iPageListener)) {
            this.mListeners.add(iPageListener);
        }
    }

    @Override
    public void removePageListener(IPageListener iPageListener) {
        if (this.mListeners.contains(iPageListener)) {
            this.mListeners.remove(iPageListener);
        }
    }

    protected void firePageChanged(UnoFactoryData unoFactoryData) {
        int n = this.mListeners.size();
        for (int i = 0; i < n; ++i) {
            this.mListeners.get(i).pageChanged(unoFactoryData);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        String string = Messages.getString("NewScopedElementWizardPage.Package");
        if (null != this.mUnoProject) {
            string = string + this.mUnoProject.getRootModule();
        } else if (this.mRootName != null) {
            string = string + this.mRootName;
        }
        this.mPackageRow = new TextRow(composite2, P_PACKAGE, string);
        this.mPackageRow.setFieldChangedListener(this);
        this.mPackageRow.setValue(this.mSubpackageName);
        this.mPackageRow.setTooltip(Messages.getString("NewScopedElementWizardPage.PackageTooltip"));
        this.mNameRow = new TextRow(composite2, P_NAME, this.getTypeLabel());
        this.mNameRow.setFieldChangedListener(this);
        this.mNameRow.setValue(this.mElementName);
        this.mNameRow.setTooltip(Messages.getString("NewScopedElementWizardPage.TypeNameTooltip"));
        this.createSpecificControl(composite2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        this.mPublishedRow = new BooleanRow(composite3, P_PUBLISHED, Messages.getString("NewScopedElementWizardPage.Published"));
        this.mPublishedRow.setFieldChangedListener(this);
        this.setPageComplete(this.isPageComplete());
        composite2.layout();
        this.setControl((Control)composite2);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public UnoFactoryData fillData(UnoFactoryData unoFactoryData) {
        if (unoFactoryData != null) {
            unoFactoryData.setProperty("package_name", this.getPackage());
            unoFactoryData.setProperty("type_name", this.getElementName());
            unoFactoryData.setProperty("type_published", this.isPublished());
        }
        return unoFactoryData;
    }

    public abstract UnoFactoryData getEmptyTypeData();

    public static UnoFactoryData getTypeData(UnoFactoryData unoFactoryData) {
        UnoFactoryData unoFactoryData2 = new UnoFactoryData();
        if (unoFactoryData != null) {
            try {
                String string = (String)unoFactoryData.getProperty("project_name");
                string = string.substring(0, 1).toUpperCase() + string.substring(1);
                string = string.replace(" ", "");
                String string2 = (String)unoFactoryData.getProperty("project_prefix");
                string2 = string2.replace(".", "::");
                unoFactoryData2.setProperty("type_name", string);
                unoFactoryData2.setProperty("package_name", string2);
                unoFactoryData2.setProperty("type_published", Boolean.FALSE);
            }
            catch (Exception exception) {
                unoFactoryData2 = null;
            }
        }
        return unoFactoryData2;
    }

    @Override
    public void fieldChanged(FieldEvent fieldEvent) {
        String[] stringArray;
        UnoFactoryData unoFactoryData = null;
        try {
            if (fieldEvent.getProperty().equals(P_PACKAGE)) {
                unoFactoryData = this.getEmptyTypeData();
                unoFactoryData.setProperty("package_name", this.getPackage());
            } else if (fieldEvent.getProperty().equals(P_NAME)) {
                this.mElementName = fieldEvent.getValue();
                stringArray = new String[]{this.getProject().getTypesPath().toOSString(), this.getProject().getOOo().getName()};
                boolean bl = UnoTypeProvider.getInstance().contains(fieldEvent.getValue(), stringArray);
                if (bl) {
                    this.setErrorMessage(Messages.getString("NewScopedElementWizardPage.NameExistsError"));
                } else {
                    this.setErrorMessage(null);
                    unoFactoryData = this.getEmptyTypeData();
                    unoFactoryData.setProperty("type_name", fieldEvent.getValue());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (unoFactoryData != null) {
            stringArray = new UnoFactoryData();
            try {
                String string = this.getProject().getName();
                String string2 = this.getProject().getCompanyPrefix();
                IOOo iOOo = this.getProject().getOOo();
                stringArray.setProperty("project_name", string);
                stringArray.setProperty("project_ooo", iOOo);
                stringArray.setProperty("project_prefix", string2);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            stringArray.addInnerData(unoFactoryData);
            this.firePageChanged((UnoFactoryData)stringArray);
            this.setPageComplete(this.isPageComplete());
        }
    }

    public boolean isPageComplete() {
        String string = this.getPackage() + "::" + this.getElementName();
        boolean bl = !NewScopedElementWizardPage.existsIdlFile(string, this.getProject());
        try {
            if (!this.mNameRow.getValue().matches("[A-Za-z_][A-Za-z_0-9]*")) {
                bl = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    public static boolean existsIdlFile(String string, IUnoidlProject iUnoidlProject) {
        boolean bl = false;
        if (iUnoidlProject != null) {
            try {
                IPath iPath = iUnoidlProject.getIdlPath();
                String string2 = string.replace("::", "/");
                iPath = iPath.append(string2 + ".idl");
                iPath = iUnoidlProject.getProjectPath().append(iPath);
                bl = iPath.toFile().exists();
            }
            catch (Exception exception) {
                String string3 = Messages.getString("ServiceWizardSet.IsIdlTypeExistingWarning");
                String string4 = MessageFormat.format(string3, string);
                PluginLogger.warning(string4, exception);
            }
        }
        return bl;
    }
}

