/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.TypeRow;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.NewScopedElementWizardPage;

public class NewServiceWizardPage
extends NewScopedElementWizardPage {
    private static final String P_IFACE_INHERITANCE = "__iface_inheritance";
    private TypeRow mIfaceInheritanceRow;
    private String mInheritedInterface;
    private boolean mChanging = false;
    private boolean mInheritanceChanged = false;

    public NewServiceWizardPage(String string, IUnoidlProject iUnoidlProject) {
        super(string, iUnoidlProject);
    }

    public NewServiceWizardPage(String string, IUnoidlProject iUnoidlProject, String string2, String string3) {
        super(string, iUnoidlProject, string2, string3);
    }

    @Override
    public int getProvidedTypes() {
        return 2;
    }

    @Override
    public void createSpecificControl(Composite composite) {
        this.mIfaceInheritanceRow = new TypeRow(composite, P_IFACE_INHERITANCE, Messages.getString("NewServiceWizardPage.InheritedInterface"), 2);
        if (this.mInheritedInterface != null) {
            this.mIfaceInheritanceRow.setValue(this.mInheritedInterface);
        }
        this.mIfaceInheritanceRow.setFieldChangedListener(this);
        this.mIfaceInheritanceRow.setTooltip(Messages.getString("NewServiceWizardPage.InheritanceTooltip"));
    }

    public String getTitle() {
        return Messages.getString("NewServiceWizardPage.Title");
    }

    public String getDescription() {
        return Messages.getString("NewServiceWizardPage.ServiceDescription");
    }

    @Override
    protected String getTypeLabel() {
        return Messages.getString("NewServiceWizardPage.Type");
    }

    @Override
    protected ImageDescriptor getImageDescriptor() {
        return OOEclipsePlugin.getImageDescriptor("NEW_SERVICE_IMAGE");
    }

    @Override
    public void fieldChanged(FieldEvent fieldEvent) {
        super.fieldChanged(fieldEvent);
        if (fieldEvent.getProperty().equals(P_IFACE_INHERITANCE) && !this.mChanging) {
            this.mInheritanceChanged = true;
        }
    }

    public String getInheritanceName() {
        String string = "";
        if (this.mIfaceInheritanceRow != null) {
            string = this.mIfaceInheritanceRow.getValue();
        }
        return string;
    }

    public void setInheritanceName(String string, boolean bl) {
        if (string.matches("([a-zA-Z][a-zA-Z0-9]*)(::[a-zA-Z][a-zA-Z0-9]*)*")) {
            if (this.mIfaceInheritanceRow != null) {
                this.mChanging = true;
                this.mIfaceInheritanceRow.setValue(string);
                this.mIfaceInheritanceRow.setEnabled(!bl);
                this.mInheritanceChanged = false;
                this.mChanging = false;
            } else {
                this.mInheritedInterface = string;
            }
        }
    }

    public boolean isInheritanceChanged() {
        return this.mInheritanceChanged;
    }

    @Override
    public UnoFactoryData fillData(UnoFactoryData unoFactoryData) {
        if ((unoFactoryData = super.fillData(unoFactoryData)) != null) {
            unoFactoryData.setProperty("type_nature", 4);
            unoFactoryData.setProperty("inherited_interfaces", new String[]{this.getInheritanceName().replace(".", "::")});
        }
        return unoFactoryData;
    }

    @Override
    public UnoFactoryData getEmptyTypeData() {
        UnoFactoryData unoFactoryData = new UnoFactoryData();
        if (unoFactoryData != null) {
            unoFactoryData.setProperty("type_nature", 4);
        }
        return unoFactoryData;
    }
}

