/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.gui.OOoConfigPanel;
import org.libreoffice.ide.eclipse.core.gui.rows.BooleanRow;
import org.libreoffice.ide.eclipse.core.gui.rows.ChoiceRow;
import org.libreoffice.ide.eclipse.core.gui.rows.FieldEvent;
import org.libreoffice.ide.eclipse.core.gui.rows.IFieldChangedListener;
import org.libreoffice.ide.eclipse.core.gui.rows.TextRow;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.language.AbstractLanguage;
import org.libreoffice.ide.eclipse.core.model.language.LanguagesHelper;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.NewUnoProjectWizard;

public class NewUnoProjectPage
extends WizardNewProjectCreationPage
implements IFieldChangedListener {
    private static final String PREFIX = "__prefix";
    private static final String OUTPUT_EXT = "__output_ext";
    private static final String LANGUAGE = "__language";
    private static final String CUSTOM_DIRS = "__custom_dirs";
    private static final String CUSTOM_SRC = "__custom_src";
    private static final String CUSTOM_IDL = "__custom_idl";
    private static final int TASK_UNITS = 2000;
    private static final int SUBTASK_UNIT = 1000;
    private TextRow mPrefixRow;
    private TextRow mOutputExt;
    private ChoiceRow mLanguageRow;
    private BooleanRow mCustomDirsRow;
    private TextRow mSourceRow;
    private TextRow mIdlDirRow;
    private Vector<Text> mListenedTexts = new Vector();
    private IProject mNewProject;
    private IUnoidlProject mUnoProject = null;
    private ModifyListener mModifListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            NewUnoProjectPage.this.checkWhiteSpaces();
            NewUnoProjectPage.this.checkSpecialSymbolsinProjectName();
            ((NewUnoProjectWizard)NewUnoProjectPage.this.getWizard()).pageChanged((IWizardPage)NewUnoProjectPage.this);
        }
    };
    private OOoConfigPanel mOOoConfigPanel;

    public NewUnoProjectPage(String string) {
        super(string);
        this.setTitle(Messages.getString("NewUnoProjectPage.Title"));
        this.setDescription(Messages.getString("NewUnoProjectPage.Message"));
        this.setImageDescriptor(OOEclipsePlugin.getImageDescriptor("NEWPROJECT_WIZ"));
    }

    public void dispose() {
        int n = this.mListenedTexts.size();
        for (int i = 0; i < n; ++i) {
            Text text = this.mListenedTexts.get(i);
            if (text.isDisposed()) continue;
            text.removeModifyListener(this.mModifListener);
        }
        this.mListenedTexts.clear();
        super.dispose();
    }

    public String getPrefix() {
        String string = "";
        if (null != this.mPrefixRow) {
            string = this.mPrefixRow.getValue();
        }
        return string;
    }

    public String getOutputExt() {
        String string = "";
        if (null != this.mOutputExt) {
            string = this.mOutputExt.getValue();
        }
        return string;
    }

    public AbstractLanguage getChosenLanguage() {
        AbstractLanguage abstractLanguage = null;
        if (this.mLanguageRow != null) {
            String string = this.mLanguageRow.getValue();
            abstractLanguage = LanguagesHelper.getLanguageFromName(string);
        }
        return abstractLanguage;
    }

    public String getOOoName() {
        return this.mOOoConfigPanel.getOOoName();
    }

    private IProject createNewProject() {
        if (this.mNewProject == null) {
            final IProject iProject = this.getProjectHandle();
            IPath iPath = null;
            if (!this.useDefaults()) {
                iPath = this.getLocationPath();
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
            iProjectDescription.setLocation(iPath);
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    NewUnoProjectPage.this.createProject(iProjectDescription, iProject, iProgressMonitor);
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
                this.mNewProject = iProject;
            }
            catch (InterruptedException interruptedException) {
                this.mNewProject = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                PluginLogger.error(throwable.toString(), throwable);
                String string = Messages.getString("NewUnoProjectPage.ProjectCreationError");
                ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)((CoreException)throwable).getStatus());
                this.mNewProject = null;
            }
        }
        return this.mNewProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createProject(IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            iProgressMonitor.beginTask("", 2000);
            iProject.create(iProjectDescription, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1000));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProject.open(128, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1000));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = (Composite)this.getControl();
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new GridLayout());
        this.addTextListener((Control)composite2);
        Group group = new Group(composite3, 0);
        group.setText(Messages.getString("NewUnoProjectPage.UnoGroupTitle"));
        group.setFont(composite.getFont());
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.mPrefixRow = new TextRow((Composite)group, PREFIX, Messages.getString("NewUnoProjectPage.RootPackage"));
        this.mPrefixRow.setValue("org.libreoffice.example");
        this.mPrefixRow.setFieldChangedListener(this);
        this.mPrefixRow.setTooltip(Messages.getString("NewUnoProjectPage.RootPackageTooltip"));
        this.mOutputExt = new TextRow((Composite)group, OUTPUT_EXT, Messages.getString("NewUnoProjectPage.CompExtension"));
        this.mOutputExt.setValue("comp");
        this.mOutputExt.setFieldChangedListener(this);
        this.mOutputExt.setTooltip(Messages.getString("NewUnoProjectPage.CompExtensionTooltip"));
        this.mLanguageRow = new ChoiceRow((Composite)group, LANGUAGE, Messages.getString("NewUnoProjectPage.Language"), null, false);
        this.mLanguageRow.setTooltip(Messages.getString("NewUnoProjectPage.LanguageTooltip"));
        String[] stringArray = LanguagesHelper.getAvailableLanguageNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mLanguageRow.add(stringArray[i]);
        }
        this.mLanguageRow.select(0);
        this.mLanguageRow.setFieldChangedListener(this);
        this.mOOoConfigPanel = new OOoConfigPanel(composite3);
        this.addCustomDirsControls(composite3);
    }

    private void addCustomDirsControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.getString("NewUnoProjectPage.LayoutGroupTitle"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.mCustomDirsRow = new BooleanRow((Composite)group, CUSTOM_DIRS, Messages.getString("NewUnoProjectPage.CustomDirsLabel"));
        this.mCustomDirsRow.setFieldChangedListener(this);
        this.mSourceRow = new TextRow((Composite)group, CUSTOM_SRC, Messages.getString("NewUnoProjectPage.CustomSourcesLabel"));
        this.mSourceRow.setValue("/source");
        this.mSourceRow.setEnabled(false);
        this.mSourceRow.setFieldChangedListener(this);
        this.mIdlDirRow = new TextRow((Composite)group, CUSTOM_IDL, Messages.getString("NewUnoProjectPage.CustomIdlLabel"));
        this.mIdlDirRow.setValue("/idl");
        this.mIdlDirRow.setEnabled(false);
        this.mIdlDirRow.setFieldChangedListener(this);
    }

    private void checkWhiteSpaces() {
        if (Platform.getOS().equals("win32") && this.getLocationPath().toOSString().contains(" ")) {
            this.setMessage(Messages.getString("NewUnoProjectPage.WhiteSpacesWarning"), 2);
        }
    }

    private void checkSpecialSymbolsinProjectName() {
        if (this.getProjectName().contains(" ") || this.getProjectName().contains("_")) {
            this.setMessage(Messages.getString("NewUnoProjectPage.SpecialSymbolsInProjectNameError"), 3);
            this.setPageComplete(false);
        }
    }

    private void addTextListener(Control control) {
        Text text;
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control2 = controlArray[i];
                this.addTextListener(control2);
            }
        } else if (control instanceof Text && !(text = (Text)control).isDisposed()) {
            text.addModifyListener(this.mModifListener);
            this.mListenedTexts.add(text);
        }
    }

    @Override
    public void fieldChanged(FieldEvent fieldEvent) {
        this.setPageComplete(this.validatePage());
        if (fieldEvent.getProperty().equals(PREFIX)) {
            String string = fieldEvent.getValue();
            if (!string.matches("([a-zA-Z][a-zA-Z0-9]*)(.[a-zA-Z][a-zA-Z0-9]*)*")) {
                this.setErrorMessage(Messages.getString("NewUnoProjectPage.InvalidPrefixError"));
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.checkWhiteSpaces();
            }
        } else if (fieldEvent.getProperty().equals(OUTPUT_EXT)) {
            String string = fieldEvent.getValue();
            if (!string.matches("[a-zA-Z][a-zA-Z0-9]*")) {
                this.setErrorMessage(Messages.getString("NewUnoProjectPage.InvalidCompError"));
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                if (Platform.getOS().equals("win32")) {
                    this.setMessage(Messages.getString("NewUnoProjectPage.WhiteSpacesWarning"), 2);
                }
            }
        } else if (fieldEvent.getProperty().equals(CUSTOM_DIRS)) {
            boolean bl = this.mCustomDirsRow.getBooleanValue();
            this.mSourceRow.setEnabled(bl);
            this.mIdlDirRow.setEnabled(bl);
        }
        if (this.getTitle().equalsIgnoreCase(Messages.getString("NewUreAppWizard.Title")) && this.getDescription().equalsIgnoreCase(Messages.getString("NewUreAppWizard.Description")) && this.mLanguageRow.getValue().equalsIgnoreCase("Python")) {
            this.setMessage(Messages.getString("NewUnoProjectPage.CheckLanguageUREPythonError"), 3);
            this.setPageComplete(false);
        }
        ((NewUnoProjectWizard)this.getWizard()).pageChanged((IWizardPage)this);
    }

    public UnoFactoryData fillData(UnoFactoryData unoFactoryData, boolean bl) {
        if (unoFactoryData != null) {
            if (bl) {
                try {
                    unoFactoryData.setProperty("project_handle", this.createNewProject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            unoFactoryData.setProperty("project_path", this.getLocationPath());
            unoFactoryData.setProperty("project_name", this.getProjectName());
            unoFactoryData.setProperty("project_prefix", this.getPrefix());
            unoFactoryData.setProperty("project_comp", this.getOutputExt());
            unoFactoryData.setProperty("project_language", this.getChosenLanguage());
            unoFactoryData.setProperty("project_sdk", this.mOOoConfigPanel.getSDKName());
            unoFactoryData.setProperty("project_ooo", this.mOOoConfigPanel.getOOoName());
            unoFactoryData.setProperty("project_src_dir", this.mSourceRow.getValue());
            unoFactoryData.setProperty("project_idl_dir", this.mIdlDirRow.getValue());
        }
        return unoFactoryData;
    }

    public IUnoidlProject getUnoidlProject() {
        return this.mUnoProject;
    }
}

