/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.pages;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.libreoffice.ide.eclipse.core.OOEclipsePlugin;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.builders.TypesBuilder;
import org.libreoffice.ide.eclipse.core.gui.PackageContentSelector;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.wizards.Messages;
import org.libreoffice.ide.eclipse.core.wizards.pages.ManifestExportPage;
import org.libreoffice.plugin.core.model.UnoPackage;

public class UnoPackageExportPage
extends WizardPage {
    private static final int DESTINATION_PART_COLS = 3;
    private static final String OVERWRITE_FILES = "overwrite.files";
    private static final String AUTODEPLOY = "autodeploy";
    private static final String DESTINATION_HISTORY = "destination.history";
    private static final int MAX_DESTINATION_STORED = 5;
    private Combo mProjectsList;
    private PackageContentSelector mContentSelector;
    private Combo mDestinationCombo;
    private Button mOverwriteBox;
    private Button mAutodeployBox;
    private IUnoidlProject mSelectedProject;
    private ManifestExportPage mManifestPage;

    public UnoPackageExportPage(String string, IUnoidlProject iUnoidlProject, ManifestExportPage manifestExportPage) {
        super(string);
        this.setTitle(Messages.getString("UnoPackageExportPage.Title"));
        this.setDescription(Messages.getString("UnoPackageExportPage.Description"));
        this.setImageDescriptor(OOEclipsePlugin.getImageDescriptor("PACKAGE_EXPORT_WIZ"));
        this.mSelectedProject = iUnoidlProject;
        this.mManifestPage = manifestExportPage;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite2);
        this.createProjectSelection();
        this.mContentSelector = new PackageContentSelector(composite2, 0);
        this.createDestinationGroup();
        this.createOptionsGroup();
        this.setPageComplete(this.checkPageCompletion());
        this.loadData();
    }

    private void loadData() {
        String[] stringArray = this.mProjectsList.getItems();
        boolean bl = false;
        for (int i = 0; this.mSelectedProject != null && i < stringArray.length && !bl; ++i) {
            if (!stringArray[i].equals(this.mSelectedProject.getName())) continue;
            this.mProjectsList.select(i);
            bl = true;
        }
        if (bl) {
            this.mContentSelector.loadDefaults();
        }
        this.restoreWidgetValues();
    }

    private void createProjectSelection() {
        Composite composite = (Composite)this.getControl();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("UnoPackageExportPage.Project"));
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ArrayList<String> arrayList = new ArrayList<String>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            for (IUnoidlProject iUnoidlProject : ProjectsManager.getProjects()) {
                if (!iWorkspaceRoot.getProject(iUnoidlProject.getName()).hasNature("org.libreoffice.ide.eclipse.core.unonature") || iUnoidlProject.getLanguage() == null) continue;
                arrayList.add(iUnoidlProject.getName());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.mProjectsList = new Combo(composite2, 12);
        this.mProjectsList.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mProjectsList.setItems(arrayList.toArray(new String[arrayList.size()]));
        this.mProjectsList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                int n = UnoPackageExportPage.this.mProjectsList.getSelectionIndex();
                if (n != -1) {
                    String string = UnoPackageExportPage.this.mProjectsList.getItem(n);
                    IUnoidlProject iUnoidlProject = ProjectsManager.getProject(string);
                    UnoPackageExportPage.this.mSelectedProject = iUnoidlProject;
                    UnoPackageExportPage.this.mManifestPage.setProject(iUnoidlProject);
                    UnoPackageExportPage.this.mContentSelector.setProject(iUnoidlProject);
                }
                UnoPackageExportPage.this.setPageComplete(UnoPackageExportPage.this.checkPageCompletion());
            }
        });
    }

    private void createDestinationGroup() {
        Composite composite = (Composite)this.getControl();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("UnoPackageExportPage.SelectDestination"));
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        composite3.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label2 = new Label(composite3, 0);
        label2.setText(Messages.getString("UnoPackageExportPage.OxtFile"));
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.mDestinationCombo = new Combo(composite3, 4);
        this.mDestinationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mDestinationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                UnoPackageExportPage.this.setPageComplete(UnoPackageExportPage.this.checkPageCompletion());
            }
        });
        Button button = new Button(composite3, 8);
        button.setText(Messages.getString("UnoPackageExportPage.Browse"));
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(UnoPackageExportPage.this.getShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{"*.oxt"});
                String string = fileDialog.open();
                if (string != null) {
                    UnoPackageExportPage.this.mDestinationCombo.setText(string);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    private void createOptionsGroup() {
        Composite composite = (Composite)this.getControl();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("UnoPackageExportPage.Options"));
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 1, true, false));
        this.mOverwriteBox = new Button(composite3, 32);
        this.mOverwriteBox.setText(Messages.getString("UnoPackageExportPage.OverwriteWithoutWarning"));
        this.mOverwriteBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mAutodeployBox = new Button(composite3, 32);
        this.mAutodeployBox.setText(Messages.getString("UnoPackageExportPage.AutoDeploy"));
        this.mAutodeployBox.setLayoutData((Object)new GridData(1, 1, false, false));
    }

    private boolean checkPageCompletion() {
        return 0 != this.mDestinationCombo.getText().length() && this.mProjectsList.getSelectionIndex() != -1;
    }

    public void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String string;
            iDialogSettings.put(OVERWRITE_FILES, this.mOverwriteBox.getSelection());
            iDialogSettings.put(AUTODEPLOY, this.mAutodeployBox.getSelection());
            String[] stringArray = new String[5];
            stringArray[0] = string = this.mDestinationCombo.getText().trim();
            int n = 0;
            int n2 = this.mDestinationCombo.getItemCount();
            for (int i = 0; n < 4 && i < n2; ++i) {
                String string2 = this.mDestinationCombo.getItem(i).trim();
                if (this.mDestinationCombo.getSelectionIndex() == i) continue;
                stringArray[n + 1] = string2;
                ++n;
            }
            iDialogSettings.put(DESTINATION_HISTORY, stringArray);
        }
    }

    public void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.mOverwriteBox.setSelection(iDialogSettings.getBoolean(OVERWRITE_FILES));
            this.mAutodeployBox.setSelection(iDialogSettings.getBoolean(AUTODEPLOY));
            String[] stringArray = iDialogSettings.getArray(DESTINATION_HISTORY);
            if (stringArray != null) {
                for (String string : stringArray) {
                    if (string == null || 0 == string.length()) continue;
                    this.mDestinationCombo.add(string);
                }
            }
        }
    }

    public UnoPackage getPackageModel() {
        UnoPackage unoPackage = null;
        try {
            Object object;
            boolean bl = true;
            File file = new File(this.mDestinationCombo.getText());
            if (file.exists() && !this.mOverwriteBox.getSelection()) {
                object = MessageFormat.format(Messages.getString("UnoPackageExportPage.OverwriteQuestion"), file.getPath());
                bl = MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getTitle(), (String)object);
            }
            if (bl) {
                unoPackage = PackageContentSelector.createPackage(this.mSelectedProject, file, this.mContentSelector.getSelected());
                if (this.mAutodeployBox.getSelection()) {
                    object = new DeployerJob(this.mSelectedProject.getOOo(), file);
                    Display.getDefault().asyncExec((Runnable)object);
                }
            }
        }
        catch (Exception exception) {
            PluginLogger.error(Messages.getString("UnoPackageExportPage.LibraryCreationError"), exception);
        }
        return unoPackage;
    }

    public void refreshProject() {
        try {
            String string = this.mSelectedProject.getName();
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            iProject.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void forceBuild() throws Exception {
        String string = this.mSelectedProject.getName();
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        TypesBuilder.build(iProject, null);
    }

    class DeployerJob
    implements Runnable {
        private IOOo mOOo;
        private File mDest;

        DeployerJob(IOOo iOOo, File file) {
            this.mOOo = iOOo;
            this.mDest = file;
        }

        @Override
        public void run() {
            if (this.mOOo.canManagePackages()) {
                this.mOOo.updatePackage(this.mDest, null);
            }
        }
    }
}

