/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.core.wizards.utils;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.wizards.utils.IPageListener;
import org.libreoffice.ide.eclipse.core.wizards.utils.NoSuchPageException;

public abstract class WizardPageSet {
    protected boolean mChangingPages = false;
    protected IPageListener mPageListener = new IPageListener(){

        @Override
        public void pageChanged(UnoFactoryData unoFactoryData) {
            if (!WizardPageSet.this.mChangingPages) {
                WizardPageSet.this.dataChanged(unoFactoryData);
            }
        }
    };
    protected IWizard mWizard;
    private Vector<IWizardPage> mPages = new Vector();
    private Vector<Boolean> mHidden = new Vector();

    public WizardPageSet(IWizard iWizard) {
        if (iWizard != null) {
            this.mWizard = iWizard;
        }
    }

    public IWizardPage getPage(String string) {
        IWizardPage iWizardPage = null;
        for (int i = 0; iWizardPage == null && i < this.mPages.size(); ++i) {
            if (!this.mPages.get(i).getName().equals(string)) continue;
            iWizardPage = this.mPages.get(i);
        }
        return iWizardPage;
    }

    public void addPage(IWizardPage iWizardPage) {
        if (!this.mPages.contains(iWizardPage)) {
            this.mPages.add(iWizardPage);
            this.mHidden.add(Boolean.FALSE);
        }
    }

    public IWizardPage[] getPages() {
        return this.mPages.toArray(new IWizardPage[this.mPages.size()]);
    }

    public void setHidden(IWizardPage iWizardPage, boolean bl) {
        int n = this.mPages.indexOf(iWizardPage);
        if (n != -1) {
            this.mHidden.set(n, bl);
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) throws NoSuchPageException {
        IWizardPage iWizardPage2 = null;
        if (this.mPages.contains(iWizardPage)) {
            int n = this.mPages.indexOf(iWizardPage);
            int n2 = n + 1;
            boolean bl = false;
            while (n2 < this.mPages.size() && !bl) {
                if (this.mHidden.get(n2).booleanValue()) {
                    ++n2;
                    continue;
                }
                bl = true;
            }
            if (bl) {
                iWizardPage2 = this.mPages.get(n2);
            }
        } else {
            throw new NoSuchPageException();
        }
        return iWizardPage2;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) throws NoSuchPageException {
        IWizardPage iWizardPage2 = null;
        if (this.mPages.contains(iWizardPage)) {
            int n = this.mPages.indexOf(iWizardPage);
            int n2 = n - 1;
            boolean bl = false;
            while (-1 < n2 && !bl) {
                if (this.mHidden.get(n2).booleanValue()) {
                    --n2;
                    continue;
                }
                bl = true;
            }
            if (bl) {
                iWizardPage2 = this.mPages.get(n2);
            }
        } else {
            throw new NoSuchPageException();
        }
        return iWizardPage2;
    }

    public abstract void initialize(UnoFactoryData var1);

    public abstract void doFinish(IProgressMonitor var1, IWorkbenchPage var2);

    protected abstract void dataChanged(UnoFactoryData var1);
}

