/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.plugin.core.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.libreoffice.plugin.core.model.FileType;

public class ManifestModel {
    private static final String EXT_XCS = ".xcs";
    private static final String EXT_XCU = ".xcu";
    private static final String EXT_RDB = ".rdb";
    private Map<String, FileType> mEntries = new HashMap<String, FileType>();

    public void addContent(String string, File file) {
        if (file.isFile()) {
            if (file.getName().endsWith(EXT_XCS)) {
                this.addConfigurationSchemaFile(string);
            } else if (file.getName().endsWith(EXT_XCU)) {
                this.addConfigurationDataFile(string);
            } else if (file.getName().endsWith(EXT_RDB)) {
                this.addTypelibraryFile(string);
            } else if (file.getName().equals("description.xml")) {
                this.addDescription(string, Locale.getDefault());
            }
        } else if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.addContent(string + "/" + file2.getName(), file2);
            }
        } else {
            throw new IllegalArgumentException("pContent [" + file + "] does not exists");
        }
    }

    public void addComponentFile(String string, String string2) {
        this.addComponentFile(string, string2, null);
    }

    public void addComponentFile(String string, String string2, String string3) {
        FileType fileType = new FileType("application/vnd.sun.star.uno-component");
        fileType.addParam("type", string2);
        if (string3 != null && string2.equals("native")) {
            fileType.addParam("platform", string3);
        }
        this.addEntry(string, fileType);
    }

    public void addComponentsFile(String string) {
        this.addComponentsFile(string, null);
    }

    public void addComponentsFile(String string, String string2) {
        FileType fileType = new FileType("application/vnd.sun.star.uno-components");
        if (string2 != null) {
            fileType.addParam("platform", string2);
        }
        this.addEntry(string, fileType);
    }

    public void addTypelibraryFile(String string) {
        FileType fileType = new FileType("application/vnd.sun.star.uno-typelibrary");
        fileType.addParam("type", "RDB");
        this.addEntry(string, fileType);
    }

    public void addBasicLibrary(String string) {
        FileType fileType = new FileType("application/vnd.sun.star.basic-library");
        this.addEntry(string, fileType);
    }

    public void addDialogLibrary(String string) {
        FileType fileType = new FileType("application/vnd.sun.star.dialog-library");
        this.addEntry(string, fileType);
    }

    public void addConfigurationDataFile(String string) {
        if (new File(string).getName().endsWith(EXT_XCU)) {
            FileType fileType = new FileType("application/vnd.sun.star.configuration-data");
            this.addEntry(string, fileType);
        }
    }

    public void addConfigurationSchemaFile(String string) {
        if (new File(string).getName().endsWith(EXT_XCS)) {
            FileType fileType = new FileType("application/vnd.sun.star.configuration-schema");
            this.addEntry(string, fileType);
        }
    }

    public void addDescription(String string, Locale locale) {
        String string2 = new String();
        if (locale != null) {
            string2 = locale.toString();
            string2 = string2.replace("_", "-");
        }
        FileType fileType = new FileType("application/vnd.sun.star.package-bundle-description");
        if (!string2.isEmpty()) {
            fileType.addParam("locale", string2);
        }
        this.addEntry(string, fileType);
    }

    private void addEntry(String string, FileType fileType) {
        String string2 = string;
        if ((string2 = string2.replace("\\", "/")).endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.mEntries.put(string2, fileType);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new OutputStreamWriter(outputStream));
        outputStream.flush();
    }

    public void write(Writer writer) throws IOException {
        Iterator<Map.Entry<String, FileType>> iterator = this.mEntries.entrySet().iterator();
        String string = "\t<manifest:file-entry manifest:full-path=\"{0}\" manifest:media-type=\"{1}\"/>\n";
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<manifest:manifest xmlns:manifest=\"http://openoffice.org/2001/manifest\">\n");
        while (iterator.hasNext()) {
            Map.Entry<String, FileType> entry = iterator.next();
            writer.write(MessageFormat.format(string, entry.getKey(), entry.getValue().toString()));
        }
        writer.write("</manifest:manifest>\n");
        writer.flush();
    }
}

