/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.plugin.core.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.plugin.core.model.ManifestModel;
import org.libreoffice.plugin.core.utils.FileHelper;
import org.libreoffice.plugin.core.utils.FilenameUtils;
import org.libreoffice.plugin.core.utils.StringUtils;
import org.libreoffice.plugin.core.utils.ZipContent;

public class UnoPackage {
    public static final String MANIFEST_PATH = "manifest.xml";
    public static final String ZIP = "zip";
    public static final String UNOPKG = "uno.pkg";
    public static final String OXT = "oxt";
    private static final String BASIC_LIBRARY_INDEX = "script.xlb";
    private static final String DIALOG_LIBRARY_INDEX = "dialog.xlb";
    private static final String MIMETYPE = "mimetype";
    private static final String MIMETYPE_CONTENT = "application/vnd.openofficeorg.extension";
    private File mDestination;
    private boolean mBuilding = false;
    private Map<String, ZipContent> mZipEntries = new HashMap<String, ZipContent>();
    private ManifestModel mManifest;
    private ArrayList<File> mToClean = new ArrayList();
    private File mReadManifestFile;
    private File mCopyManifestFileTo;

    public UnoPackage(File file) {
        File file2 = file;
        if (!(file2.getName().endsWith(ZIP) || file2.getName().endsWith(UNOPKG) || file2.getName().endsWith(OXT))) {
            int n = file2.getName().lastIndexOf(".");
            if (n > 0) {
                String string = file2.getName().substring(0, n);
                file2 = new File(file2.getParentFile(), string + "." + OXT);
            } else {
                file2 = new File(file2.getParentFile(), file2.getName() + "." + OXT);
            }
        }
        this.mDestination = file2;
        this.mManifest = new ManifestModel();
    }

    public static String getPathRelativeToBase(File file, File file2) {
        String string = file.getAbsolutePath();
        int n = string.indexOf(file2.getPath());
        if (n == -1) {
            String string2 = "File [" + file + "] is not part of the base path tree [" + file2 + "]";
            throw new InvalidParameterException(string2);
        }
        return string.substring(file2.getPath().length() + 1);
    }

    public void dispose() {
        this.mDestination = null;
        this.mZipEntries.clear();
    }

    public ManifestModel getManifestModel() {
        return this.mManifest;
    }

    public void setReadManifestFile(File file) {
        if (file != null && file.exists()) {
            this.mReadManifestFile = file;
        }
    }

    public void setCopyManifestFileTo(File file) {
        if (file != null && !file.exists()) {
            this.mCopyManifestFileTo = file;
        }
    }

    public void addContent(File file) {
        this.addContent("", file);
    }

    public void addContent(String string, File file) {
        String string2 = "";
        if (string != null) {
            string2 = FilenameUtils.normalize(string);
        }
        string2 = FilenameUtils.separatorsToUnix(string2);
        if (file.isFile()) {
            this.addFile(string2, file);
        } else if (file.isDirectory()) {
            this.addDirectory(string2, file);
        } else {
            throw new IllegalArgumentException("pContent [" + file + "] does not exists");
        }
    }

    public void addFile(String string, File file) {
        if (file.getName().endsWith(".xcs")) {
            this.addConfigurationSchemaFile(string, file);
        } else if (file.getName().endsWith(".xcu")) {
            this.addConfigurationDataFile(string, file);
        } else if (file.getName().endsWith(".rdb")) {
            this.addTypelibraryFile(string, file);
        } else if (file.getName().equals("description.xml")) {
            this.addPackageDescription(string, file, Locale.getDefault());
        } else if (file.getName().endsWith(".component")) {
            this.addComponentsFile(string, file);
        } else {
            this.addOtherFile(string, file);
        }
    }

    public void addDirectory(File file) {
        this.addDirectory("", file);
    }

    public void addDirectory(String string, File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory!");
        }
        this.addDirectory(string, file, new String[0], new String[0]);
    }

    public void addDirectory(File file, String[] stringArray, String[] stringArray2) {
        this.addDirectory("", file, stringArray, stringArray2);
    }

    private void addDirectory(String string, File file, String[] stringArray, String[] stringArray2) {
        String string2 = FilenameUtils.normalize(string);
        assert (file.isDirectory());
        if (this.isBasicLibrary(file)) {
            this.addBasicLibraryFile(string2, file, stringArray, stringArray2);
        } else if (this.isDialogLibrary(file)) {
            this.addDialogLibraryFile(string2, file, stringArray, stringArray2);
        } else {
            for (File file2 : file.listFiles()) {
                String string3 = file2.getName();
                if (StringUtils.isNotEmpty(string2)) {
                    string3 = FilenameUtils.normalize(string2 + "/" + string3);
                }
                if (UnoPackage.shouldBeExcluded(string3, stringArray, stringArray2)) continue;
                if (file2.isFile()) {
                    this.addFile(string3, file2);
                    continue;
                }
                this.addDirectory(string3 + "/", file2, stringArray, stringArray2);
            }
        }
    }

    private static boolean shouldBeExcluded(String string, String[] stringArray, String[] stringArray2) {
        boolean bl = false;
        if (stringArray.length > 0 && !UnoPackage.match(string, stringArray)) {
            System.out.println(string + " will be not included");
            bl = true;
        } else if (UnoPackage.match(string, stringArray2)) {
            System.out.println(string + " will be excluded");
            bl = true;
        }
        return bl;
    }

    private static boolean match(String string, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!UnoPackage.match(string, stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean match(String string, String string2) {
        String string3 = string2.replace("*", ".*");
        string3 = string3.replace(".*.*/", ".*/");
        return string.matches(string3);
    }

    public void addComponentFile(String string, File file, String string2) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File [" + file + "] is not a file");
        }
        string = FilenameUtils.separatorsToUnix(string);
        this.initializeOutput();
        this.mManifest.addComponentFile(string, string2);
        this.addZipContent(string, file);
    }

    public void addComponentsFile(String string, File file) {
        this.addComponentsFile(string, file, null);
    }

    public void addComponentsFile(String string, File file, String string2) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("pFile [" + file + "] is not a file");
        }
        this.initializeOutput();
        this.mManifest.addComponentsFile(string, string2);
        this.addZipContent(string, file);
    }

    public void addTypelibraryFile(String string, File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File [" + file + "] is not a file");
        }
        string = FilenameUtils.separatorsToUnix(string);
        this.initializeOutput();
        this.mManifest.addTypelibraryFile(string);
        this.addZipContent(string, file);
    }

    static boolean hasRegistrationHandlerInside(File file) {
        boolean bl = false;
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith("RegistrationHandler.class") && !jarEntry.getName().endsWith("RegistrationHandler.classes")) continue;
                jarFile.close();
                bl = true;
                break;
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            PluginLogger.warning("can't read " + file + " (" + iOException + ")");
        }
        return bl;
    }

    public void addBasicLibraryFile(File file) {
        this.addBasicLibraryFile(null, file);
    }

    public void addBasicLibraryFile(String string, File file) {
        this.addBasicLibraryFile(string, file, new String[0], new String[0]);
    }

    public void addBasicLibraryFile(String string, File file, String[] stringArray, String[] stringArray2) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("pDir [" + file + "] is not a folder");
        }
        this.initializeOutput();
        this.mManifest.addBasicLibrary(string);
        this.addZipContent(string, file, stringArray, stringArray2);
    }

    public void addDialogLibraryFile(File file) {
        this.addDialogLibraryFile(null, file);
    }

    public void addDialogLibraryFile(String string, File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("pDir [" + file + "] is not a folder");
        }
        this.initializeOutput();
        this.mManifest.addDialogLibrary(string);
        this.addZipContent(string, file);
    }

    public void addDialogLibraryFile(String string, File file, String[] stringArray, String[] stringArray2) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("pDir [" + file + "] is not a folder");
        }
        this.initializeOutput();
        this.mManifest.addDialogLibrary(string);
        this.addZipContent(string, file, stringArray, stringArray2);
    }

    public void addConfigurationDataFile(String string, File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File [" + file + "] is not a file");
        }
        this.initializeOutput();
        this.mManifest.addConfigurationDataFile(string);
        this.addZipContent(string, file);
    }

    public void addConfigurationSchemaFile(String string, File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File [" + file + "] is not a file");
        }
        this.initializeOutput();
        this.mManifest.addConfigurationSchemaFile(string);
        this.addZipContent(string, file);
    }

    public void addPackageDescription(String string, File file, Locale locale) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File [" + file + "] is not a file");
        }
        this.mManifest.addDescription(string, locale);
        this.addZipContent(string, file);
    }

    public void addOtherFile(String string, File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File [" + file.getAbsolutePath() + "] is not a file");
        }
        string = FilenameUtils.separatorsToUnix(string);
        this.initializeOutput();
        this.addZipContent(string, file);
    }

    public File close() {
        File file = null;
        if (this.mBuilding) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.mDestination);
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                ZipEntry zipEntry = new ZipEntry(MIMETYPE);
                byte[] byArray = MIMETYPE_CONTENT.getBytes(StandardCharsets.UTF_8);
                zipEntry.setMethod(0);
                zipEntry.setSize(byArray.length);
                zipEntry.setCompressedSize(byArray.length);
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                zipEntry.setCrc(cRC32.getValue());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray);
                for (ZipContent zipContent : this.mZipEntries.values()) {
                    zipContent.writeContentToZip(zipOutputStream);
                }
                if (!this.mZipEntries.containsKey("META-INF/manifest.xml")) {
                    this.addManifestFile(zipOutputStream);
                }
                zipOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Error while package creation: " + exception);
            }
            file = this.mDestination;
            this.cleanResources();
            this.dispose();
        }
        return file;
    }

    private void addManifestFile(ZipOutputStream zipOutputStream) throws IOException {
        File file = this.mReadManifestFile;
        if (file == null) {
            file = this.createManifestFile();
            this.addToClean(file);
            if (this.mCopyManifestFileTo != null) {
                FileHelper.copyFile(file, this.mCopyManifestFileTo, true);
            }
        }
        ZipContent zipContent = new ZipContent("META-INF/manifest.xml", file);
        zipContent.writeContentToZip(zipOutputStream);
    }

    private File createManifestFile() throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"), MANIFEST_PATH);
        if (file.exists()) {
            throw new IOException("I don't risk to overwrite " + file.getAbsolutePath() + " - please delete it manually!");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.mManifest.write(fileOutputStream);
        fileOutputStream.close();
        return file;
    }

    public List<File> getContainedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(this.mZipEntries.size());
        for (ZipContent zipContent : this.mZipEntries.values()) {
            arrayList.add(zipContent.getFile());
        }
        return arrayList;
    }

    public List<String> getContainedNames() {
        return new ArrayList<String>(this.mZipEntries.keySet());
    }

    public void addToClean(File file) {
        this.mToClean.add(file);
    }

    private void initializeOutput() {
        this.mBuilding = true;
    }

    private void addZipContent(String string, File file) {
        this.addZipContent(string, file, new String[0], new String[0]);
    }

    private void addZipContent(String string, File file, String[] stringArray, String[] stringArray2) {
        if (string == null) {
            return;
        }
        if (file.isDirectory()) {
            try {
                for (File file2 : file.listFiles()) {
                    String string2 = FilenameUtils.normalize(string + "/" + file2.getName());
                    if (UnoPackage.shouldBeExcluded(string2, stringArray, stringArray2)) continue;
                    this.addZipContent(string2, file2);
                }
            }
            catch (Exception exception) {}
        } else {
            String string3 = FileHelper.separatorsToUnix(string);
            PluginLogger.debug("Adding " + string3 + " to oxt package");
            ZipContent zipContent = new ZipContent(string3, file);
            this.mZipEntries.put(string, zipContent);
        }
    }

    private void cleanResources() {
        for (File file : this.mToClean) {
            FileHelper.remove(file);
        }
    }

    private boolean isDialogLibrary(File file) {
        boolean bl = false;
        if (file.isDirectory()) {
            bl = new File(file, DIALOG_LIBRARY_INDEX).exists();
        }
        return bl;
    }

    private boolean isBasicLibrary(File file) {
        boolean bl = false;
        if (file.isDirectory()) {
            bl = new File(file, BASIC_LIBRARY_INDEX).exists();
        }
        return bl;
    }
}

