/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.plugin.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileHelper {
    public static String separatorsToUnix(String string) {
        String string2 = string == null || string.indexOf(47) == -1 ? string : string.replace('\\', '/');
        return string2;
    }

    public static void move(File file, File file2, boolean bl) throws IOException {
        if (file == null || !file.canRead()) {
            String string = "";
            if (file != null) {
                string = file.getAbsolutePath();
            }
            throw new IOException("FileHelper.ReadError" + string);
        }
        if (file2 == null || !file2.canWrite()) {
            String string = "";
            if (file2 != null) {
                string = file2.getAbsolutePath();
            }
            throw new IOException("FileHelper.WriteError" + string);
        }
        if (file.isFile()) {
            FileHelper.copyFile(file, new File(file2, file.getName()), bl);
            file.delete();
        } else {
            File file3 = new File(file2, file.getName());
            if (!file3.exists()) {
                file3.mkdir();
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file4 = fileArray[i];
                FileHelper.move(file4, file3, bl);
                file4.delete();
            }
            file.delete();
        }
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (file == null || !file.canRead()) {
            String string = "FileHelper.ReadError";
            if (file != null) {
                string = string + " " + file.getAbsolutePath();
            }
            throw new IOException(string);
        }
        if (file2 == null) {
            throw new IOException("FileHelper.NullDestinationError");
        }
        if (bl && file2.exists() && file2.isFile()) {
            file2.delete();
        }
        if (!file2.exists()) {
            FileHelper.copyFile(file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            int n = fileInputStream.read();
            while (n != -1) {
                fileOutputStream.write(n);
                n = fileInputStream.read();
            }
        }
        finally {
            try {
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void remove(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            String[] stringArray = file.list();
            if (null != stringArray) {
                for (String string : stringArray) {
                    if (string.equals(".") || string.equals("..")) continue;
                    File file2 = new File(file, string);
                    FileHelper.remove(file2);
                }
            }
            file.delete();
        }
    }
}

