/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.plugin.core.utils;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

public class XMLWriter
extends PrintWriter {
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int BUFFER_FREE_SPACE = 10;
    protected int mTab = 0;

    public XMLWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(outputStream, "UTF8"));
        this.println(XML_VERSION);
    }

    public void endTag(String string) {
        --this.mTab;
        this.printTag('/' + string, null);
    }

    public void endTag(String string, boolean bl) {
        --this.mTab;
        this.printTag('/' + string, null, bl, true, false);
    }

    public void printSimpleTag(String string, Object object) {
        if (object != null) {
            this.printTag(string, null, true, false, false);
            this.print(XMLWriter.getEscaped(String.valueOf(object)));
            this.printTag('/' + string, null, false, true, false);
        }
    }

    public void printTabulation() {
        for (int i = 0; i < this.mTab; ++i) {
            super.print('\t');
        }
    }

    public void printSingleTag(String string, Map<String, ? extends Object> map) {
        this.printTag(string, map, true, true, true);
    }

    public void printTag(String string, Map<String, ? extends Object> map) {
        this.printTag(string, map, true, true, false);
    }

    public void printTag(String string, Map<String, ? extends Object> map, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (map != null) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" ");
                String string2 = iterator.next();
                stringBuffer.append(string2);
                stringBuffer.append("=\"");
                stringBuffer.append(XMLWriter.getEscaped(String.valueOf(map.get(string2))));
                stringBuffer.append("\"");
            }
        }
        if (bl3) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        if (bl) {
            this.printTabulation();
        }
        if (bl2) {
            this.println(stringBuffer.toString());
        } else {
            this.print(stringBuffer.toString());
        }
    }

    public void startTag(String string, Map<String, ? extends Object> map) {
        this.startTag(string, map, true);
    }

    public void startTag(String string, Map<String, ? extends Object> map, boolean bl) {
        this.printTag(string, map, true, bl, false);
        ++this.mTab;
    }

    private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
        String string = XMLWriter.getReplacement(c);
        if (string != null) {
            stringBuffer.append('&');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(c);
        }
    }

    public static String getEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        for (int i = 0; i < string.length(); ++i) {
            XMLWriter.appendEscapedChar(stringBuffer, string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String getReplacement(char c) {
        String string = null;
        switch (c) {
            case '<': {
                string = "lt";
            }
            case '>': {
                string = "gt";
            }
            case '\"': {
                string = "quot";
            }
            case '\'': {
                string = "apos";
            }
            case '&': {
                string = "amp";
            }
        }
        return string;
    }
}

