/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.plugin.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipContent {
    private static final int BUFFER_SIZE = 2048;
    protected File mResource;
    protected String mEntryName;

    public ZipContent(String string, File file) {
        this.mResource = file;
        this.mEntryName = string;
    }

    public File getFile() {
        return this.mResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContentToZip(ZipOutputStream zipOutputStream) {
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.mResource);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(this.mEntryName);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[2048];
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            System.err.println("Problem when writing file to zip: " + this.mEntryName + " (" + iOException.getLocalizedMessage() + ")");
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

