/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.config.ISdk;
import org.libreoffice.ide.eclipse.core.model.language.ILanguageBuilder;
import org.libreoffice.ide.eclipse.core.model.utils.SystemHelper;
import org.libreoffice.ide.eclipse.java.JavaClassPathProvider;
import org.libreoffice.ide.eclipse.java.JavaProjectHandler;
import org.libreoffice.ide.eclipse.java.Language;
import org.libreoffice.ide.eclipse.java.build.FilesVisitor;
import org.libreoffice.ide.eclipse.java.build.Messages;
import org.libreoffice.ide.eclipse.java.build.UnoManifestProvider;
import org.libreoffice.plugin.core.model.UnoPackage;

public class JavaBuilder
implements ILanguageBuilder {
    private static final String LIB_DIR_NAME = "lib";
    private static final String LIBS_DIR_NAME = "libs";
    private Language mLanguage;

    public JavaBuilder(Language language) {
        this.mLanguage = language;
    }

    public IFile createLibrary(IUnoidlProject iUnoidlProject) throws Exception {
        IFile iFile = ((JavaProjectHandler)this.mLanguage.getProjectHandler()).getJarFile(iUnoidlProject);
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        List<IResource> list = this.getProjectLibs(iUnoidlProject, iJavaProject);
        JarPackageData jarPackageData = new JarPackageData();
        jarPackageData.setGenerateManifest(true);
        jarPackageData.setJarLocation(iFile.getLocation());
        String string = ((JavaProjectHandler)this.mLanguage.getProjectHandler()).getRegistrationClassName(iUnoidlProject);
        jarPackageData.setManifestProvider((IManifestProvider)new UnoManifestProvider(string, iUnoidlProject, list));
        jarPackageData.setManifestLocation(iUnoidlProject.getFile("MANIFEST.MF").getFullPath());
        jarPackageData.setSaveManifest(false);
        jarPackageData.setReuseManifest(false);
        jarPackageData.setExportOutputFolders(true);
        jarPackageData.setExportClassFiles(true);
        jarPackageData.setExportWarnings(true);
        jarPackageData.setOverwrite(true);
        FilesVisitor filesVisitor = new FilesVisitor();
        filesVisitor.addException((IResource)iUnoidlProject.getFolder(iUnoidlProject.getUrdPath()));
        filesVisitor.addException((IResource)iUnoidlProject.getFolder(iUnoidlProject.getBuildPath().append("idl")));
        filesVisitor.addException((IResource)iUnoidlProject.getFolder(iUnoidlProject.getBuildPath().append("classes")));
        IFolder iFolder = iUnoidlProject.getFolder(iUnoidlProject.getBuildPath());
        iFolder.accept((IResourceVisitor)filesVisitor);
        IFolder iFolder2 = iUnoidlProject.getFolder(iUnoidlProject.getSourcePath());
        iFolder2.accept((IResourceVisitor)filesVisitor);
        jarPackageData.setElements((Object[])filesVisitor.getFiles());
        IJarExportRunnable iJarExportRunnable = jarPackageData.createJarExportRunnable(null);
        iJarExportRunnable.run((IProgressMonitor)new NullProgressMonitor());
        return iFile;
    }

    public void generateFromTypes(ISdk iSdk, IOOo iOOo, IProject iProject, File file, File file2, String string, IProgressMonitor iProgressMonitor) {
        if (file.exists() && null != iSdk && null != iOOo) {
            String[] stringArray = iOOo.getTypesPath();
            String string2 = "";
            for (String string3 : stringArray) {
                Path path = new Path(string3);
                string2 = string2 + " -X\"" + path.toOSString() + "\"";
            }
            String string4 = "*";
            this.runJavamaker(string4, string2, iSdk, iProject, file, file2, iProgressMonitor);
        }
    }

    private void runJavamaker(String string, String string2, ISdk iSdk, IProject iProject, File file, File file2, IProgressMonitor iProgressMonitor) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string3 = "{0} -T{1} -nD -Gc -O\"{2}\" \"{3}\" {4}";
            String string4 = MessageFormat.format(string3, iSdk.getCommand("javamaker"), string, file2.getAbsolutePath(), file.getAbsolutePath(), string2);
            IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)iProject.getName());
            Process process = iSdk.runTool(iUnoidlProject, string4, iProgressMonitor);
            process.waitFor();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(process.getErrorStream()));
            String string5 = lineNumberReader.readLine();
            while (null != string5) {
                stringBuffer.append(string5 + '\n');
                string5 = lineNumberReader.readLine();
            }
            if (stringBuffer.length() > 0) {
                PluginLogger.debug((String)stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            PluginLogger.error((String)Messages.getString("Language.CreateCodeError"), (Throwable)interruptedException);
        }
        catch (IOException iOException) {
            PluginLogger.warning((String)Messages.getString("Language.UnreadableOutputError"));
        }
    }

    public String[] getBuildEnv(IUnoidlProject iUnoidlProject) {
        String string;
        Object object;
        Object object2;
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        String[] stringArray = new String[2];
        String string2 = "CLASSPATH=";
        String string3 = System.getProperty("path.separator");
        File file = null;
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject != null) {
            try {
                object2 = iJavaProject.getResolvedClasspath(true);
                for (int i = 0; i < ((IClasspathEntry[])object2).length; ++i) {
                    object = object2[i];
                    if (object.getEntryKind() != 3) {
                        string2 = string2 + object.getPath().toOSString();
                    }
                    if (i >= ((IClasspathEntry[])object2).length - 1) continue;
                    string2 = string2 + string3;
                }
                string = JavaRuntime.getVMInstall((IJavaProject)iJavaProject);
                file = string.getInstallLocation();
            }
            catch (JavaModelException javaModelException) {
                PluginLogger.error((String)Messages.getString("Language.GetClasspathError"), (Throwable)javaModelException);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        stringArray[0] = string2;
        if (file != null) {
            object2 = "";
            string = System.getProperty("file.separator");
            try {
                object = System.getProperty("os.arch");
                object2 = file.getCanonicalPath() + string + LIB_DIR_NAME + string + (String)object;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringArray[1] = "LD_LIBRARY_PATH=" + (String)object2;
        }
        return stringArray;
    }

    public void fillUnoPackage(UnoPackage unoPackage, IUnoidlProject iUnoidlProject) {
        JavaProjectHandler javaProjectHandler = (JavaProjectHandler)this.mLanguage.getProjectHandler();
        File file = SystemHelper.getFile((IResource)javaProjectHandler.getJarFile(iUnoidlProject));
        File file2 = SystemHelper.getFile((IUnoidlProject)iUnoidlProject);
        unoPackage.addComponentFile(UnoPackage.getPathRelativeToBase((File)file, (File)file2), file, "Java");
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        List<IResource> list = this.getProjectLibs(iUnoidlProject, iJavaProject);
        for (IResource iResource : list) {
            File file3 = SystemHelper.getFile((IResource)iResource);
            unoPackage.addOtherFile(UnoPackage.getPathRelativeToBase((File)file3, (File)file2), file3);
        }
    }

    private List<IResource> getProjectLibs(IUnoidlProject iUnoidlProject, IJavaProject iJavaProject) {
        List<Object> list = new ArrayList();
        list = iJavaProject.getProject().getFolder(LIB_DIR_NAME).exists() ? this.getLibsFromDir(iJavaProject, LIB_DIR_NAME) : (iJavaProject.getProject().getFolder(LIBS_DIR_NAME).exists() ? this.getLibsFromDir(iJavaProject, LIBS_DIR_NAME) : JavaClassPathProvider.getProjectLibs(iUnoidlProject, iJavaProject));
        PluginLogger.debug((String)("Found " + list.size() + " Jars"));
        return list;
    }

    private List<IResource> getLibsFromDir(IJavaProject iJavaProject, String string) {
        PluginLogger.debug((String)("Collecting Jars from: /" + string));
        List<Object> list = new ArrayList<IResource>();
        IFolder iFolder = iJavaProject.getProject().getFolder(string);
        if (iFolder.exists()) {
            java.nio.file.Path path = Paths.get(iFolder.getRawLocation().toOSString(), new String[0]);
            try (Stream<java.nio.file.Path> stream = Files.walk(path, new FileVisitOption[0]);){
                list = stream.map(path2 -> {
                    java.nio.file.Path path3 = path.relativize((java.nio.file.Path)path2);
                    return iFolder.getFile(path3.toString());
                }).filter(iFile -> iFile.getType() == 1).filter(iFile -> "jar".equals(iFile.getFileExtension())).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                PluginLogger.error((String)Messages.getString("JavaBuilder.GetLibsFromDirFailed"), (Throwable)iOException);
            }
        }
        return list;
    }
}

