/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.java.Messages;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JavaClassPathProvider {
    public static final List<IResource> getProjectLibs(IUnoidlProject iUnoidlProject, IJavaProject iJavaProject) {
        return JavaClassPathProvider.getWorkspaceLibs(iUnoidlProject, iJavaProject, false);
    }

    public static final List<IResource> getWorkspaceLibs(IUnoidlProject iUnoidlProject) {
        return JavaClassPathProvider.getWorkspaceLibs(iUnoidlProject, JavaCore.create((IProject)iUnoidlProject.getProject()), true);
    }

    private static final List<IResource> getWorkspaceLibs(IUnoidlProject iUnoidlProject, IJavaProject iJavaProject, boolean bl) {
        PluginLogger.debug((String)"Collecting Jars from: .classpath");
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        try {
            IClasspathEntry[] iClasspathEntryArray;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            for (IClasspathEntry iClasspathEntry : iClasspathEntryArray = iJavaProject.getResolvedClasspath(true)) {
                IPath iPath = iClasspathEntry.getPath();
                IResource iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null || !iResource.exists()) continue;
                PluginLogger.debug((String)("JavaClassPathProvider.getWorkspaceLibs() lib: " + iPath.toOSString()));
                JavaClassPathProvider.setWorkspaceLibs(iWorkspaceRoot, iUnoidlProject, arrayList, iClasspathEntry, iResource, iPath, bl);
            }
        }
        catch (JavaModelException javaModelException) {
            PluginLogger.error((String)Messages.getString("JavaClassPathProvider.GetWorkspaceLibsFailed"), (Throwable)javaModelException);
        }
        return arrayList;
    }

    private static final void setWorkspaceLibs(IWorkspaceRoot iWorkspaceRoot, IUnoidlProject iUnoidlProject, List<IResource> list, IClasspathEntry iClasspathEntry, IResource iResource, IPath iPath, boolean bl) {
        if (bl && iClasspathEntry.getEntryKind() == 2) {
            IFile iFile = iWorkspaceRoot.getFile(iPath.append("Build.jardesc"));
            if (iFile.exists()) {
                JavaClassPathProvider.setLibsFromProjectJarDesc(iWorkspaceRoot, list, iFile);
            } else if (!JavaClassPathProvider.setLibsFromProjectClass(iWorkspaceRoot, list, iPath)) {
                String string = "Collecting Jars from project: %s can't find Build.jardesc file!!!";
                PluginLogger.error((String)String.format(string, iResource.getName()));
            }
        } else if (iClasspathEntry.getEntryKind() == 1 && !iResource.getProjectRelativePath().equals((Object)iUnoidlProject.getBuildPath()) && (bl || iResource.getProject() == iUnoidlProject.getProject()) && iResource.getType() == 1) {
            list.add(iResource);
        }
    }

    private static final void setLibsFromProjectJarDesc(IWorkspaceRoot iWorkspaceRoot, List<IResource> list, IFile iFile) {
        try {
            IResource iResource;
            String string;
            FileInputStream fileInputStream = new FileInputStream(iFile.getLocation().toFile());
            InputSource inputSource = new InputSource(fileInputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//jardesc/jar");
            Element element = (Element)xPathExpression.evaluate(inputSource, XPathConstants.NODE);
            if (element != null && (string = element.getAttribute("path")) != null && !string.isBlank() && (iResource = iWorkspaceRoot.findMember(string)) != null && iResource.exists() && iResource.getType() == 1) {
                list.add(iResource);
            }
            fileInputStream.close();
        }
        catch (IOException | XPathExpressionException exception) {
            String string = "Collecting Jars can't parse file: %s!!!";
            PluginLogger.debug((String)String.format(string, iFile.getLocation().toOSString()));
        }
    }

    private static final boolean setLibsFromProjectClass(IWorkspaceRoot iWorkspaceRoot, List<IResource> list, IPath iPath) {
        IResource iResource;
        boolean bl = false;
        IFile iFile = iWorkspaceRoot.getFile(iPath.append(".classpath"));
        if (iFile.exists() && (iResource = JavaClassPathProvider.getLibsFromProjectClass(iWorkspaceRoot, list, iPath, iFile)) != null) {
            list.add(iResource);
            bl = true;
        }
        return bl;
    }

    private static final IResource getLibsFromProjectClass(IWorkspaceRoot iWorkspaceRoot, List<IResource> list, IPath iPath, IFile iFile) {
        IFolder iFolder = null;
        try {
            IFolder iFolder2;
            String string;
            FileInputStream fileInputStream = new FileInputStream(iFile.getLocation().toFile());
            InputSource inputSource = new InputSource(fileInputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//classpath/classpathentry[@kind='output']");
            Element element = (Element)xPathExpression.evaluate(inputSource, XPathConstants.NODE);
            if (element != null && (string = element.getAttribute("path")) != null && !string.isBlank() && (iFolder2 = iWorkspaceRoot.getFolder(iPath.append(string))) != null && iFolder2.exists() && iFolder2.getType() == 2) {
                iFolder = iFolder2;
            }
            fileInputStream.close();
        }
        catch (IOException | XPathExpressionException exception) {
            String string = "Collecting Jars can't parse file: %s!!!";
            PluginLogger.debug((String)String.format(string, iFile.getLocation().toOSString()));
        }
        return iFolder;
    }
}

