/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.libreoffice.ide.eclipse.core.launch.IMainProvider;

public class JavaMainProvider
implements IMainProvider {
    public Vector<String> getMainNames(IProject iProject) {
        Vector<String> vector = new Vector<String>();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            vector.addAll(this.getInternalMainNames((IParent)iJavaProject));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    private Vector<String> getInternalMainNames(IParent iParent) {
        Vector<String> vector = new Vector<String>();
        try {
            for (IJavaElement iJavaElement : iParent.getChildren()) {
                IPackageFragmentRoot iPackageFragmentRoot;
                boolean bl = true;
                if (iJavaElement instanceof IPackageFragmentRoot && (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement).getKind() != 1) {
                    bl = false;
                }
                if (!bl) continue;
                if (iJavaElement instanceof ICompilationUnit) {
                    iPackageFragmentRoot = (ICompilationUnit)iJavaElement;
                    IType iType = iPackageFragmentRoot.findPrimaryType();
                    if (!this.isMainImplementation(iType)) continue;
                    vector.add(iType.getFullyQualifiedName());
                    continue;
                }
                if (!(iJavaElement instanceof IParent)) continue;
                vector.addAll(this.getInternalMainNames((IParent)iJavaElement));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    private boolean isMainImplementation(IType iType) {
        boolean bl = false;
        try {
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
            IType[] iTypeArray = iTypeHierarchy.getAllSuperInterfaces(iType);
            int n = 0;
            while (!bl && n < iTypeArray.length) {
                if (iTypeArray[n].getFullyQualifiedName().equals("com.sun.star.lang.XMain")) {
                    bl = true;
                    continue;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

