/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.ide.eclipse.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.libreoffice.ide.eclipse.core.PluginLogger;
import org.libreoffice.ide.eclipse.core.model.IUnoidlProject;
import org.libreoffice.ide.eclipse.core.model.ProjectsManager;
import org.libreoffice.ide.eclipse.core.model.UnoFactoryData;
import org.libreoffice.ide.eclipse.core.model.config.IOOo;
import org.libreoffice.ide.eclipse.core.model.language.IProjectHandler;
import org.libreoffice.ide.eclipse.java.Messages;
import org.libreoffice.ide.eclipse.java.build.OOoContainerPage;
import org.libreoffice.ide.eclipse.java.registration.RegistrationHelper;
import org.libreoffice.ide.eclipse.java.tests.TestsHelper;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JavaProjectHandler
implements IProjectHandler {
    private static final String P_REGISTRATION_CLASSNAME = "regclassname";
    private static final String P_JAVA_VERSION = "javaversion";
    private static final String[] KEPT_JARS = new String[]{"libreoffice.jar", "unoil.jar", "ridl.jar", "juh.jar", "jurt.jar", "unoloader.jar", "officebean.jar", "java_websocket.jar", "unoagent.jar"};

    public void addOOoDependencies(IOOo iOOo, IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        OOoContainerPage.addOOoDependencies(iOOo, iJavaProject);
    }

    public void addProjectNature(IProject iProject) {
        try {
            if (!iProject.exists()) {
                iProject.create(null);
                PluginLogger.debug((String)"Project created during language specific operation");
            }
            if (!iProject.isOpen()) {
                iProject.open(null);
                PluginLogger.debug((String)"Project opened");
            }
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "org.eclipse.jdt.core.javanature";
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, null);
            PluginLogger.debug((String)Messages.getString("Language.JavaNatureSet"));
        }
        catch (CoreException coreException) {
            PluginLogger.error((String)Messages.getString("Language.NatureSettingFailed"));
        }
    }

    public void configureProject(UnoFactoryData unoFactoryData, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = (IProject)unoFactoryData.getProperty("project_handle");
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)iProject.getName());
        String string = RegistrationHelper.getRegistrationClassName(iUnoidlProject);
        iUnoidlProject.setProperty(P_REGISTRATION_CLASSNAME, string);
        String string2 = (String)unoFactoryData.getProperty("java_version");
        iUnoidlProject.setProperty(P_JAVA_VERSION, string2);
        IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(iUnoidlProject.getName());
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject2);
        iJavaProject.open(iProgressMonitor);
        IPath iPath = iUnoidlProject.getFolder(iUnoidlProject.getSourcePath()).getFullPath();
        IPath iPath2 = iUnoidlProject.getFolder(iUnoidlProject.getBuildPath()).getFullPath();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)iPath), JavaRuntime.getDefaultJREContainerEntry(), JavaCore.newLibraryEntry((IPath)iPath2, null, null, (boolean)false)};
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
        RegistrationHelper.generateFiles(iUnoidlProject);
        Boolean bl = (Boolean)unoFactoryData.getProperty("java_tests");
        if (bl.booleanValue()) {
            TestsHelper.writeTestClasses(iUnoidlProject);
            IJavaProject iJavaProject2 = JavaCore.create((IProject)iProject);
            TestsHelper.addJUnitLibraries(iJavaProject2);
        }
    }

    public String getImplementationName(IUnoidlProject iUnoidlProject, String string) throws Exception {
        String string2 = iUnoidlProject.getCompanyPrefix();
        String string3 = iUnoidlProject.getOutputExtension();
        String string4 = null;
        if (!string.startsWith(string2)) {
            throw new Exception("Cannot find implementation name for service: " + string);
        }
        String string5 = string.substring(string2.length());
        string4 = string2 + "." + string3 + string5 + "Impl";
        return string4;
    }

    public IPath getImplementationFile(String string) {
        return new Path(string.replace(".", "/") + ".java");
    }

    public String getSkeletonMakerLanguage(UnoFactoryData unoFactoryData) throws Exception {
        String string = (String)unoFactoryData.getProperty("project_name");
        IUnoidlProject iUnoidlProject = ProjectsManager.getProject((String)string);
        return "--" + iUnoidlProject.getProperty(P_JAVA_VERSION);
    }

    public void removeOOoDependencies(IOOo iOOo, IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        OOoContainerPage.removeOOoDependencies(iJavaProject);
    }

    public String getLibraryPath(IUnoidlProject iUnoidlProject) {
        return this.getJarFile(iUnoidlProject).getLocation().toOSString();
    }

    public IFile getJarFile(IUnoidlProject iUnoidlProject) {
        String string = iUnoidlProject.getName().replace(" ", "") + ".jar";
        return iUnoidlProject.getFile(string);
    }

    public File getJarFile(File file) throws IOException, XPathException {
        String string = this.getName(file).replace(" ", "") + ".jar";
        return new File(file, string);
    }

    private String getName(File file) throws IOException, XPathException {
        String string = null;
        File file2 = new File(file, ".project");
        if (file2.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file2);
            InputSource inputSource = new InputSource(fileInputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//projectDescription/name");
            Node node = (Node)xPathExpression.evaluate(inputSource, XPathConstants.NODE);
            if (node != null) {
                string = node.getTextContent();
            }
        }
        return string;
    }

    public String getRegistrationClassName(IUnoidlProject iUnoidlProject) {
        return iUnoidlProject.getProperty(P_REGISTRATION_CLASSNAME);
    }

    public IFolder[] getBinFolders(IUnoidlProject iUnoidlProject) {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(iUnoidlProject.getName());
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            IClasspathEntry[] iClasspathEntryArray;
            arrayList.add(iWorkspaceRoot.getFolder(iJavaProject.getOutputLocation()));
            for (IClasspathEntry iClasspathEntry : iClasspathEntryArray = iJavaProject.getRawClasspath()) {
                if (iClasspathEntry.getEntryKind() != 3 || iClasspathEntry.getOutputLocation() == null) continue;
                arrayList.add(iWorkspaceRoot.getFolder(iClasspathEntry.getOutputLocation()));
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return arrayList.toArray(new IFolder[arrayList.size()]);
    }

    public static Vector<Path> findJarsFromPath(IOOo iOOo) {
        String[] stringArray;
        Vector<Path> vector = new Vector<Path>();
        for (String string : stringArray = iOOo.getClassesPath()) {
            Path path = new Path(string);
            File file = path.toFile();
            for (String string2 : file.list()) {
                if (!JavaProjectHandler.isKeptJar(string2)) continue;
                Path path2 = new Path(string + "/" + string2);
                vector.add(path2);
            }
        }
        return vector;
    }

    private static boolean isKeptJar(String string) {
        int n = 0;
        boolean bl = false;
        while (n < KEPT_JARS.length && !bl) {
            if (string.equals(KEPT_JARS[n])) {
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }
}

